/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.misc.MathKt;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.energy.IMachineEnergyInterface;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.FloatSyncVariable;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.IntSyncVariable;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\b\u00105\u001a\u00020\bH\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\bH\u0016J\b\u00109\u001a\u000201H\u0016J\b\u0010:\u001a\u00020/H\u0016J\u0010\u0010;\u001a\u00020/2\u0006\u00108\u001a\u00020\bH\u0016R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0010\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010!R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010!\u00a8\u0006="}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "Lcom/cout970/magneticraft/misc/energy/IMachineEnergyInterface;", "mainNode", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "initialCapacity", "", "initialMaxChargeSpeed", "", "initialUpperVoltageLimit", "initialLowerVoltageLimit", "name", "", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;IDDDLjava/lang/String;)V", "capacity", "getCapacity", "()I", "chargeRate", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getChargeRate", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "energy", "getEnergy", "setEnergy", "(I)V", "getInitialCapacity", "getInitialLowerVoltageLimit", "()D", "getInitialMaxChargeSpeed", "getInitialUpperVoltageLimit", "lowerVoltageLimit", "getLowerVoltageLimit", "getMainNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "maxChargeSpeed", "getMaxChargeSpeed", "getName", "()Ljava/lang/String;", "upperVoltageLimit", "getUpperVoltageLimit", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "getSpeed", "hasEnergy", "", "amount", "serializeNBT", "update", "useEnergy", "Companion", "Magneticraft_1.12"})
public final class ModuleInternalStorage
implements IModule,
IMachineEnergyInterface {
    @NotNull
    public IModuleContainer container;
    private int energy;
    @NotNull
    private final ValueAverage chargeRate;
    @NotNull
    private final IElectricNode mainNode;
    private final int initialCapacity;
    private final double initialMaxChargeSpeed;
    private final double initialUpperVoltageLimit;
    private final double initialLowerVoltageLimit;
    @NotNull
    private final String name;
    public static final int INTERVAL = 10;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final int getCapacity() {
        return (int)((double)this.initialCapacity * Config.INSTANCE.getMachineEnergyStorageMultiplier());
    }

    public final double getMaxChargeSpeed() {
        return this.initialMaxChargeSpeed * Config.INSTANCE.getMaxChargeSpeedMultiplier();
    }

    public final double getUpperVoltageLimit() {
        return this.initialUpperVoltageLimit + Config.INSTANCE.getUpperVoltageLimitOffset();
    }

    public final double getLowerVoltageLimit() {
        return this.initialLowerVoltageLimit + Config.INSTANCE.getLowerVoltageLimitOffset();
    }

    public final int getEnergy() {
        return this.energy;
    }

    public final void setEnergy(int n) {
        this.energy = n;
    }

    @NotNull
    public final ValueAverage getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public void update() {
        World $this$isServer$iv = this.getWorld();
        boolean $i$f$isServer = false;
        if (!$this$isServer$iv.field_72995_K) {
            double speed;
            int finalSpeed;
            if (this.mainNode.getVoltage() > this.getUpperVoltageLimit()) {
                double speed2 = MathKt.interpolate(this.mainNode.getVoltage(), this.getUpperVoltageLimit(), this.getUpperVoltageLimit() + (double)10) * this.getMaxChargeSpeed();
                int finalSpeed2 = Math.min((int)Math.floor(speed2), this.getCapacity() - this.energy);
                if (finalSpeed2 != 0) {
                    this.mainNode.applyPower(-((double)finalSpeed2), false);
                    this.energy += finalSpeed2;
                    this.chargeRate.plusAssign(finalSpeed2);
                }
            } else if (this.mainNode.getVoltage() < this.getLowerVoltageLimit() && (finalSpeed = Math.min((int)Math.floor(speed = (1.0 - MathKt.interpolate(this.mainNode.getVoltage(), this.getLowerVoltageLimit(), this.getLowerVoltageLimit() + (double)10)) * this.getMaxChargeSpeed()), this.energy)) != 0) {
                this.mainNode.applyPower(finalSpeed, false);
                this.energy -= finalSpeed;
                this.chargeRate.minusAssign(finalSpeed);
            }
            this.chargeRate.tick();
        }
    }

    @Override
    public double getSpeed() {
        return (double)this.energy / (double)this.getCapacity();
    }

    @Override
    public boolean hasEnergy(double amount) {
        return (double)this.energy >= amount;
    }

    @Override
    public void useEnergy(double amount) {
        this.energy = Math.max(0, this.energy - (int)amount);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.energy = nbt2.func_74762_e("energy");
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleInternalStorage this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "energy", this.this$0.getEnergy());
            }
            {
                this.this$0 = moduleInternalStorage;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object[])new SyncVariable[]{new IntSyncVariable(8, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleInternalStorage this$0;

            public final int invoke() {
                return this.this$0.getEnergy();
            }
            {
                this.this$0 = moduleInternalStorage;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleInternalStorage this$0;

            public final void invoke(int it) {
                this.this$0.setEnergy(it);
            }
            {
                this.this$0 = moduleInternalStorage;
                super(1);
            }
        })), new FloatSyncVariable(9, (Function0<Float>)((Function0)new Function0<Float>(this){
            final /* synthetic */ ModuleInternalStorage this$0;

            public final float invoke() {
                return this.this$0.getChargeRate().getAverage();
            }
            {
                this.this$0 = moduleInternalStorage;
                super(0);
            }
        }), (Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this){
            final /* synthetic */ ModuleInternalStorage this$0;

            public final void invoke(float it) {
                this.this$0.getChargeRate().setStorage(it);
            }
            {
                this.this$0 = moduleInternalStorage;
                super(1);
            }
        }))});
    }

    @NotNull
    public final IElectricNode getMainNode() {
        return this.mainNode;
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final double getInitialMaxChargeSpeed() {
        return this.initialMaxChargeSpeed;
    }

    public final double getInitialUpperVoltageLimit() {
        return this.initialUpperVoltageLimit;
    }

    public final double getInitialLowerVoltageLimit() {
        return this.initialLowerVoltageLimit;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleInternalStorage(@NotNull IElectricNode mainNode, int initialCapacity, double initialMaxChargeSpeed, double initialUpperVoltageLimit, double initialLowerVoltageLimit, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)mainNode, (String)"mainNode");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.mainNode = mainNode;
        this.initialCapacity = initialCapacity;
        this.initialMaxChargeSpeed = initialMaxChargeSpeed;
        this.initialUpperVoltageLimit = initialUpperVoltageLimit;
        this.initialLowerVoltageLimit = initialLowerVoltageLimit;
        this.name = name;
        this.chargeRate = new ValueAverage(20);
    }

    public /* synthetic */ ModuleInternalStorage(IElectricNode iElectricNode, int n, double d, double d2, double d3, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            d = 200.0;
        }
        if ((n2 & 8) != 0) {
            d2 = 60.0;
        }
        if ((n2 & 0x10) != 0) {
            d3 = 60.0;
        }
        if ((n2 & 0x20) != 0) {
            string = "module_electric_storage";
        }
        this(iElectricNode, n, d, d2, d3, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage$Companion;", "", "()V", "INTERVAL", "", "Magneticraft_1.12"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

