/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00060\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\r\u001a\u00020\u000eX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R)\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleFluidExporter;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "tank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "ports", "Lkotlin/Function0;", "", "Lkotlin/Pair;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/util/EnumFacing;", "name", "", "(Lcom/cout970/magneticraft/misc/fluid/Tank;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getName", "()Ljava/lang/String;", "getPorts", "()Lkotlin/jvm/functions/Function0;", "getTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "update", "", "Magneticraft_1.12"})
public final class ModuleFluidExporter
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private final Tank tank;
    @NotNull
    private final Function0<List<Pair<BlockPos, EnumFacing>>> ports;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @Override
    public void update() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"tank.fluid ?: return");
        FluidStack stack = fluidStack;
        if (stack.amount <= 0) {
            return;
        }
        for (Pair pair : (List)this.ports.invoke()) {
            FluidStack newStack;
            IFluidHandler handler;
            TileEntity tile;
            BlockPos off = (BlockPos)pair.component1();
            EnumFacing dir = (EnumFacing)pair.component2();
            if (this.getWorld().func_175625_s(this.getPos().func_177971_a((Vec3i)off)) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)tile, (String)"world.getTileEntity(pos.add(off)) ?: continue");
            if (CapabilitiesKt.getOrNull(tile, CapabilitiesKt.getFLUID_HANDLER(), dir) == null) {
                continue;
            }
            int amount = handler.fill(stack, false);
            if (amount <= 0) continue;
            handler.fill(new FluidStack(stack, amount), true);
            this.tank.drainInternal(amount, true);
            if (this.tank.getFluid() == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)newStack, (String)"tank.fluid ?: return");
            if (newStack.amount > 0) continue;
            return;
        }
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    @NotNull
    public final Function0<List<Pair<BlockPos, EnumFacing>>> getPorts() {
        return this.ports;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleFluidExporter(@NotNull Tank tank2, @NotNull Function0<? extends List<? extends Pair<? extends BlockPos, ? extends EnumFacing>>> ports, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tank2), (String)"tank");
        Intrinsics.checkParameterIsNotNull(ports, (String)"ports");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.tank = tank2;
        this.ports = ports;
        this.name = name;
    }

    public /* synthetic */ ModuleFluidExporter(Tank tank2, Function0 function0, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "module_fluid_exporter";
        }
        this(tank2, (Function0<? extends List<? extends Pair<? extends BlockPos, ? extends EnumFacing>>>)function0, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        IModule.DefaultImpls.deserializeNBT(this, nbt2);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return IModule.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return IModule.DefaultImpls.getGuiSyncVariables(this);
    }
}

