/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.internal.registries.machines.crushingtable.CrushingTableRecipeManager;
import com.cout970.magneticraft.api.internal.registries.tool.hammer.HammerRegistry;
import com.cout970.magneticraft.api.registries.machines.crushingtable.ICrushingTableRecipe;
import com.cout970.magneticraft.api.registries.tool.hammer.IHammer;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.misc.vector.Vec3dKt;
import com.cout970.magneticraft.misc.vector.Vec3iKt;
import com.cout970.magneticraft.registry.Sounds;
import com.cout970.magneticraft.systems.blocks.IOnActivated;
import com.cout970.magneticraft.systems.blocks.OnActivatedArgs;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fJ\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J\u001e\u00100\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J&\u00105\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020\u0017R\u001a\u0010\b\u001a\u00020\tX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001b\u00a8\u00067"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleCrushingTable;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "Lcom/cout970/magneticraft/systems/blocks/IOnActivated;", "inventory", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "name", "", "(Lcom/cout970/magneticraft/misc/inventory/Inventory;Ljava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "damageTaken", "", "getDamageTaken", "()I", "setDamageTaken", "(I)V", "getInventory", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "lastItem", "Lnet/minecraft/item/ItemStack;", "getLastItem", "()Lnet/minecraft/item/ItemStack;", "setLastItem", "(Lnet/minecraft/item/ItemStack;)V", "getName", "()Ljava/lang/String;", "value", "storedItem", "getStoredItem", "setStoredItem", "crushItem", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "damage", "hasWork", "", "onActivated", "args", "Lcom/cout970/magneticraft/systems/blocks/OnActivatedArgs;", "placeItemFromPlayer", "heldItem", "hand", "Lnet/minecraft/util/EnumHand;", "spawnParticles", "useHammer", "Companion", "Magneticraft_1.12"})
public final class ModuleCrushingTable
implements IModule,
IOnActivated {
    @NotNull
    public IModuleContainer container;
    private int damageTaken;
    @NotNull
    private ItemStack lastItem;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final String name;
    public static final int CRUSHING_DAMAGE = 40;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final int getDamageTaken() {
        return this.damageTaken;
    }

    public final void setDamageTaken(int n) {
        this.damageTaken = n;
    }

    @NotNull
    public final ItemStack getLastItem() {
        return this.lastItem;
    }

    public final void setLastItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"<set-?>");
        this.lastItem = itemStack;
    }

    @NotNull
    public final ItemStack getStoredItem() {
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.getStackInSlot(0)");
        return itemStack;
    }

    public final void setStoredItem(@NotNull ItemStack value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.inventory.setStackInSlot(0, value2);
    }

    @Override
    public boolean onActivated(@NotNull OnActivatedArgs args) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        OnActivatedArgs onActivatedArgs = args;
        boolean bl2 = false;
        boolean bl3 = false;
        OnActivatedArgs $this$run = onActivatedArgs;
        boolean bl4 = false;
        if ($this$run.getSide() != EnumFacing.UP || $this$run.getHand() == EnumHand.OFF_HAND) {
            return false;
        }
        if (InventoriesKt.isNotEmpty(this.getStoredItem())) {
            this.useHammer($this$run.getWorldIn(), $this$run.getPos(), $this$run.getPlayerIn(), $this$run.getHeldItem());
            bl = true;
        } else {
            bl = this.placeItemFromPlayer($this$run.getPlayerIn(), $this$run.getHeldItem(), $this$run.getHand());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean placeItemFromPlayer(@NotNull EntityPlayer playerIn, @NotNull ItemStack heldItem, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (InventoriesKt.isNotEmpty(heldItem)) {
            IHammer hammer = HammerRegistry.INSTANCE.findHammer(heldItem);
            if (hammer != null) {
                if (InventoriesKt.isNotEmpty(this.lastItem)) {
                    int n = 0;
                    InventoryPlayer inventoryPlayer = playerIn.field_71071_by;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"playerIn.inventory");
                    int n2 = inventoryPlayer.func_70302_i_();
                    while (n < n2) {
                        void slot;
                        ItemStack stack;
                        ItemStack itemStack = stack = playerIn.field_71071_by.func_70301_a((int)slot);
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                        if (InventoriesKt.isNotEmpty(itemStack) && CrushingTableRecipeManager.INSTANCE.findRecipe(stack) != null && this.lastItem.func_77969_a(stack)) {
                            this.setStoredItem(InventoriesKt.withSize(stack, 1));
                            ItemStack itemStack2 = stack;
                            int n3 = itemStack2.func_190916_E();
                            itemStack2.func_190920_e(n3 + -1);
                            if (stack.func_190916_E() <= 0) {
                                playerIn.field_71071_by.func_70299_a((int)slot, ItemStack.field_190927_a);
                            }
                            this.getContainer().sendUpdateToNearPlayers();
                            return true;
                        }
                        ++slot;
                    }
                }
            } else {
                ItemStack itemStack;
                ItemStack itemStack3 = heldItem.func_77946_l();
                ModuleCrushingTable moduleCrushingTable = this;
                boolean bl = false;
                boolean bl2 = false;
                ItemStack $this$apply = itemStack3;
                boolean bl3 = false;
                $this$apply.func_190920_e(1);
                ItemStack itemStack4 = itemStack = itemStack3;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"heldItem.copy().apply { count = 1 }");
                moduleCrushingTable.setStoredItem(itemStack4);
                ItemStack itemStack5 = heldItem;
                int n = itemStack5.func_190916_E();
                itemStack5.func_190920_e(n + -1);
                if (heldItem.func_190916_E() <= 0) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                }
                this.getContainer().sendUpdateToNearPlayers();
                return true;
            }
        }
        return false;
    }

    public final boolean hasWork() {
        if (this.getStoredItem().func_190926_b()) {
            return false;
        }
        return CrushingTableRecipeManager.INSTANCE.findRecipe(this.getStoredItem()) != null;
    }

    public final void useHammer(@NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer playerIn, @NotNull ItemStack heldItem) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)heldItem, (String)"heldItem");
        IHammer hammer = HammerRegistry.INSTANCE.findHammer(heldItem);
        if (this.hasWork() && hammer != null) {
            if (Companion.getCrushingLevel(this.getStoredItem()) > hammer.getMiningLevel()) {
                return;
            }
            this.crushItem(world, pos, playerIn, hammer.getBreakingSpeed());
            if (Config.INSTANCE.getCrushingTableCausesFire() && this.getStoredItem().func_77969_a(new ItemStack(Items.field_151072_bj))) {
                playerIn.func_70015_d(5);
            }
            heldItem.func_77972_a(hammer.getDurabilityCost(), (EntityLivingBase)playerIn);
        } else if (playerIn.field_71071_by.func_70441_a(this.getStoredItem())) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            this.setStoredItem(itemStack);
            this.getContainer().sendUpdateToNearPlayers();
        }
    }

    public final void crushItem(@NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer playerIn, int damage) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        ICrushingTableRecipe iCrushingTableRecipe = CrushingTableRecipeManager.INSTANCE.findRecipe(this.getStoredItem());
        if (iCrushingTableRecipe == null) {
            return;
        }
        ICrushingTableRecipe recipe = iCrushingTableRecipe;
        this.damageTaken += damage;
        if (this.damageTaken >= 40) {
            World $this$isClient$iv = world;
            boolean $i$f$isClient = false;
            if ($this$isClient$iv.field_72995_K) {
                world.func_184134_a(BlockPosKt.getXd(pos), BlockPosKt.getYd(pos), BlockPosKt.getZd(pos), Sounds.CRUSHING_FINAL.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                this.spawnParticles(world, pos);
            }
            this.lastItem = this.getStoredItem();
            ItemStack itemStack = recipe.getOutput();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"recipe.output");
            this.setStoredItem(itemStack);
            this.damageTaken = 0;
        } else {
            World $this$isClient$iv = world;
            boolean $i$f$isClient = false;
            if ($this$isClient$iv.field_72995_K) {
                world.func_184134_a(BlockPosKt.getXd(pos), BlockPosKt.getYd(pos), BlockPosKt.getZd(pos), Sounds.CRUSHING_HIT.getSoundEvent(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                this.spawnParticles(world, pos);
            }
        }
        this.getContainer().sendUpdateToNearPlayers();
    }

    /*
     * WARNING - void declaration
     */
    public final void spawnParticles(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Vec3d center = Vec3dKt.plus(Vec3iKt.toVec3d((Vec3i)pos), Vec3dKt.vec3Of(0.5, 0.95, 0.5));
        Item item = this.getStoredItem().func_77973_b();
        if (item instanceof ItemBlock) {
            IBlockState state = ((ItemBlock)item).func_179223_d().func_176203_a(this.getStoredItem().func_77960_j());
            ParticleDigging.Factory factory = new ParticleDigging.Factory();
            Random rand2 = new Random();
            int n = 0;
            int n2 = 5;
            while (n <= n2) {
                void i;
                Particle particle2;
                void $this$zd$iv;
                Vec3d $this$yd$iv;
                Vec3d $this$xd$iv;
                Vec3d vec3d = center;
                World world2 = world;
                int n3 = EnumParticleTypes.BLOCK_DUST.func_179348_c();
                ParticleDigging.Factory factory2 = factory;
                boolean $i$f$getXd = false;
                double d = $this$xd$iv.field_72450_a;
                $this$xd$iv = center;
                boolean $i$f$getYd = false;
                double d2 = $this$yd$iv.field_72448_b;
                $this$yd$iv = center;
                boolean $i$f$getZd = false;
                double d3 = $this$zd$iv.field_72449_c;
                if (factory2.func_178902_a(n3, world2, d, d2, d3, (rand2.nextDouble() - 0.5) * 0.15, rand2.nextDouble() * 0.2, (rand2.nextDouble() - 0.5) * 0.15, new int[]{Block.func_176210_f((IBlockState)state)}) == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)particle2, (String)"factory.createParticle(E\u2026lock.getStateId(state))!!");
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle2);
                ++i;
            }
        } else {
            ParticleBreaking.Factory factory = new ParticleBreaking.Factory();
            Random rand = new Random();
            int rand2 = 0;
            int n = 5;
            while (rand2 <= n) {
                void i;
                Particle particle;
                void $this$zd$iv;
                Vec3d $this$yd$iv;
                Vec3d $this$xd$iv;
                Vec3d particle2 = center;
                World world3 = world;
                int n4 = EnumParticleTypes.BLOCK_DUST.func_179348_c();
                ParticleBreaking.Factory factory3 = factory;
                boolean $i$f$getXd = false;
                double d = $this$xd$iv.field_72450_a;
                $this$xd$iv = center;
                boolean $i$f$getYd = false;
                double d4 = $this$yd$iv.field_72448_b;
                $this$yd$iv = center;
                boolean $i$f$getZd = false;
                double d5 = $this$zd$iv.field_72449_c;
                if (factory3.func_178902_a(n4, world3, d, d4, d5, (rand.nextDouble() - 0.5) * 0.15, rand.nextDouble() * 0.2, (rand.nextDouble() - 0.5) * 0.15, new int[]{Item.func_150891_b((Item)item), this.getStoredItem().func_77952_i()}) == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)particle, (String)"factory.createParticle(E\u2026 storedItem.itemDamage)!!");
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                ++i;
            }
        }
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleCrushingTable(@NotNull Inventory inventory2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory2), (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.inventory = inventory2;
        this.name = name;
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.lastItem = itemStack;
    }

    public /* synthetic */ ModuleCrushingTable(Inventory inventory2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "module_crushing_table";
        }
        this(inventory2, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void update() {
        IModule.DefaultImpls.update(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        IModule.DefaultImpls.deserializeNBT(this, nbt2);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return IModule.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return IModule.DefaultImpls.getGuiSyncVariables(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleCrushingTable$Companion;", "", "()V", "CRUSHING_DAMAGE", "", "getCrushingLevel", "storedItem", "Lnet/minecraft/item/ItemStack;", "Magneticraft_1.12"})
    public static final class Companion {
        public final int getCrushingLevel(@NotNull ItemStack storedItem) {
            Intrinsics.checkParameterIsNotNull((Object)storedItem, (String)"storedItem");
            Item item = storedItem.func_77973_b();
            if (item instanceof ItemBlock) {
                IBlockState blockState = ((ItemBlock)item).func_179223_d().func_176203_a(storedItem.func_77960_j());
                return ((ItemBlock)item).func_179223_d().getHarvestLevel(blockState);
            }
            return -1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

