/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuel;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.IntSyncVariable;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.tileentity.WorkingIndicator;
import com.cout970.magneticraft.misc.vector.EnumFacingKt;
import com.cout970.magneticraft.misc.vector.Vec3dKt;
import com.cout970.magneticraft.misc.vector.Vec3iKt;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000206J\u0006\u00108\u001a\u000206J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J\b\u0010@\u001a\u00020<H\u0016J\u0006\u0010A\u001a\u00020:J\b\u0010B\u001a\u00020:H\u0016J\u0012\u0010C\u001a\u00060Dj\u0002`E*\u00060Fj\u0002`GJ:\u0010A\u001a\u00020:*\u00020H2\u0006\u0010I\u001a\u00020J2\n\u0010K\u001a\u00060Fj\u0002`G2\u0006\u0010L\u001a\u00020\u00162\n\u0010M\u001a\u00060Dj\u0002`E2\u0006\u0010N\u001a\u00020OR\u001a\u0010\u0010\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0012R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006P"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleBigCombustionChamber;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "facing", "Lkotlin/Function0;", "Lnet/minecraft/util/EnumFacing;", "heatNode", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "inventory", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "tank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "maxHeat", "", "name", "", "(Lkotlin/jvm/functions/Function0;Lcom/cout970/magneticraft/api/heat/IHeatNode;Lcom/cout970/magneticraft/misc/inventory/Inventory;Lcom/cout970/magneticraft/misc/fluid/Tank;DLjava/lang/String;)V", "burningPower", "getBurningPower", "()D", "setBurningPower", "(D)V", "burningTime", "", "getBurningTime", "()I", "setBurningTime", "(I)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getFacing", "()Lkotlin/jvm/functions/Function0;", "getHeatNode", "()Lcom/cout970/magneticraft/api/heat/IHeatNode;", "getInventory", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "maxBurningTime", "getMaxBurningTime", "setMaxBurningTime", "getMaxHeat", "getName", "()Ljava/lang/String;", "getTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "working", "Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;", "getWorking", "()Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;", "setWorking", "(Lcom/cout970/magneticraft/misc/tileentity/WorkingIndicator;)V", "burnLiquidFuel", "", "burnSolidFuel", "consumeFuel", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "serializeNBT", "spawnParticles", "update", "size", "Lnet/minecraft/util/math/Vec3d;", "Lcom/cout970/magneticraft/IVector3;", "Lnet/minecraft/util/math/AxisAlignedBB;", "Lcom/cout970/magneticraft/AABB;", "Lnet/minecraft/world/World;", "particle", "Lnet/minecraft/util/EnumParticleTypes;", "area", "amount", "direction", "variability", "", "Magneticraft_1.12"})
public final class ModuleBigCombustionChamber
implements IModule {
    @NotNull
    public IModuleContainer container;
    @NotNull
    private WorkingIndicator working;
    private int burningTime;
    private double burningPower;
    private int maxBurningTime;
    @NotNull
    private final Function0<EnumFacing> facing;
    @NotNull
    private final IHeatNode heatNode;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final Tank tank;
    private final double maxHeat;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @NotNull
    public final WorkingIndicator getWorking() {
        return this.working;
    }

    public final void setWorking(@NotNull WorkingIndicator workingIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)workingIndicator, (String)"<set-?>");
        this.working = workingIndicator;
    }

    public final int getBurningTime() {
        return this.burningTime;
    }

    public final void setBurningTime(int n) {
        this.burningTime = n;
    }

    public final double getBurningPower() {
        return this.burningPower;
    }

    public final void setBurningPower(double d) {
        this.burningPower = d;
    }

    public final int getMaxBurningTime() {
        return this.maxBurningTime;
    }

    public final void setMaxBurningTime(int n) {
        this.maxBurningTime = n;
    }

    @Override
    public void update() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            this.spawnParticles();
            return;
        }
        if (this.maxBurningTime > 0) {
            if (this.burningTime > this.maxBurningTime) {
                this.burningTime -= this.maxBurningTime;
                this.maxBurningTime = 0;
            } else if (this.heatNode.getTemperature() < this.maxHeat) {
                int speed = (int)Config.INSTANCE.getBigCombustionChamberMaxSpeed();
                this.burningTime += speed;
                this.heatNode.applyHeat((double)speed * this.burningPower);
                this.working.onWork();
            }
        }
        while (this.maxBurningTime <= 0 && this.consumeFuel()) {
        }
        if (this.maxBurningTime <= 0 && this.heatNode.getTemperature() > HeatKt.getSTANDARD_AMBIENT_TEMPERATURE()) {
            this.heatNode.applyHeat(Config.INSTANCE.getHeatDissipationSpeed());
        }
        this.working.tick();
    }

    public final void spawnParticles() {
        if (this.working.invoke() && Config.INSTANCE.getEnableMachineParticles() == 1) {
            double d;
            int $this$px$iv = -8;
            boolean $i$f$getPx = false;
            double d2 = (double)$this$px$iv * 0.0625;
            $this$px$iv = 2;
            $i$f$getPx = false;
            double d3 = (double)$this$px$iv * 0.0625;
            $this$px$iv = 12;
            $i$f$getPx = false;
            double d4 = (double)$this$px$iv * 0.0625;
            $this$px$iv = 24;
            $i$f$getPx = false;
            double d5 = (double)$this$px$iv * 0.0625;
            $this$px$iv = 14;
            $i$f$getPx = false;
            double d6 = (double)$this$px$iv * 0.0625;
            $this$px$iv = 16;
            $i$f$getPx = false;
            double d7 = d = (double)$this$px$iv * 0.0625;
            double d8 = d6;
            double d9 = d5;
            double d10 = d4;
            double d11 = d3;
            double d12 = d2;
            AxisAlignedBB flameLocalArea = new AxisAlignedBB(d12, d11, d10, d9, d8, d7);
            EnumFacing enumFacing = (EnumFacing)this.facing.invoke();
            Vec3d vec3d = Vec3dKt.plus(Vec3iKt.toVec3d((Vec3i)this.getPos()), Vec3dKt.vec3Of(0.5));
            AxisAlignedBB axisAlignedBB = flameLocalArea.func_186670_a(this.getPos());
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB, (String)"flameLocalArea.offset(pos)");
            AxisAlignedBB flameArea = EnumFacingKt.rotateBox(enumFacing, vec3d, axisAlignedBB);
            this.spawnParticles(this.getWorld(), EnumParticleTypes.FLAME, flameArea, 2, Vec3dKt.vec3Of((Number)0, (Number)0.005, (Number)0), 0.01f);
            int $this$px$iv2 = 4;
            boolean $i$f$getPx2 = false;
            d2 = (double)$this$px$iv2 * 0.0625;
            $this$px$iv2 = 30;
            $i$f$getPx2 = false;
            d3 = (double)$this$px$iv2 * 0.0625;
            $this$px$iv2 = -36;
            $i$f$getPx2 = false;
            d4 = (double)$this$px$iv2 * 0.0625;
            $this$px$iv2 = 12;
            $i$f$getPx2 = false;
            d5 = (double)$this$px$iv2 * 0.0625;
            $this$px$iv2 = 32;
            $i$f$getPx2 = false;
            d6 = (double)$this$px$iv2 * 0.0625;
            $this$px$iv2 = -44;
            $i$f$getPx2 = false;
            double d13 = d = (double)$this$px$iv2 * 0.0625;
            double d14 = d6;
            double d15 = d5;
            double d16 = d4;
            double d17 = d3;
            double d18 = d2;
            AxisAlignedBB smokeLocalArea = new AxisAlignedBB(d18, d17, d16, d15, d14, d13);
            EnumFacing enumFacing2 = (EnumFacing)this.facing.invoke();
            Vec3d vec3d2 = Vec3dKt.plus(Vec3iKt.toVec3d((Vec3i)this.getPos()), Vec3dKt.vec3Of(0.5));
            AxisAlignedBB axisAlignedBB2 = smokeLocalArea.func_186670_a(this.getPos());
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB2, (String)"smokeLocalArea.offset(pos)");
            AxisAlignedBB smokeArea = EnumFacingKt.rotateBox(enumFacing2, vec3d2, axisAlignedBB2);
            this.spawnParticles(this.getWorld(), EnumParticleTypes.SMOKE_LARGE, smokeArea, 2, Vec3dKt.vec3Of((Number)0, (Number)0.01, (Number)0), 0.0025f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void spawnParticles(@NotNull World $this$spawnParticles, @NotNull EnumParticleTypes particle, @NotNull AxisAlignedBB area, int amount, @NotNull Vec3d direction, float variability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$spawnParticles, (String)"$this$spawnParticles");
        Intrinsics.checkParameterIsNotNull((Object)particle, (String)"particle");
        Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Vec3d size = this.size(area);
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = amount;
        while (n < n2) {
            void $this$zf$iv;
            Vec3d $this$yf$iv;
            void $this$zf$iv2;
            Vec3d $this$yf$iv2;
            Vec3d $this$xf$iv;
            int it = n++;
            boolean bl2 = false;
            Vec3d vec3d = size;
            float f = $this$spawnParticles.field_73012_v.nextFloat();
            double d = area.field_72340_a;
            boolean $i$f$getXf = false;
            float f2 = (float)$this$xf$iv.field_72450_a;
            $this$xf$iv = size;
            float f3 = $this$spawnParticles.field_73012_v.nextFloat();
            double d2 = area.field_72338_b;
            d += (double)(f * f2);
            boolean $i$f$getYf = false;
            float f4 = (float)$this$yf$iv2.field_72448_b;
            $this$yf$iv2 = size;
            float f5 = $this$spawnParticles.field_73012_v.nextFloat();
            double d3 = area.field_72339_c;
            boolean $i$f$getZf = false;
            float f6 = (float)$this$zf$iv2.field_72449_c;
            Vec3d pos = Vec3dKt.vec3Of(d, d2 += (double)(f3 * f4), d3 + (double)(f5 * f6));
            Vec3d $this$xf$iv2 = direction;
            boolean $i$f$getXf2 = false;
            $this$xf$iv2 = direction;
            float f7 = (float)$this$xf$iv2.field_72450_a + ($this$spawnParticles.field_73012_v.nextFloat() * (float)2 - 1.0f) * variability;
            boolean $i$f$getYf2 = false;
            float f8 = (float)$this$yf$iv.field_72448_b;
            $this$yf$iv = direction;
            boolean $i$f$getZf2 = false;
            f = (float)$this$zf$iv.field_72449_c;
            Vec3d dir = Vec3dKt.vec3Of(f7, f8 += ($this$spawnParticles.field_73012_v.nextFloat() * (float)2 - 1.0f) * variability, f + ($this$spawnParticles.field_73012_v.nextFloat() * (float)2 - 1.0f) * variability);
            $this$spawnParticles.func_175688_a(particle, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, new int[0]);
        }
    }

    @NotNull
    public final Vec3d size(@NotNull AxisAlignedBB $this$size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$size, (String)"$this$size");
        return Vec3dKt.vec3Of($this$size.field_72336_d - $this$size.field_72340_a, $this$size.field_72337_e - $this$size.field_72338_b, $this$size.field_72334_f - $this$size.field_72339_c);
    }

    public final boolean consumeFuel() {
        return this.burnSolidFuel() || this.burnLiquidFuel();
    }

    public final boolean burnSolidFuel() {
        ItemStack stack = InventoriesKt.get((IItemHandler)this.inventory, 0);
        if (stack.func_190926_b()) {
            return false;
        }
        int time = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (time > 0) {
            stack.func_190918_g(1);
            this.burningPower = Config.INSTANCE.getFuelToJoules();
            this.maxBurningTime = time;
            return true;
        }
        return false;
    }

    public final boolean burnLiquidFuel() {
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"tank.fluid ?: return false");
        FluidStack fluid = fluidStack;
        int fluidAmount = RangesKt.coerceAtMost((int)this.tank.getFluidAmount(), (int)100);
        if (fluidAmount <= 0) {
            return false;
        }
        IFluidFuel iFluidFuel = MagneticraftApi.getFluidFuelManager().findFuel(fluid);
        if (iFluidFuel == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)iFluidFuel, (String)"MagneticraftApi.getFluid\u2026el(fluid) ?: return false");
        IFluidFuel fuel = iFluidFuel;
        int fraction = MathKt.roundToInt((float)((float)(fluidAmount * fuel.getTotalBurningTime()) / 1000.0f));
        if (fraction <= 0) {
            return false;
        }
        this.tank.drain(fluidAmount, true);
        this.burningPower = fuel.getPowerPerCycle() * Config.INSTANCE.getBigCombustionChamberLiquidFuelMultiplier();
        this.maxBurningTime = fraction;
        return true;
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleBigCombustionChamber this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "burningTime", this.this$0.getBurningTime());
                NBTKt.add($this$newNbt, "maxBurningTime", this.this$0.getMaxBurningTime());
                NBTKt.add($this$newNbt, "working", this.this$0.getWorking().serializeNBT());
            }
            {
                this.this$0 = moduleBigCombustionChamber;
                super(1);
            }
        }));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        this.burningTime = nbt2.func_74762_e("burningTime");
        this.maxBurningTime = nbt2.func_74762_e("maxBurningTime");
        NBTTagCompound nBTTagCompound = nbt2.func_74775_l("working");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"nbt.getCompoundTag(\"working\")");
        this.working.deserializeNBT(nBTTagCompound);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object[])new IntSyncVariable[]{new IntSyncVariable(2, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleBigCombustionChamber this$0;

            public final int invoke() {
                return this.this$0.getBurningTime();
            }
            {
                this.this$0 = moduleBigCombustionChamber;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleBigCombustionChamber this$0;

            public final void invoke(int it) {
                this.this$0.setBurningTime(it);
            }
            {
                this.this$0 = moduleBigCombustionChamber;
                super(1);
            }
        })), new IntSyncVariable(3, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ModuleBigCombustionChamber this$0;

            public final int invoke() {
                return this.this$0.getMaxBurningTime();
            }
            {
                this.this$0 = moduleBigCombustionChamber;
                super(0);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ModuleBigCombustionChamber this$0;

            public final void invoke(int it) {
                this.this$0.setMaxBurningTime(it);
            }
            {
                this.this$0 = moduleBigCombustionChamber;
                super(1);
            }
        }))});
    }

    @NotNull
    public final Function0<EnumFacing> getFacing() {
        return this.facing;
    }

    @NotNull
    public final IHeatNode getHeatNode() {
        return this.heatNode;
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    public final double getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleBigCombustionChamber(@NotNull Function0<? extends EnumFacing> facing, @NotNull IHeatNode heatNode, @NotNull Inventory inventory2, @NotNull Tank tank2, double maxHeat, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull(facing, (String)"facing");
        Intrinsics.checkParameterIsNotNull((Object)heatNode, (String)"heatNode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inventory2), (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)tank2), (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.facing = facing;
        this.heatNode = heatNode;
        this.inventory = inventory2;
        this.tank = tank2;
        this.maxHeat = maxHeat;
        this.name = name;
        this.working = new WorkingIndicator(this, 0, 2, null);
        this.burningPower = Config.INSTANCE.getFuelToJoules();
    }

    public /* synthetic */ ModuleBigCombustionChamber(Function0 function0, IHeatNode iHeatNode, Inventory inventory2, Tank tank2, double d, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string = "module_big_combustion_chamber";
        }
        this((Function0<? extends EnumFacing>)function0, iHeatNode, inventory2, tank2, d, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }
}

