/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.multiblocks;

import com.cout970.magneticraft.Debug;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.systems.multiblocks.BlockData;
import com.cout970.magneticraft.systems.multiblocks.IMultiblockComponent;
import com.cout970.magneticraft.systems.multiblocks.Multiblock;
import com.cout970.magneticraft.systems.multiblocks.MultiblockContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0016R)\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/cout970/magneticraft/systems/multiblocks/ContextBlockComponent;", "Lcom/cout970/magneticraft/systems/multiblocks/IMultiblockComponent;", "getter", "Lkotlin/Function1;", "Lcom/cout970/magneticraft/systems/multiblocks/MultiblockContext;", "Lnet/minecraft/block/state/IBlockState;", "stack", "Lnet/minecraft/item/ItemStack;", "replacement", "errorMsg", "Lkotlin/Function3;", "Lnet/minecraft/util/math/BlockPos;", "Lnet/minecraft/util/text/ITextComponent;", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/item/ItemStack;Lnet/minecraft/block/state/IBlockState;Lkotlin/jvm/functions/Function3;)V", "getErrorMsg", "()Lkotlin/jvm/functions/Function3;", "getGetter", "()Lkotlin/jvm/functions/Function1;", "getReplacement", "()Lnet/minecraft/block/state/IBlockState;", "getStack", "()Lnet/minecraft/item/ItemStack;", "activateBlock", "", "relativePos", "context", "checkBlock", "", "deactivateBlock", "getBlockData", "Lcom/cout970/magneticraft/systems/multiblocks/BlockData;", "getBlueprintBlocks", "multiblock", "Lcom/cout970/magneticraft/systems/multiblocks/Multiblock;", "blockPos", "Magneticraft_1.12"})
public final class ContextBlockComponent
implements IMultiblockComponent {
    @NotNull
    private final Function1<MultiblockContext, IBlockState> getter;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final IBlockState replacement;
    @NotNull
    private final Function3<MultiblockContext, IBlockState, BlockPos, ITextComponent> errorMsg;

    @Override
    @NotNull
    public List<ITextComponent> checkBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState state = context.getWorld().func_180495_p(pos);
        if (Intrinsics.areEqual((Object)state, (Object)((IBlockState)this.getter.invoke((Object)context))) ^ true) {
            if (Debug.INSTANCE.getDEBUG() && context.getPlayer() != null) {
                FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
                Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
                if (fMLCommonHandler.getEffectiveSide() == Side.SERVER) {
                    context.getWorld().func_175656_a(pos, (IBlockState)this.getter.invoke((Object)context));
                }
            }
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            return CollectionsKt.listOf((Object)this.errorMsg.invoke((Object)context, (Object)iBlockState, (Object)pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public BlockData getBlockData(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IBlockState iBlockState = state = context.getWorld().func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return new BlockData(iBlockState, pos);
    }

    @Override
    public void activateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        context.getWorld().func_175656_a(pos, this.replacement);
        IMultiblockComponent.DefaultImpls.activateBlock(this, relativePos, context);
    }

    @Override
    public void deactivateBlock(@NotNull BlockPos relativePos, @NotNull MultiblockContext context) {
        Intrinsics.checkParameterIsNotNull((Object)relativePos, (String)"relativePos");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BlockPos pos = BlockPosKt.plus(context.getCenter(), relativePos);
        IMultiblockComponent.DefaultImpls.deactivateBlock(this, relativePos, context);
        context.getWorld().func_175656_a(pos, (IBlockState)this.getter.invoke((Object)context));
    }

    @Override
    @NotNull
    public List<ItemStack> getBlueprintBlocks(@NotNull Multiblock multiblock, @NotNull BlockPos blockPos) {
        Intrinsics.checkParameterIsNotNull((Object)multiblock, (String)"multiblock");
        Intrinsics.checkParameterIsNotNull((Object)blockPos, (String)"blockPos");
        return CollectionsKt.listOf((Object)this.stack);
    }

    @NotNull
    public final Function1<MultiblockContext, IBlockState> getGetter() {
        return this.getter;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final IBlockState getReplacement() {
        return this.replacement;
    }

    @NotNull
    public final Function3<MultiblockContext, IBlockState, BlockPos, ITextComponent> getErrorMsg() {
        return this.errorMsg;
    }

    public ContextBlockComponent(@NotNull Function1<? super MultiblockContext, ? extends IBlockState> getter, @NotNull ItemStack stack, @NotNull IBlockState replacement, @NotNull Function3<? super MultiblockContext, ? super IBlockState, ? super BlockPos, ? extends ITextComponent> errorMsg) {
        Intrinsics.checkParameterIsNotNull(getter, (String)"getter");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        Intrinsics.checkParameterIsNotNull(errorMsg, (String)"errorMsg");
        this.getter = getter;
        this.stack = stack;
        this.replacement = replacement;
        this.errorMsg = errorMsg;
    }
}

