/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.manual;

import com.cout970.magneticraft.systems.manual.MarkdownParserKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nJ$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J,\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J$\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/cout970/magneticraft/systems/manual/MarkdownLexer;", "", "()V", "nextToken", "Lkotlin/Pair;", "", "", "Lcom/cout970/magneticraft/systems/manual/Token;", "buff", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "readAsterisk", "readEndLine", "readHeader", "readWord", "firstChar", "", "trimSpaces", "Magneticraft_1.12"})
public final class MarkdownLexer {
    public static final MarkdownLexer INSTANCE;

    @NotNull
    public final Pair<Integer, String> nextToken(@NotNull StringBuilder buff) {
        Pair<Integer, String> pair;
        Intrinsics.checkParameterIsNotNull((Object)buff, (String)"buff");
        CharSequence charSequence = buff;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return TuplesKt.to((Object)-1, (Object)"EOF");
        }
        char c = MarkdownParserKt.pop$default(buff, 0, 1, null);
        switch (c) {
            case ' ': {
                pair = this.trimSpaces(buff);
                break;
            }
            case '#': {
                pair = this.readHeader(buff);
                break;
            }
            case '-': {
                pair = TuplesKt.to((Object)45, (Object)"-");
                break;
            }
            case '=': {
                pair = TuplesKt.to((Object)61, (Object)"=");
                break;
            }
            case '[': {
                pair = TuplesKt.to((Object)91, (Object)"[");
                break;
            }
            case ']': {
                pair = TuplesKt.to((Object)93, (Object)"]");
                break;
            }
            case '(': {
                pair = TuplesKt.to((Object)40, (Object)"(");
                break;
            }
            case ')': {
                pair = TuplesKt.to((Object)41, (Object)")");
                break;
            }
            case '*': {
                pair = this.readAsterisk(buff);
                break;
            }
            case '\n': {
                pair = this.readEndLine(buff);
                break;
            }
            default: {
                pair = this.readWord(c, buff);
            }
        }
        return pair;
    }

    private final Pair<Integer, String> readWord(char firstChar, StringBuilder buff) {
        StringBuilder acc = new StringBuilder();
        boolean shouldBreak = false;
        acc.append(firstChar);
        block3: while (!shouldBreak) {
            CharSequence charSequence = buff;
            boolean bl = false;
            if (!(charSequence.length() > 0)) break;
            char c = buff.charAt(0);
            switch (c) {
                case '\n': 
                case ' ': 
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '=': 
                case '[': 
                case ']': {
                    shouldBreak = true;
                    continue block3;
                }
            }
            MarkdownParserKt.pop$default(buff, 0, 1, null);
            acc.append(c);
        }
        return TuplesKt.to((Object)266, (Object)acc.toString());
    }

    private final Pair<Integer, String> readAsterisk(StringBuilder buff) {
        if (buff.charAt(0) == '*' && buff.charAt(1) == '*') {
            MarkdownParserKt.access$pop(buff, 2);
            return TuplesKt.to((Object)264, (Object)"***");
        }
        if (buff.charAt(0) == '*') {
            MarkdownParserKt.pop$default(buff, 0, 1, null);
            return TuplesKt.to((Object)263, (Object)"**");
        }
        return TuplesKt.to((Object)42, (Object)"*");
    }

    private final Pair<Integer, String> readEndLine(StringBuilder buff) {
        CharSequence charSequence = buff;
        boolean bl = false;
        if (charSequence.length() > 0 && buff.charAt(0) == '\n') {
            while (true) {
                charSequence = buff;
                bl = false;
                if (!(charSequence.length() > 0) || buff.charAt(0) != '\n') break;
                MarkdownParserKt.pop$default(buff, 0, 1, null);
            }
            return TuplesKt.to((Object)265, (Object)"\n");
        }
        return TuplesKt.to((Object)10, (Object)"\n");
    }

    private final Pair<Integer, String> trimSpaces(StringBuilder buff) {
        while (true) {
            CharSequence charSequence = buff;
            boolean bl = false;
            if (!(charSequence.length() > 0) || buff.charAt(0) != ' ') break;
            MarkdownParserKt.pop$default(buff, 0, 1, null);
        }
        return TuplesKt.to((Object)32, (Object)" ");
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, String> readHeader(StringBuilder buff) {
        void i;
        int level = 1;
        int n = 0;
        int n2 = 4;
        while (n <= n2 && buff.charAt((int)i) == '#') {
            ++level;
            ++i;
        }
        MarkdownParserKt.access$pop(buff, level - 1);
        return TuplesKt.to((Object)(255 + (level - 1)), (Object)MarkdownParserKt.times("#", level));
    }

    private MarkdownLexer() {
    }

    static {
        MarkdownLexer markdownLexer;
        INSTANCE = markdownLexer = new MarkdownLexer();
    }
}

