/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.items;

import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.registry.CapabilitiesKt;
import com.cout970.magneticraft.systems.items.ItemBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0016J\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\"\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lcom/cout970/magneticraft/systems/items/ElectricItemBase;", "Lcom/cout970/magneticraft/systems/items/ItemBase;", "()V", "capacity", "", "getCapacity", "()I", "setCapacity", "(I)V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getCapacityInternal", "getDurabilityForDisplay", "", "getStoredEnergyInternal", "getSubItems", "itemIn", "Lnet/minecraft/creativetab/CreativeTabs;", "tab", "Lnet/minecraft/util/NonNullList;", "giveEnergyInternal", "power", "simulated", "", "showDurabilityBar", "takeEnergyInternal", "Companion", "ItemEnergyCapabilityProvider", "Magneticraft_1.12"})
public final class ElectricItemBase
extends ItemBase {
    private int capacity;
    @NotNull
    public static final String ENERGY_KEY = "energy";
    public static final Companion Companion = new Companion(null);

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int n) {
        this.capacity = n;
    }

    public double getDurabilityForDisplay(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if ((double)this.getCapacityInternal(stack) < 1.0) {
            return 1.0;
        }
        return 1.0 - (double)this.getStoredEnergyInternal(stack) / (double)this.getCapacityInternal(stack);
    }

    public boolean showDurabilityBar(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.getStoredEnergyInternal(stack) > 0;
    }

    @Override
    public void func_150895_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> tab) {
        Intrinsics.checkParameterIsNotNull((Object)itemIn, (String)"itemIn");
        Intrinsics.checkParameterIsNotNull(tab, (String)"tab");
        if (this.func_194125_a(itemIn)) {
            tab.add((Object)new ItemStack((Item)this, 1, 0));
            ItemStack itemStack = new ItemStack((Item)this, 1, 0);
            NonNullList<ItemStack> nonNullList = tab;
            boolean bl = false;
            boolean bl2 = false;
            ItemStack $this$apply = itemStack;
            boolean bl3 = false;
            NBTKt.setInteger($this$apply, ENERGY_KEY, this.getCapacityInternal($this$apply));
            ItemStack itemStack2 = itemStack;
            nonNullList.add((Object)itemStack2);
        }
    }

    @Override
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull(tooltip, (String)"tooltip");
        Intrinsics.checkParameterIsNotNull((Object)flagIn, (String)"flagIn");
        String string = new TextComponentTranslation("tooltip.magneticraft.item_storage.energy", new Object[]{this.getStoredEnergyInternal(stack), this.getCapacityInternal(stack)}).func_150261_e();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TextComponentTranslation\u2026.unformattedComponentText");
        tooltip.add(string);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public final int getStoredEnergyInternal(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return NBTKt.getInteger(stack, ENERGY_KEY);
    }

    public final int getCapacityInternal(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.capacity;
    }

    public final int giveEnergyInternal(@NotNull ItemStack stack, int power, boolean simulated) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if ((double)power <= 0.0) {
            return 0;
        }
        int stored = this.getStoredEnergyInternal(stack);
        int space = this.getCapacityInternal(stack) - stored;
        int min = Math.min(power, space);
        if (min > 0) {
            if (!simulated) {
                NBTKt.setInteger(stack, ENERGY_KEY, stored + min);
            }
            return min;
        }
        return 0;
    }

    public final int takeEnergyInternal(@NotNull ItemStack stack, int power, boolean simulated) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if ((double)power <= 0.0) {
            return 0;
        }
        int stored = this.getStoredEnergyInternal(stack);
        int min = Math.min(power, stored);
        if (min > 0) {
            if (!simulated) {
                NBTKt.setInteger(stack, ENERGY_KEY, Math.max(0, stored - min));
            }
            return min;
        }
        return 0;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/cout970/magneticraft/systems/items/ElectricItemBase$ItemEnergyCapabilityProvider;", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "stack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "getStack", "()Lnet/minecraft/item/ItemStack;", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "hasCapability", "", "DefaultItemEnergyStorage", "Magneticraft_1.12"})
    public static final class ItemEnergyCapabilityProvider
    implements ICapabilityProvider {
        @NotNull
        private final ItemStack stack;

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            if (Intrinsics.areEqual(capability, CapabilitiesKt.getFORGE_ENERGY())) {
                return (T)new DefaultItemEnergyStorage(this.stack);
            }
            return null;
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
            return Intrinsics.areEqual(capability, CapabilitiesKt.getFORGE_ENERGY());
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        public ItemEnergyCapabilityProvider(@NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            this.stack = stack;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/cout970/magneticraft/systems/items/ElectricItemBase$ItemEnergyCapabilityProvider$DefaultItemEnergyStorage;", "Lnet/minecraftforge/energy/IEnergyStorage;", "stack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "getStack", "()Lnet/minecraft/item/ItemStack;", "canExtract", "", "canReceive", "extractEnergy", "", "maxExtract", "simulate", "getEnergyStored", "getMaxEnergyStored", "receiveEnergy", "maxReceive", "Magneticraft_1.12"})
        public static final class DefaultItemEnergyStorage
        implements IEnergyStorage {
            @NotNull
            private final ItemStack stack;

            public boolean canReceive() {
                return true;
            }

            public boolean canExtract() {
                return true;
            }

            public int getMaxEnergyStored() {
                Item item = this.stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.items.ElectricItemBase");
                }
                return ((ElectricItemBase)item).getCapacityInternal(this.stack);
            }

            public int getEnergyStored() {
                Item item = this.stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.items.ElectricItemBase");
                }
                return ((ElectricItemBase)item).getStoredEnergyInternal(this.stack);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                Item item = this.stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.items.ElectricItemBase");
                }
                return ((ElectricItemBase)item).takeEnergyInternal(this.stack, maxExtract, simulate);
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                Item item = this.stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.items.ElectricItemBase");
                }
                return ((ElectricItemBase)item).giveEnergyInternal(this.stack, maxReceive, simulate);
            }

            @NotNull
            public final ItemStack getStack() {
                return this.stack;
            }

            public DefaultItemEnergyStorage(@NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                this.stack = stack;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cout970/magneticraft/systems/items/ElectricItemBase$Companion;", "", "()V", "ENERGY_KEY", "", "Magneticraft_1.12"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

