/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.integration.crafttweaker;

import com.cout970.magneticraft.api.internal.registries.machines.gasificationunit.GasificationUnitRecipeManager;
import com.cout970.magneticraft.api.registries.machines.gasificationunit.IGasificationUnitRecipe;
import com.cout970.magneticraft.systems.integration.crafttweaker.CraftTweakerPlugin;
import com.cout970.magneticraft.systems.integration.crafttweaker.UtilitiesKt;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.GasificationUnit")
@ZenRegister
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/cout970/magneticraft/systems/integration/crafttweaker/GasificationUnit;", "", "()V", "addRecipe", "", "input", "Lcrafttweaker/api/item/IItemStack;", "out1", "out2", "Lcrafttweaker/api/liquid/ILiquidStack;", "ticks", "", "minTemp", "useOreDict", "", "removeRecipe", "Magneticraft_1.12"})
public final class GasificationUnit {
    public static final GasificationUnit INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void addRecipe(@NotNull IItemStack input2, @Nullable IItemStack out1, @Nullable ILiquidStack out2, float ticks, float minTemp, boolean useOreDict) {
        Intrinsics.checkParameterIsNotNull((Object)input2, (String)"input");
        CraftTweakerPlugin.INSTANCE.delayExecution((Function0<Unit>)((Function0)new Function0<Unit>(input2, out1, out2, minTemp, ticks, useOreDict){
            final /* synthetic */ IItemStack $input;
            final /* synthetic */ IItemStack $out1;
            final /* synthetic */ ILiquidStack $out2;
            final /* synthetic */ float $minTemp;
            final /* synthetic */ float $ticks;
            final /* synthetic */ boolean $useOreDict;

            public final void invoke() {
                ItemStack inStack = UtilitiesKt.toStack(this.$input);
                IItemStack iItemStack = this.$out1;
                if (iItemStack == null || (iItemStack = UtilitiesKt.toStack(iItemStack)) == null) {
                    iItemStack = ItemStack.field_190927_a;
                }
                IItemStack outStack1 = iItemStack;
                ILiquidStack iLiquidStack = this.$out2;
                FluidStack outStack2 = iLiquidStack != null ? UtilitiesKt.toStack(iLiquidStack) : null;
                ItemStack $this$ifEmpty$iv = inStack;
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.func_190926_b()) {
                    boolean bl = false;
                    UtilitiesKt.ctLogError("[GasificationUnit] Invalid input stack: EMPTY");
                    return;
                }
                IItemStack iItemStack2 = outStack1;
                Intrinsics.checkExpressionValueIsNotNull((Object)iItemStack2, (String)"outStack1");
                if (iItemStack2.func_190926_b() && outStack2 == null) {
                    UtilitiesKt.ctLogError("[GasificationUnit] Missing output: item: EMPTY, fluid: null, inputItem: " + this.$input);
                    return;
                }
                if (this.$minTemp < 0.0f) {
                    UtilitiesKt.ctLogError("[GasificationUnit] Invalid min temperature: " + this.$minTemp + ", must be positive");
                    return;
                }
                if (this.$ticks < 0.0f) {
                    UtilitiesKt.ctLogError("[GasificationUnit] Invalid processing time: " + this.$ticks + ", must be positive");
                    return;
                }
                IGasificationUnitRecipe recipe = GasificationUnitRecipeManager.INSTANCE.createRecipe(inStack, (ItemStack)outStack1, outStack2, this.$ticks, this.$minTemp, this.$useOreDict);
                UtilitiesKt.applyAction("Adding " + recipe, (Function0<Unit>)((Function0)new Function0<Unit>(recipe){
                    final /* synthetic */ IGasificationUnitRecipe $recipe;

                    public final void invoke() {
                        GasificationUnitRecipeManager.INSTANCE.registerRecipe(this.$recipe);
                    }
                    {
                        this.$recipe = iGasificationUnitRecipe;
                        super(0);
                    }
                }));
            }
            {
                this.$input = iItemStack;
                this.$out1 = iItemStack2;
                this.$out2 = iLiquidStack;
                this.$minTemp = f;
                this.$ticks = f2;
                this.$useOreDict = bl;
                super(0);
            }
        }));
    }

    @ZenMethod
    @JvmStatic
    public static final void removeRecipe(@NotNull IItemStack input2) {
        Intrinsics.checkParameterIsNotNull((Object)input2, (String)"input");
        CraftTweakerPlugin.INSTANCE.delayExecution((Function0<Unit>)((Function0)new Function0<Unit>(input2){
            final /* synthetic */ IItemStack $input;

            public final void invoke() {
                ItemStack inStack;
                ItemStack $this$ifEmpty$iv = inStack = UtilitiesKt.toStack(this.$input);
                boolean $i$f$ifEmpty = false;
                if ($this$ifEmpty$iv.func_190926_b()) {
                    boolean bl = false;
                    UtilitiesKt.ctLogError("[GasificationUnit] Invalid input stack: EMPTY");
                    return;
                }
                IGasificationUnitRecipe recipe = GasificationUnitRecipeManager.INSTANCE.findRecipe(inStack);
                if (recipe == null) {
                    UtilitiesKt.ctLogError("[GasificationUnit] Cannot remove recipe: No recipe found for " + this.$input);
                    return;
                }
                UtilitiesKt.applyAction("Removing " + recipe, (Function0<Unit>)((Function0)new Function0<Unit>(recipe){
                    final /* synthetic */ IGasificationUnitRecipe $recipe;

                    public final void invoke() {
                        GasificationUnitRecipeManager.INSTANCE.removeRecipe(this.$recipe);
                    }
                    {
                        this.$recipe = iGasificationUnitRecipe;
                        super(0);
                    }
                }));
            }
            {
                this.$input = iItemStack;
                super(0);
            }
        }));
    }

    private GasificationUnit() {
    }

    static {
        GasificationUnit gasificationUnit;
        INSTANCE = gasificationUnit = new GasificationUnit();
    }
}

