/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.integration.crafttweaker;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuel;
import com.cout970.magneticraft.api.registries.fuel.IFluidFuelManager;
import com.cout970.magneticraft.systems.integration.crafttweaker.CraftTweakerPlugin;
import com.cout970.magneticraft.systems.integration.crafttweaker.UtilitiesKt;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.FluidFuel")
@ZenRegister
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/cout970/magneticraft/systems/integration/crafttweaker/FluidFuel;", "", "()V", "addFuel", "", "liquid", "Lcrafttweaker/api/liquid/ILiquidStack;", "burningTime", "", "powerPerCycle", "", "removeFuel", "Magneticraft_1.12"})
public final class FluidFuel {
    public static final FluidFuel INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void addFuel(@NotNull ILiquidStack liquid, int burningTime, double powerPerCycle) {
        Intrinsics.checkParameterIsNotNull((Object)liquid, (String)"liquid");
        CraftTweakerPlugin.INSTANCE.delayExecution((Function0<Unit>)((Function0)new Function0<Unit>(liquid, burningTime, powerPerCycle){
            final /* synthetic */ ILiquidStack $liquid;
            final /* synthetic */ int $burningTime;
            final /* synthetic */ double $powerPerCycle;

            public final void invoke() {
                FluidStack fluidStack = UtilitiesKt.toStack(this.$liquid);
                if (fluidStack == null) {
                    UtilitiesKt.ctLogError("[FluidFuel] Invalid input liquid: " + this.$liquid);
                    return;
                }
                if (this.$burningTime <= 0) {
                    UtilitiesKt.ctLogError("[FluidFuel] Invalid burning time: " + this.$burningTime + " for liquid " + this.$liquid);
                    return;
                }
                if (this.$powerPerCycle <= 0.0) {
                    UtilitiesKt.ctLogError("[FluidFuel] Invalid power per cycle: " + this.$powerPerCycle + " for liquid " + this.$liquid);
                    return;
                }
                IFluidFuelManager manager = MagneticraftApi.getFluidFuelManager();
                IFluidFuel fuel = manager.createFuel(fluidStack, this.$burningTime, this.$powerPerCycle);
                manager.registerFuel(fuel);
            }
            {
                this.$liquid = iLiquidStack;
                this.$burningTime = n;
                this.$powerPerCycle = d;
                super(0);
            }
        }));
    }

    @ZenMethod
    @JvmStatic
    public static final void removeFuel(@NotNull ILiquidStack liquid) {
        Intrinsics.checkParameterIsNotNull((Object)liquid, (String)"liquid");
        CraftTweakerPlugin.INSTANCE.delayExecution((Function0<Unit>)((Function0)new Function0<Unit>(liquid){
            final /* synthetic */ ILiquidStack $liquid;

            public final void invoke() {
                FluidStack fluidStack = UtilitiesKt.toStack(this.$liquid);
                if (fluidStack == null) {
                    UtilitiesKt.ctLogError("[FluidFuel] Invalid input liquid: " + this.$liquid);
                    return;
                }
                IFluidFuelManager manager = MagneticraftApi.getFluidFuelManager();
                IFluidFuel fuel = manager.findFuel(fluidStack);
                if (fuel == null) {
                    UtilitiesKt.ctLogError("[FluidFuel] Cannot remove recipe: No recipe found for " + this.$liquid);
                    return;
                }
                UtilitiesKt.applyAction("Removing " + fuel, (Function0<Unit>)((Function0)new Function0<Unit>(manager, fuel){
                    final /* synthetic */ IFluidFuelManager $manager;
                    final /* synthetic */ IFluidFuel $fuel;

                    public final void invoke() {
                        this.$manager.removeFuel(this.$fuel);
                    }
                    {
                        this.$manager = iFluidFuelManager;
                        this.$fuel = iFluidFuel;
                        super(0);
                    }
                }));
            }
            {
                this.$liquid = iLiquidStack;
                super(0);
            }
        }));
    }

    private FluidFuel() {
    }

    static {
        FluidFuel fluidFuel;
        INSTANCE = fluidFuel = new FluidFuel();
    }
}

