/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.gui.components.bars;

import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.vector.Vec2d;
import com.cout970.magneticraft.systems.gui.render.DrawableBox;
import com.cout970.magneticraft.systems.gui.render.IComponent;
import com.cout970.magneticraft.systems.gui.render.IGui;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u0004\u0018\u00010\"R\u001a\u0010\u000b\u001a\u00020\fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/cout970/magneticraft/systems/gui/components/bars/CompFluidBar;", "Lcom/cout970/magneticraft/systems/gui/render/IComponent;", "topPos", "Lcom/cout970/magneticraft/misc/vector/Vec2d;", "Lcom/cout970/magneticraft/IVector2;", "overlayTexture", "Lnet/minecraft/util/ResourceLocation;", "overlayPos", "tank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "(Lcom/cout970/magneticraft/misc/vector/Vec2d;Lnet/minecraft/util/ResourceLocation;Lcom/cout970/magneticraft/misc/vector/Vec2d;Lcom/cout970/magneticraft/misc/fluid/Tank;)V", "gui", "Lcom/cout970/magneticraft/systems/gui/render/IGui;", "getGui", "()Lcom/cout970/magneticraft/systems/gui/render/IGui;", "setGui", "(Lcom/cout970/magneticraft/systems/gui/render/IGui;)V", "getOverlayPos", "()Lcom/cout970/magneticraft/misc/vector/Vec2d;", "getOverlayTexture", "()Lnet/minecraft/util/ResourceLocation;", "pos", "getPos", "size", "getSize", "getTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "drawFirstLayer", "", "mouse", "partialTicks", "", "drawSecondLayer", "getFluidTexture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "Magneticraft_1.12"})
public final class CompFluidBar
implements IComponent {
    @NotNull
    private final Vec2d pos;
    @NotNull
    private final Vec2d size;
    @NotNull
    public IGui gui;
    @NotNull
    private final ResourceLocation overlayTexture;
    @NotNull
    private final Vec2d overlayPos;
    @NotNull
    private final Tank tank;

    @Override
    @NotNull
    public Vec2d getPos() {
        return this.pos;
    }

    @Override
    @NotNull
    public Vec2d getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public IGui getGui() {
        IGui iGui = this.gui;
        if (iGui == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gui");
        }
        return iGui;
    }

    @Override
    public void setGui(@NotNull IGui iGui) {
        Intrinsics.checkParameterIsNotNull((Object)iGui, (String)"<set-?>");
        this.gui = iGui;
    }

    @Nullable
    public final TextureAtlasSprite getFluidTexture() {
        CharSequence charSequence = this.tank.getClientFluidName();
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)this.tank.getClientFluidName());
        if (fluid == null) {
            return null;
        }
        Fluid fluid2 = fluid;
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        TextureMap textureMap = minecraft.func_147117_R();
        return textureMap.func_110572_b(fluid2.getStill().toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawFirstLayer(@NotNull Vec2d mouse, float partialTicks) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        TextureAtlasSprite texture = this.getFluidTexture();
        if (this.tank.getClientFluidAmount() > 0 && texture != null) {
            int level = this.tank.getClientFluidAmount() * 48 / this.tank.getCapacity();
            IGui iGui = this.getGui();
            ResourceLocation resourceLocation = TextureMap.field_110575_b;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"TextureMap.LOCATION_BLOCKS_TEXTURE");
            iGui.bindTexture(resourceLocation);
            GlStateManager.func_179147_l();
            int height = level / 16;
            int n = 0;
            int n2 = height;
            if (n <= n2) {
                while (true) {
                    void y$iv;
                    void y$iv2;
                    double x$iv;
                    void h;
                    int heightLevel = Math.min(level - h * 16, 16);
                    double d = this.getPos().getX();
                    double d2 = this.getPos().getY() + (double)48 - (double)heightLevel - (double)(h * 16);
                    Vec2d vec2d = this.getGui().getPos();
                    IGui iGui2 = this.getGui();
                    boolean $i$f$vec2Of = false;
                    Vec2d vec2d2 = new Vec2d(x$iv, (double)y$iv2);
                    x$iv = this.getSize().getX();
                    int n3 = heightLevel;
                    vec2d = vec2d.plus(vec2d2);
                    boolean $i$f$vec2Of2 = false;
                    vec2d2 = new Vec2d(x$iv, (double)y$iv);
                    iGui2.drawSprite(vec2d, vec2d2, texture);
                    if (h == n2) break;
                    ++h;
                }
            }
            GlStateManager.func_179084_k();
        }
        this.getGui().bindTexture(this.overlayTexture);
        this.getGui().drawTexture(new DrawableBox(this.getGui().getPos().plus(this.getPos()), this.getSize(), this.overlayPos, null, null, 24, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void drawSecondLayer(@NotNull Vec2d mouse) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        Pair $this$contains$iv = TuplesKt.to((Object)this.getGui().getPos().plus(this.getPos()), (Object)this.getSize());
        boolean $i$f$contains = false;
        Pair $this$start$iv$iv = $this$contains$iv;
        boolean $i$f$getStart = false;
        double d = ((Vec2d)$this$start$iv$iv.getFirst()).getX();
        Pair $this$end$iv$iv = $this$contains$iv;
        boolean $i$f$getEnd = false;
        double d2 = ((Vec2d)$this$end$iv$iv.getFirst()).plus((Vec2d)$this$end$iv$iv.getSecond()).getX();
        double d3 = mouse.getX();
        if (!(d3 >= d)) return;
        if (!(d3 <= d2)) return;
        $this$start$iv$iv = $this$contains$iv;
        $i$f$getStart = false;
        d = ((Vec2d)$this$start$iv$iv.getFirst()).getY();
        $this$end$iv$iv = $this$contains$iv;
        $i$f$getEnd = false;
        d2 = ((Vec2d)$this$end$iv$iv.getFirst()).plus((Vec2d)$this$end$iv$iv.getSecond()).getY();
        d3 = mouse.getY();
        if (!(d3 >= d)) return;
        if (!(d3 <= d2)) return;
        boolean bl = true;
        if (!bl) return;
        boolean bl2 = this.tank.getClientFluidAmount() == 0;
        List list = bl2 ? CollectionsKt.listOf((Object)"Fluid: Empty") : CollectionsKt.listOf((Object[])new String[]{"Fluid: " + this.tank.getClientFluidName(), "Amount: " + this.tank.getClientFluidAmount()});
        this.getGui().drawHoveringText(list, mouse);
    }

    @NotNull
    public final ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    @NotNull
    public final Vec2d getOverlayPos() {
        return this.overlayPos;
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    /*
     * WARNING - void declaration
     */
    public CompFluidBar(@NotNull Vec2d topPos, @NotNull ResourceLocation overlayTexture, @NotNull Vec2d overlayPos, @NotNull Tank tank2) {
        void y$iv;
        void x$iv;
        Vec2d vec2d;
        Intrinsics.checkParameterIsNotNull((Object)topPos, (String)"topPos");
        Intrinsics.checkParameterIsNotNull((Object)overlayTexture, (String)"overlayTexture");
        Intrinsics.checkParameterIsNotNull((Object)overlayPos, (String)"overlayPos");
        Intrinsics.checkParameterIsNotNull((Object)((Object)tank2), (String)"tank");
        this.overlayTexture = overlayTexture;
        this.overlayPos = overlayPos;
        this.tank = tank2;
        this.pos = topPos;
        int n = 16;
        int n2 = 48;
        CompFluidBar compFluidBar = this;
        boolean $i$f$vec2Of = false;
        compFluidBar.size = vec2d = new Vec2d((double)x$iv, (double)y$iv);
    }

    @Override
    @NotNull
    public Pair<Vec2d, Vec2d> getCollisionBox() {
        return IComponent.DefaultImpls.getCollisionBox(this);
    }

    @Override
    public void init() {
        IComponent.DefaultImpls.init(this);
    }

    @Override
    public boolean onMouseClick(@NotNull Vec2d mouse, int mouseButton) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        return IComponent.DefaultImpls.onMouseClick(this, mouse, mouseButton);
    }

    @Override
    public boolean onMouseClickMove(@NotNull Vec2d mouse, int clickedMouseButton, long timeSinceLastClick) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        return IComponent.DefaultImpls.onMouseClickMove(this, mouse, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public void onMouseReleased(@NotNull Vec2d mouse, int state) {
        Intrinsics.checkParameterIsNotNull((Object)mouse, (String)"mouse");
        IComponent.DefaultImpls.onMouseReleased(this, mouse, state);
    }

    @Override
    public boolean onKeyTyped(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyTyped(this, typedChar, keyCode);
    }

    @Override
    public boolean onKeyReleased(char typedChar, int keyCode) {
        return IComponent.DefaultImpls.onKeyReleased(this, typedChar, keyCode);
    }

    @Override
    public void onWheel(int amount) {
        IComponent.DefaultImpls.onWheel(this, amount);
    }

    @Override
    public void onGuiClosed() {
        IComponent.DefaultImpls.onGuiClosed(this);
    }
}

