/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IRAM;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/cout970/magneticraft/systems/computer/RAM;", "Lcom/cout970/magneticraft/api/computer/IRAM;", "size", "", "littleEndian", "", "(IZ)V", "getLittleEndian", "()Z", "mem", "", "getMem", "()[B", "getSize", "()I", "deserialize", "", "map", "", "", "", "getMemorySize", "isLittleEndian", "readByte", "", "addr", "readWord", "pos", "serialize", "writeByte", "data", "writeWord", "Magneticraft_1.12"})
public final class RAM
implements IRAM {
    @NotNull
    private final byte[] mem;
    private final int size;
    private final boolean littleEndian;

    @NotNull
    public final byte[] getMem() {
        return this.mem;
    }

    @Override
    public byte readByte(int addr) {
        if (addr < 0 || addr >= this.getMemorySize()) {
            return 0;
        }
        return this.mem[addr];
    }

    @Override
    public void writeByte(int addr, byte data) {
        if (addr < 0 || addr >= this.getMemorySize()) {
            return;
        }
        this.mem[addr] = data;
    }

    @Override
    public void writeWord(int pos, int data) {
        byte a = (byte)(data & 0xFF);
        byte b = (byte)((data & 0xFF00) >> 8);
        byte c = (byte)((data & 0xFF0000) >> 16);
        byte d = (byte)((data & (int)0xFF000000L) >> 24);
        if (this.littleEndian) {
            this.writeByte(pos, a);
            this.writeByte(pos + 1, b);
            this.writeByte(pos + 2, c);
            this.writeByte(pos + 3, d);
        } else {
            this.writeByte(pos, d);
            this.writeByte(pos + 1, c);
            this.writeByte(pos + 2, b);
            this.writeByte(pos + 3, a);
        }
    }

    @Override
    public int readWord(int pos) {
        int n;
        byte a = this.readByte(pos);
        byte b = this.readByte(pos + 1);
        byte c = this.readByte(pos + 2);
        byte d = this.readByte(pos + 3);
        if (this.littleEndian) {
            int ai = a & 0xFF;
            int bi = (b & 0xFF) << 8;
            int ci = (c & 0xFF) << 16;
            int di = (d & 0xFF) << 24;
            n = ai | bi | ci | di;
        } else {
            int di = d & 0xFF;
            int ci = (c & 0xFF) << 8;
            int bi = (b & 0xFF) << 16;
            int ai = (a & 0xFF) << 24;
            n = ai | bi | ci | di;
        }
        return n;
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public int getMemorySize() {
        return this.size;
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        byte[] byArray = this.mem;
        String string = "mem";
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)byArray3));
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("mem");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] data = (byte[])object;
        System.arraycopy(data, 0, this.mem, 0, this.size);
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean getLittleEndian() {
        return this.littleEndian;
    }

    public RAM(int size, boolean littleEndian) {
        this.size = size;
        this.littleEndian = littleEndian;
        this.mem = new byte[this.size];
    }
}

