/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.misc.ComputerKt;
import com.cout970.magneticraft.systems.computer.DeviceMotherboard;
import com.cout970.magneticraft.systems.computer.FakeRef;
import com.cout970.magneticraft.systems.computer.IVariable;
import com.cout970.magneticraft.systems.computer.Motherboard;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyIntArray;
import com.cout970.magneticraft.systems.computer.ReadWriteByte;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u000245B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0011\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\u0011\u0010!\u001a\n  *\u0004\u0018\u00010\"0\"H\u0096\u0001J\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bJ\u000e\u0010)\u001a\u00020\u00162\u0006\u0010&\u001a\u00020*J\u0018\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\bH\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u000e\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\bJ\b\u00102\u001a\u00020\u0016H\u0016J \u00103\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceMotherboard;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "Lcom/cout970/magneticraft/api/core/ITileRef;", "tile", "mb", "Lcom/cout970/magneticraft/systems/computer/Motherboard;", "(Lcom/cout970/magneticraft/api/core/ITileRef;Lcom/cout970/magneticraft/systems/computer/Motherboard;)V", "logType", "", "getLogType", "()I", "setLogType", "(I)V", "getMb", "()Lcom/cout970/magneticraft/systems/computer/Motherboard;", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getTile", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "deserialize", "", "map", "", "", "", "getComputerPos", "Lnet/minecraft/util/math/BlockPos;", "getDevices", "", "getPos", "kotlin.jvm.PlatformType", "getWorld", "Lnet/minecraft/world/World;", "getWorldTime", "", "logByte", "data", "", "logInt", "logShort", "", "readByte", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "serialize", "signal", "id", "update", "writeByte", "LogInt", "LogShort", "Magneticraft_1.12"})
public final class DeviceMotherboard
implements IDevice,
ITileRef {
    private int logType;
    @NotNull
    private final ReadWriteStruct memStruct;
    @NotNull
    private final ITileRef tile;
    @NotNull
    private final Motherboard mb;

    public final int getLogType() {
        return this.logType;
    }

    public final void setLogType(int n) {
        this.logType = n;
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    @Override
    public void update() {
    }

    @NotNull
    public final int[] getDevices() {
        int[] buffer = new int[16];
        int n = 16;
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int it = n2;
            boolean bl2 = false;
            if (!this.mb.getDeviceMap().keySet().contains(it)) continue;
            buffer[it] = (int)0xFF000000L | it << 16;
        }
        return buffer;
    }

    public final void signal(int id) {
        switch (id) {
            case 0: {
                this.mb.halt();
                break;
            }
            case 1: {
                this.mb.start();
                break;
            }
            case 2: {
                this.mb.reset();
            }
        }
    }

    public final void logByte(byte data) {
        switch (this.logType) {
            case 1: {
                String string = "" + (data & 0xFF) + ' ';
                boolean bl = false;
                System.out.print((Object)string);
                break;
            }
            case 2: {
                String string = "0x%02x ";
                Object[] objectArray = new Object[]{data & 0xFF};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                string = string2;
                boolean bl2 = false;
                System.out.print((Object)string);
                break;
            }
            case 3: {
                char c = (char)data;
                boolean bl = false;
                System.out.print(c);
                break;
            }
            default: {
                String string = this.getComputerPos() + ": 0x%02x, %03d, ";
                Object[] objectArray = new Object[]{data & 0xFF, data & 0xFF};
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                String string4 = string3;
                string = stringBuilder.append(string4).append((char)data).toString();
                boolean bl3 = false;
                System.out.println((Object)string);
            }
        }
    }

    public final void logShort(short data) {
        switch (this.logType) {
            case 1: {
                String string = "" + data + ' ';
                boolean bl = false;
                System.out.print((Object)string);
                break;
            }
            case 2: {
                String string = "0x%04x ";
                Object[] objectArray = new Object[]{data};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                string = string2;
                boolean bl2 = false;
                System.out.print((Object)string);
                break;
            }
            case 3: {
                char c = (char)data;
                boolean bl = false;
                System.out.print(c);
                break;
            }
            default: {
                String string = this.getComputerPos() + ": 0x%04x, %05d";
                Object[] objectArray = new Object[]{data, data};
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                string = string3;
                boolean bl3 = false;
                System.out.println((Object)string);
            }
        }
    }

    public final void logInt(int data) {
        switch (this.logType) {
            case 1: {
                String string = "" + data + ' ';
                boolean bl = false;
                System.out.print((Object)string);
                break;
            }
            case 2: {
                String string = "0x%08x ";
                Object[] objectArray = new Object[]{data};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                string = string2;
                boolean bl2 = false;
                System.out.print((Object)string);
                break;
            }
            case 3: {
                char c = (char)data;
                boolean bl = false;
                System.out.print(c);
                break;
            }
            default: {
                String string = this.getComputerPos() + ": 0x%08x, %010d";
                Object[] objectArray = new Object[]{data, data};
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                string = string3;
                boolean bl3 = false;
                System.out.println((Object)string);
            }
        }
    }

    public final long getWorldTime() {
        if (Intrinsics.areEqual((Object)this.tile, (Object)FakeRef.INSTANCE)) {
            return 0L;
        }
        World world = this.getWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return world.func_82737_E();
    }

    @NotNull
    public final BlockPos getComputerPos() {
        if (Intrinsics.areEqual((Object)this.tile, (Object)FakeRef.INSTANCE)) {
            BlockPos blockPos = BlockPos.field_177992_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.ORIGIN");
            return blockPos;
        }
        BlockPos blockPos = this.getPos();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        return blockPos;
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @NotNull
    public Map<String, Integer> serialize() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"logType", (Object)this.logType));
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("logType");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.logType = (Integer)object;
    }

    @NotNull
    public final ITileRef getTile() {
        return this.tile;
    }

    @NotNull
    public final Motherboard getMb() {
        return this.mb;
    }

    public DeviceMotherboard(@NotNull ITileRef tile, @NotNull Motherboard mb) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        Intrinsics.checkParameterIsNotNull((Object)mb, (String)"mb");
        this.tile = tile;
        this.mb = mb;
        this.memStruct = new ReadWriteStruct("motherboard_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final byte invoke() {
                return this.this$0.getMb().isOnline() ? (byte)1 : 0;
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadWriteByte("signal", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(byte it) {
                this.this$0.signal(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        }), (Function0<Byte>)((Function0)memStruct.3.INSTANCE)), new ReadWriteByte("sleep", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(byte it) {
                this.this$0.getMb().sleep(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        }), (Function0<Byte>)((Function0)memStruct.5.INSTANCE)), new ReadOnlyByte("padding", (Function0<Byte>)((Function0)memStruct.6.INSTANCE)), new ReadOnlyInt("memSize", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final int invoke() {
                return this.this$0.getMb().getRAM().getMemorySize();
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadOnlyInt("littleEndian", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final int invoke() {
                return this.this$0.getMb().getRAM().isLittleEndian() ? -1 : 0;
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadOnlyInt("worldTime", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final int invoke() {
                return (int)(this.this$0.getWorldTime() & 0xFFFFFFFFL);
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadOnlyInt("cpuTime", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final int invoke() {
                return this.this$0.getMb().getClock();
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadWriteByte("logType", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(byte it) {
                this.this$0.setLogType(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        }), (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final byte invoke() {
                return (byte)this.this$0.getLogType();
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadWriteByte("logByte", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(byte it) {
                this.this$0.logByte(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        }), (Function0<Byte>)((Function0)memStruct.14.INSTANCE)), new LogShort("logShort", (Function1<? super Short, Unit>)((Function1)new Function1<Short, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(short it) {
                this.this$0.logShort(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        })), new LogInt("logInt", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            public final void invoke(int it) {
                this.this$0.logInt(it);
            }
            {
                this.this$0 = deviceMotherboard;
                super(1);
            }
        })), new ReadOnlyIntArray("devices", (Function0<int[]>)((Function0)new Function0<int[]>(this){
            final /* synthetic */ DeviceMotherboard this$0;

            @NotNull
            public final int[] invoke() {
                return this.this$0.getDevices();
            }
            {
                this.this$0 = deviceMotherboard;
                super(0);
            }
        })), new ReadOnlyInt("*monitor", (Function0<Integer>)((Function0)memStruct.18.INSTANCE)), new ReadOnlyInt("*floppy", (Function0<Integer>)((Function0)memStruct.19.INSTANCE)), new ReadOnlyInt("*keyboard", (Function0<Integer>)((Function0)memStruct.20.INSTANCE)));
    }

    @Override
    public BlockPos getPos() {
        return this.tile.getPos();
    }

    @Override
    public World getWorld() {
        return this.tile.getWorld();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0015H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceMotherboard$LogInt;", "Lcom/cout970/magneticraft/systems/computer/IVariable;", "name", "", "log", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getLog", "()Lkotlin/jvm/functions/Function1;", "logInt", "getLogInt", "()I", "setLogInt", "(I)V", "getName", "()Ljava/lang/String;", "size", "getSize", "read", "", "addr", "toString", "write", "value", "Magneticraft_1.12"})
    public static final class LogInt
    implements IVariable {
        private int logInt;
        private final int size = 4;
        @NotNull
        private final String name;
        @NotNull
        private final Function1<Integer, Unit> log;

        public final int getLogInt() {
            return this.logInt;
        }

        public final void setLogInt(int n) {
            this.logInt = n;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public byte read(int addr) {
            return ComputerKt.split(this.logInt, addr);
        }

        @Override
        public void write(int addr, byte value2) {
            this.logInt = ComputerKt.splitSet(this.logInt, addr, value2);
            if (addr == 0) {
                this.log.invoke((Object)this.logInt);
            }
        }

        @NotNull
        public String toString() {
            return "i32 " + this.name + ';';
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Function1<Integer, Unit> getLog() {
            return this.log;
        }

        public LogInt(@NotNull String name, @NotNull Function1<? super Integer, Unit> log) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(log, (String)"log");
            this.name = name;
            this.log = log;
            this.size = 4;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0016H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceMotherboard$LogShort;", "Lcom/cout970/magneticraft/systems/computer/IVariable;", "name", "", "log", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getLog", "()Lkotlin/jvm/functions/Function1;", "logShort", "", "getLogShort", "()I", "setLogShort", "(I)V", "getName", "()Ljava/lang/String;", "size", "getSize", "read", "", "addr", "toString", "write", "value", "Magneticraft_1.12"})
    public static final class LogShort
    implements IVariable {
        private int logShort;
        private final int size = 2;
        @NotNull
        private final String name;
        @NotNull
        private final Function1<Short, Unit> log;

        public final int getLogShort() {
            return this.logShort;
        }

        public final void setLogShort(int n) {
            this.logShort = n;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public byte read(int addr) {
            return ComputerKt.split(this.logShort, addr);
        }

        @Override
        public void write(int addr, byte value2) {
            this.logShort = ComputerKt.splitSet(this.logShort, addr, value2);
            if (addr == 0) {
                this.log.invoke((Object)((short)this.logShort));
            }
        }

        @NotNull
        public String toString() {
            return "i16 " + this.name + ';';
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Function1<Short, Unit> getLog() {
            return this.log;
        }

        public LogShort(@NotNull String name, @NotNull Function1<? super Short, Unit> log) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(log, (String)"log");
            this.name = name;
            this.log = log;
            this.size = 2;
        }
    }
}

