/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.misc.inventory.Inventory;
import com.cout970.magneticraft.systems.computer.DeviceInventorySensor;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteInt;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016J\u0011\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0011\u0010 \u001a\n \u001d*\u0004\u0018\u00010!0!H\u0096\u0001J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016J\b\u0010(\u001a\u00020\u0016H\u0016J \u0010)\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020#H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceInventorySensor;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "Lcom/cout970/magneticraft/api/core/ITileRef;", "tile", "inv", "Lcom/cout970/magneticraft/misc/inventory/Inventory;", "(Lcom/cout970/magneticraft/api/core/ITileRef;Lcom/cout970/magneticraft/misc/inventory/Inventory;)V", "getInv", "()Lcom/cout970/magneticraft/misc/inventory/Inventory;", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "selectedIndex", "", "getSelectedIndex", "()I", "setSelectedIndex", "(I)V", "getTile", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "deserialize", "", "map", "", "", "", "getPos", "Lnet/minecraft/util/math/BlockPos;", "kotlin.jvm.PlatformType", "getStack", "Lnet/minecraft/item/ItemStack;", "getWorld", "Lnet/minecraft/world/World;", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "serialize", "update", "writeByte", "data", "Magneticraft_1.12"})
public final class DeviceInventorySensor
implements IDevice,
ITileRef {
    private int selectedIndex;
    @NotNull
    private final ReadWriteStruct memStruct;
    @NotNull
    private final ITileRef tile;
    @NotNull
    private final Inventory inv;

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    public final void setSelectedIndex(int n) {
        this.selectedIndex = n;
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    @NotNull
    public final ItemStack getStack() {
        ItemStack itemStack;
        int n = this.selectedIndex;
        if (0 <= n && this.inv.getSlots() > n) {
            ItemStack itemStack2 = this.inv.getStackInSlot(this.selectedIndex);
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"inv.getStackInSlot(selectedIndex)");
        } else {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @Override
    public void update() {
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        return MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"index", (Object)this.selectedIndex)});
    }

    @Override
    public void deserialize(@NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("index");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.selectedIndex = (Integer)object;
    }

    @NotNull
    public final ITileRef getTile() {
        return this.tile;
    }

    @NotNull
    public final Inventory getInv() {
        return this.inv;
    }

    public DeviceInventorySensor(@NotNull ITileRef tile, @NotNull Inventory inv) {
        Intrinsics.checkParameterIsNotNull((Object)tile, (String)"tile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inv), (String)"inv");
        this.tile = tile;
        this.inv = inv;
        this.memStruct = new ReadWriteStruct("inventory_sensor_header", new ReadWriteStruct("device_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)memStruct.1.INSTANCE)), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)memStruct.3.INSTANCE))), new ReadWriteInt("selectedSlot", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final void invoke(int it) {
                this.this$0.setSelectedIndex(it);
            }
            {
                this.this$0 = deviceInventorySensor;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                return this.this$0.getSelectedIndex();
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        })), new ReadOnlyInt("slotCount", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                return this.this$0.getInv().getSlots();
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        })), new ReadWriteStruct("stack", new ReadOnlyInt("itemId", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                return Item.func_150891_b((Item)this.this$0.getStack().func_77973_b());
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        })), new ReadOnlyInt("itemMeta", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                return this.this$0.getStack().func_77960_j();
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        })), new ReadOnlyInt("itemNbtHash", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                NBTTagCompound nBTTagCompound = this.this$0.getStack().func_77978_p();
                return nBTTagCompound != null ? nBTTagCompound.hashCode() : 0;
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        })), new ReadOnlyInt("stackSize", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceInventorySensor this$0;

            public final int invoke() {
                return this.this$0.getStack().func_190916_E();
            }
            {
                this.this$0 = deviceInventorySensor;
                super(0);
            }
        }))));
    }

    @Override
    public BlockPos getPos() {
        return this.tile.getPos();
    }

    @Override
    public World getWorld() {
        return this.tile.getWorld();
    }
}

