/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.computer;

import com.cout970.magneticraft.api.computer.IDevice;
import com.cout970.magneticraft.api.computer.IFloppyDisk;
import com.cout970.magneticraft.api.computer.IRW;
import com.cout970.magneticraft.systems.computer.DeviceFloppyDrive;
import com.cout970.magneticraft.systems.computer.ReadOnlyByte;
import com.cout970.magneticraft.systems.computer.ReadOnlyInt;
import com.cout970.magneticraft.systems.computer.ReadOnlyShort;
import com.cout970.magneticraft.systems.computer.ReadWriteByte;
import com.cout970.magneticraft.systems.computer.ReadWriteByteArray;
import com.cout970.magneticraft.systems.computer.ReadWriteInt;
import com.cout970.magneticraft.systems.computer.ReadWriteStruct;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0016J\u0006\u0010#\u001a\u00020\rJ\u0006\u0010$\u001a\u00020\u001eJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0006\u0010*\u001a\u00020\u001eJ\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020,0 H\u0016J\b\u0010-\u001a\u00020\u001eH\u0016J\u0006\u0010.\u001a\u00020\u001eJ \u0010/\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u00100\u001a\u00020&H\u0016J\u0006\u00101\u001a\u00020\u001eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000b\u00a8\u00062"}, d2={"Lcom/cout970/magneticraft/systems/computer/DeviceFloppyDrive;", "Lcom/cout970/magneticraft/api/computer/IDevice;", "getDisk", "Lkotlin/Function0;", "Lcom/cout970/magneticraft/api/computer/IFloppyDisk;", "(Lkotlin/jvm/functions/Function0;)V", "action", "", "getAction", "()I", "setAction", "(I)V", "buffer", "", "currentSector", "getCurrentSector", "setCurrentSector", "getGetDisk", "()Lkotlin/jvm/functions/Function0;", "isActive", "", "()Z", "memStruct", "Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "getMemStruct", "()Lcom/cout970/magneticraft/systems/computer/ReadWriteStruct;", "sleep", "getSleep", "setSleep", "deserialize", "", "map", "", "", "", "getBuffer", "read", "readByte", "", "bus", "Lcom/cout970/magneticraft/api/computer/IRW;", "addr", "readLabel", "serialize", "Ljava/io/Serializable;", "update", "write", "writeByte", "data", "writeLabel", "Magneticraft_1.12"})
public final class DeviceFloppyDrive
implements IDevice {
    private byte[] buffer;
    private int sleep;
    private int action;
    private int currentSector;
    private final boolean isActive = true;
    @NotNull
    private final ReadWriteStruct memStruct;
    @NotNull
    private final Function0<IFloppyDisk> getDisk;

    public final int getSleep() {
        return this.sleep;
    }

    public final void setSleep(int n) {
        this.sleep = n;
    }

    public final int getAction() {
        return this.action;
    }

    public final void setAction(int n) {
        this.action = n;
    }

    public final int getCurrentSector() {
        return this.currentSector;
    }

    public final void setCurrentSector(int n) {
        this.currentSector = n;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @Override
    public void update() {
        if (this.sleep > 0) {
            int n = this.sleep;
            this.sleep = n + -1;
            return;
        }
        if (this.action != 0) {
            switch (this.action) {
                case 1: {
                    this.read();
                    break;
                }
                case 2: {
                    this.write();
                    break;
                }
                case 3: {
                    this.readLabel();
                    break;
                }
                case 4: {
                    this.writeLabel();
                }
            }
            this.action = 0;
        }
    }

    public final void read() {
        IFloppyDisk iFloppyDisk = (IFloppyDisk)this.getDisk.invoke();
        if (iFloppyDisk == null) {
            return;
        }
        IFloppyDisk floppy = iFloppyDisk;
        if (this.currentSector >= 0 && this.currentSector < floppy.getSectorCount() && floppy.canRead()) {
            try {
                File file = floppy.getStorageFile();
                if (file.exists()) {
                    RandomAccessFile map = new RandomAccessFile(file, "r");
                    map.seek((long)this.currentSector * 1024L);
                    int read2 = map.read(this.getBuffer());
                    if (read2 == -1) {
                        Arrays.fill(this.getBuffer(), (byte)0);
                    } else if (read2 != 1024) {
                        ArraysKt.fill((byte[])this.getBuffer(), (byte)0, (int)read2, (int)1024);
                    }
                    map.close();
                } else {
                    Arrays.fill(this.getBuffer(), (byte)0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sleep = floppy.getAccessTime() - 1;
        }
    }

    public final void write() {
        IFloppyDisk iFloppyDisk = (IFloppyDisk)this.getDisk.invoke();
        if (iFloppyDisk == null) {
            return;
        }
        IFloppyDisk floppy = iFloppyDisk;
        if (this.currentSector >= 0 && this.currentSector < floppy.getSectorCount() && floppy.canWrite()) {
            try {
                File file = floppy.getStorageFile();
                RandomAccessFile map = new RandomAccessFile(file, "rw");
                map.seek((long)this.currentSector * 1024L);
                map.write(this.getBuffer());
                map.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sleep = floppy.getAccessTime() - 1;
        }
    }

    public final void readLabel() {
        IFloppyDisk iFloppyDisk = (IFloppyDisk)this.getDisk.invoke();
        if (iFloppyDisk == null) {
            return;
        }
        IFloppyDisk floppy = iFloppyDisk;
        if (this.currentSector >= 0 && this.currentSector < floppy.getSectorCount()) {
            try {
                Arrays.fill(this.getBuffer(), (byte)0);
                String string = floppy.getLabel();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"floppy.label");
                String string2 = string;
                Charset charset = Charset.forName("US-ASCII");
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"US-ASCII\")");
                Charset charset2 = charset;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] array = byArray;
                System.arraycopy(array, 0, this.getBuffer(), 0, Math.min(array.length, 1024));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sleep = floppy.getAccessTime() - 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeLabel() {
        IFloppyDisk iFloppyDisk = (IFloppyDisk)this.getDisk.invoke();
        if (iFloppyDisk == null) {
            return;
        }
        IFloppyDisk floppy = iFloppyDisk;
        if (this.currentSector >= 0 && this.currentSector < floppy.getSectorCount()) {
            try {
                CharSequence charSequence;
                String string;
                IFloppyDisk iFloppyDisk2;
                block6: {
                    void $this$trimEnd$iv;
                    Object object = this.getBuffer();
                    Charset charset = Charset.forName("US-ASCII");
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"US-ASCII\")");
                    Charset charset2 = charset;
                    iFloppyDisk2 = floppy;
                    boolean bl = false;
                    boolean bl2 = false;
                    string = new String((byte[])object, charset2);
                    object = string;
                    boolean $i$f$trimEnd = false;
                    CharSequence $this$trimEnd$iv$iv = (CharSequence)$this$trimEnd$iv;
                    boolean $i$f$trimEnd2 = false;
                    int n = $this$trimEnd$iv$iv.length();
                    --n;
                    boolean bl3 = false;
                    while (n >= 0) {
                        void index$iv$iv;
                        char it = $this$trimEnd$iv$iv.charAt((int)index$iv$iv);
                        boolean bl4 = false;
                        if (!(it == '\u0000')) {
                            charSequence = $this$trimEnd$iv$iv.subSequence(0, (int)(index$iv$iv + true));
                            break block6;
                        }
                        --index$iv$iv;
                    }
                    charSequence = "";
                }
                string = ((Object)charSequence).toString();
                iFloppyDisk2.setLabel(string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sleep = floppy.getAccessTime() - 1;
        }
    }

    @NotNull
    public final ReadWriteStruct getMemStruct() {
        return this.memStruct;
    }

    @Override
    public byte readByte(@NotNull IRW bus2, int addr) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        return this.memStruct.read(addr);
    }

    @Override
    public void writeByte(@NotNull IRW bus2, int addr, byte data) {
        Intrinsics.checkParameterIsNotNull((Object)bus2, (String)"bus");
        this.memStruct.write(addr, data);
    }

    @NotNull
    public final byte[] getBuffer() {
        block6: {
            block5: {
                if (this.buffer == null) break block5;
                if (this.buffer == null) {
                    Intrinsics.throwNpe();
                }
                if (this.buffer.length == 1024) break block6;
            }
            this.buffer = new byte[1024];
        }
        if (this.buffer == null) {
            Intrinsics.throwNpe();
        }
        return this.buffer;
    }

    @NotNull
    public Map<String, Serializable> serialize() {
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"sleep", (Object)this.sleep);
        pairArray[1] = TuplesKt.to((Object)"action", (Object)this.action);
        pairArray[2] = TuplesKt.to((Object)"sector", (Object)this.currentSector);
        byte[] byArray = this.getBuffer();
        String string = "buffer";
        int n = 3;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        boolean bl = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)byArray3);
        return MapsKt.mapOf((Pair[])pairArray3);
    }

    public void deserialize(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        Object object = map.get("sleep");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.sleep = (Integer)object;
        Object object2 = map.get("action");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.action = (Integer)object2;
        Object object3 = map.get("sector");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.currentSector = (Integer)object3;
        Object object4 = map.get("buffer");
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        System.arraycopy((byte[])object4, 0, this.getBuffer(), 0, this.getBuffer().length);
    }

    @NotNull
    public final Function0<IFloppyDisk> getGetDisk() {
        return this.getDisk;
    }

    public DeviceFloppyDrive(@NotNull Function0<? extends IFloppyDisk> getDisk) {
        Intrinsics.checkParameterIsNotNull(getDisk, (String)"getDisk");
        this.getDisk = getDisk;
        this.isActive = true;
        this.memStruct = new ReadWriteStruct("disk_drive_header", new ReadOnlyByte("online", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final byte invoke() {
                return this.this$0.isActive() ? (byte)1 : 0;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyByte("type", (Function0<Byte>)((Function0)memStruct.2.INSTANCE)), new ReadOnlyShort("status", (Function0<Short>)((Function0)memStruct.3.INSTANCE)), new ReadWriteByte("signal", (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final void invoke(byte it) {
                this.this$0.setAction(it);
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(1);
            }
        }), (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final byte invoke() {
                return (byte)this.this$0.getAction();
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyByte("hasDisk", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final byte invoke() {
                return this.this$0.getGetDisk().invoke() == null ? (byte)0 : 1;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyByte("accessTime", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final byte invoke() {
                IFloppyDisk iFloppyDisk = (IFloppyDisk)this.this$0.getGetDisk().invoke();
                return iFloppyDisk != null ? (byte)iFloppyDisk.getAccessTime() : (byte)0;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyByte("finished", (Function0<Byte>)((Function0)new Function0<Byte>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final byte invoke() {
                return this.this$0.getAction() == 0 ? (byte)1 : 0;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyInt("numSectors", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final int invoke() {
                IFloppyDisk iFloppyDisk = (IFloppyDisk)this.this$0.getGetDisk().invoke();
                return iFloppyDisk != null ? iFloppyDisk.getSectorCount() : 0;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadOnlyInt("serialNumber", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final int invoke() {
                IFloppyDisk iFloppyDisk = (IFloppyDisk)this.this$0.getGetDisk().invoke();
                return iFloppyDisk != null ? iFloppyDisk.getSerialNumber() : 0;
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadWriteInt("currentSector", (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final void invoke(int it) {
                this.this$0.setCurrentSector(it);
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(1);
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DeviceFloppyDrive this$0;

            public final int invoke() {
                return this.this$0.getCurrentSector();
            }
            {
                this.this$0 = deviceFloppyDrive;
                super(0);
            }
        })), new ReadWriteByteArray("buffer", this.getBuffer()));
    }
}

