/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.proxy;

import com.cout970.magneticraft.Debug;
import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.misc.LoggerKt;
import com.cout970.magneticraft.misc.RegisterRenderer;
import com.cout970.magneticraft.misc.ResourcesKt;
import com.cout970.magneticraft.proxy.CommonProxy;
import com.cout970.magneticraft.registry.BlocksKt;
import com.cout970.magneticraft.registry.ItemsKt;
import com.cout970.magneticraft.registry.SoundsKt;
import com.cout970.magneticraft.systems.blocks.BlockBase;
import com.cout970.magneticraft.systems.gui.components.CompBookRenderer;
import com.cout970.magneticraft.systems.items.ItemBase;
import com.cout970.magneticraft.systems.manual.Book;
import com.cout970.magneticraft.systems.tileentities.TileBase;
import com.cout970.magneticraft.systems.tilerenderers.TileRenderer;
import com.cout970.modelloader.api.DefaultBlockDecorator;
import com.cout970.modelloader.api.IBakedModelDecorator;
import com.cout970.modelloader.api.ModelLoaderApi;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J.\u0010\u0014\u001a\u00020\f\"\b\b\u0000\u0010\u0015*\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fR\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/cout970/magneticraft/proxy/ClientProxy;", "Lcom/cout970/magneticraft/proxy/CommonProxy;", "()V", "tileRenderers", "", "Lcom/cout970/magneticraft/systems/tilerenderers/TileRenderer;", "Lcom/cout970/magneticraft/systems/tileentities/TileBase;", "getTileRenderers", "()Ljava/util/List;", "getSide", "Lnet/minecraftforge/fml/relauncher/Side;", "initSoundsEvent", "", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/util/SoundEvent;", "onModelRegistryReload", "Lnet/minecraftforge/client/event/ModelBakeEvent;", "postItemRegister", "preInit", "register", "T", "tileEntityClass", "Ljava/lang/Class;", "specialRenderer", "registerBlockAndItemBlockModels", "registerItemModels", "registerTileEntityRenderers", "Magneticraft_1.12"})
public final class ClientProxy
extends CommonProxy {
    @NotNull
    private final List<TileRenderer<? extends TileBase>> tileRenderers;

    @NotNull
    public final List<TileRenderer<? extends TileBase>> getTileRenderers() {
        return this.tileRenderers;
    }

    @SubscribeEvent
    public final void initSoundsEvent(@NotNull RegistryEvent.Register<SoundEvent> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        String prefix$iv = "Task registerSounds:";
        boolean $i$f$logTime = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        IForgeRegistry iForgeRegistry = event.getRegistry();
        Intrinsics.checkExpressionValueIsNotNull((Object)iForgeRegistry, (String)"event.registry");
        SoundsKt.registerSounds((IForgeRegistry<SoundEvent>)iForgeRegistry);
        Unit res$iv = Unit.INSTANCE;
        long end$iv = System.currentTimeMillis();
        LoggerKt.info(prefix$iv + ' ' + (end$iv - start$iv) + "ms", new Object[0]);
    }

    @Override
    public void postItemRegister() {
        super.postItemRegister();
        String prefix$iv = "Task registerItemModels:";
        boolean $i$f$logTime = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.registerItemModels();
        Unit res$iv = Unit.INSTANCE;
        long end$iv = System.currentTimeMillis();
        LoggerKt.info(prefix$iv + ' ' + (end$iv - start$iv) + "ms", new Object[0]);
        prefix$iv = "Task registerBlockAndItemBlockModels:";
        $i$f$logTime = false;
        start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        this.registerBlockAndItemBlockModels();
        res$iv = Unit.INSTANCE;
        end$iv = System.currentTimeMillis();
        LoggerKt.info(prefix$iv + ' ' + (end$iv - start$iv) + "ms", new Object[0]);
        prefix$iv = "Task registerTileEntityRenderers:";
        $i$f$logTime = false;
        start$iv = System.currentTimeMillis();
        boolean bl3 = false;
        this.registerTileEntityRenderers();
        res$iv = Unit.INSTANCE;
        end$iv = System.currentTimeMillis();
        LoggerKt.info(prefix$iv + ' ' + (end$iv - start$iv) + "ms", new Object[0]);
    }

    @Override
    public void preInit() {
        super.preInit();
        OBJLoader.INSTANCE.addDomain("magneticraft");
        String prefix$iv = "Task loadGuideBookPages:";
        boolean $i$f$logTime = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Book res$iv = CompBookRenderer.Companion.getBook();
        long end$iv = System.currentTimeMillis();
        LoggerKt.info(prefix$iv + ' ' + (end$iv - start$iv) + "ms", new Object[0]);
    }

    public final void registerItemModels() {
        Iterable $this$forEach$iv = ItemsKt.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemBase itemBase;
            Item i = (Item)element$iv;
            boolean bl = false;
            Item item = i;
            if (!(item instanceof ItemBase)) {
                item = null;
            }
            if ((ItemBase)item == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            ItemBase item2 = itemBase;
            boolean bl4 = false;
            Object $this$forEach$iv2 = item2.getVariants();
            boolean $i$f$forEach2 = false;
            Object object = $this$forEach$iv2;
            boolean bl5 = false;
            Iterator<Map.Entry<Integer, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, String> element$iv2;
                Map.Entry<Integer, String> variant = element$iv2 = iterator.next();
                boolean bl6 = false;
                Item item3 = item2;
                int n = ((Number)variant.getKey()).intValue();
                ResourceLocation resourceLocation = item2.getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"item.registryName!!");
                ModelLoader.setCustomModelResourceLocation((Item)item3, (int)n, (ModelResourceLocation)ResourcesKt.toModel(resourceLocation, variant.getValue()));
            }
            $this$forEach$iv2 = item2.getCustomModels();
            $i$f$forEach2 = false;
            object = $this$forEach$iv2.iterator();
            while (object.hasNext()) {
                Object element$iv3 = object.next();
                Pair $dstr$state$location = (Pair)element$iv3;
                boolean bl7 = false;
                String state = (String)$dstr$state$location.component1();
                ResourceLocation location = (ResourceLocation)$dstr$state$location.component2();
                ResourceLocation resourceLocation = item2.getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                ModelLoaderApi.INSTANCE.registerModelWithDecorator(new ModelResourceLocation(resourceLocation, state), location, (IBakedModelDecorator)DefaultBlockDecorator.INSTANCE);
            }
        }
    }

    public final void registerBlockAndItemBlockModels() {
        Iterable $this$forEach$iv = BlocksKt.getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockBase blockBase;
            Pair $dstr$block$itemBlock = (Pair)element$iv;
            boolean bl = false;
            Block block = (Block)$dstr$block$itemBlock.component1();
            ItemBlock itemBlock = (ItemBlock)$dstr$block$itemBlock.component2();
            if (itemBlock == null) continue;
            Block block2 = block;
            if (!(block2 instanceof BlockBase)) {
                block2 = null;
            }
            if ((BlockBase)block2 == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            BlockBase blockBase2 = blockBase;
            boolean bl4 = false;
            if (blockBase2.getGenerateDefaultItemModel()) {
                Map<Integer, String> $this$forEach$iv2 = blockBase2.getInventoryVariants();
                boolean $i$f$forEach2 = false;
                Map<Integer, String> map = $this$forEach$iv2;
                boolean bl5 = false;
                Iterator<Map.Entry<Integer, String>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Integer, String> element$iv2;
                    Map.Entry<Integer, String> it = element$iv2 = iterator.next();
                    boolean bl6 = false;
                    Item item = (Item)itemBlock;
                    int n = ((Number)it.getKey()).intValue();
                    ResourceLocation resourceLocation = itemBlock.getRegistryName();
                    if (resourceLocation == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"itemBlock.registryName!!");
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)n, (ModelResourceLocation)ResourcesKt.toModel(resourceLocation, it.getValue()));
                }
            } else {
                Item item = (Item)itemBlock;
                ResourceLocation resourceLocation = itemBlock.getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"itemBlock.registryName!!");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)ResourcesKt.toModel(resourceLocation, "inventory"));
            }
            IStateMapper mapper = blockBase2.getCustomStateMapper();
            if (mapper != null) {
                ModelLoader.setCustomStateMapper((Block)blockBase2, (IStateMapper)mapper);
            }
            Iterable $this$forEach$iv3 = blockBase2.getCustomModels();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Pair $dstr$state$location = (Pair)element$iv3;
                boolean bl7 = false;
                String state = (String)$dstr$state$location.component1();
                ResourceLocation location = (ResourceLocation)$dstr$state$location.component2();
                if (Intrinsics.areEqual((Object)state, (Object)"inventory") || blockBase2.getForceModelBake()) {
                    ResourceLocation resourceLocation = blockBase2.getRegistryName();
                    if (resourceLocation == null) {
                        Intrinsics.throwNpe();
                    }
                    ModelLoaderApi.INSTANCE.registerModelWithDecorator(new ModelResourceLocation(resourceLocation, state), location, (IBakedModelDecorator)DefaultBlockDecorator.INSTANCE);
                    continue;
                }
                ResourceLocation resourceLocation = blockBase2.getRegistryName();
                if (resourceLocation == null) {
                    Intrinsics.throwNpe();
                }
                ModelLoaderApi.INSTANCE.registerModel(new ModelResourceLocation(resourceLocation, state), location, false);
            }
        }
    }

    public final void registerTileEntityRenderers() {
        Set data;
        Set set = data = Magneticraft.INSTANCE.getAsmData$Magneticraft_1_12().getAll(RegisterRenderer.class.getCanonicalName());
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"data");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASMDataTable.ASMData it = (ASMDataTable.ASMData)element$iv;
            boolean bl = false;
            try {
                Class<?> tile;
                Object v3;
                KClass clazz;
                block7: {
                    ASMDataTable.ASMData aSMData = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSMData, (String)"it");
                    Class<?> clazz2 = Class.forName(aSMData.getClassName());
                    Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"Class.forName(it.className)");
                    clazz = JvmClassMappingKt.getKotlinClass(clazz2);
                    Iterable iterable = clazz.getAnnotations();
                    boolean bl2 = false;
                    Iterable iterable2 = iterable;
                    boolean bl3 = false;
                    for (Object t : iterable2) {
                        Annotation it2 = (Annotation)t;
                        boolean bl4 = false;
                        if (!(it2 instanceof RegisterRenderer)) continue;
                        v3 = t;
                        break block7;
                    }
                    v3 = null;
                }
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.misc.RegisterRenderer");
                }
                RegisterRenderer annotation = v3;
                if (annotation.tileEntity() == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<com.cout970.magneticraft.systems.tileentities.TileBase>");
                }
                Object object = clazz.getObjectInstance();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.tilerenderers.TileRenderer<com.cout970.magneticraft.systems.tileentities.TileBase>");
                }
                TileRenderer renderer = (TileRenderer)((Object)object);
                this.register(tile, renderer);
                if (!Debug.INSTANCE.getDEBUG()) continue;
                LoggerKt.info("Registering TESR: Tile = " + clazz.getSimpleName() + ", Renderer = " + ((Object)((Object)renderer)).getClass().getSimpleName(), new Object[0]);
            }
            catch (Exception e) {
                LoggerKt.logError("Unable to register class with @RegisterRenderer: " + it, new Object[0]);
                e.printStackTrace();
            }
        }
    }

    @Override
    @NotNull
    public Side getSide() {
        return Side.CLIENT;
    }

    @SubscribeEvent
    public final void onModelRegistryReload(@NotNull ModelBakeEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Iterable $this$forEach$iv = this.tileRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TileRenderer it = (TileRenderer)((Object)element$iv);
            boolean bl = false;
            it.onModelRegistryReload();
        }
    }

    private final <T extends TileBase> void register(Class<T> tileEntityClass, TileRenderer<T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileEntityClass, (TileEntitySpecialRenderer)specialRenderer);
        this.tileRenderers.add(specialRenderer);
    }

    public ClientProxy() {
        List list;
        ClientProxy clientProxy = this;
        boolean bl = false;
        clientProxy.tileRenderers = list = (List)new ArrayList();
    }
}

