/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.features.electric_machines;

import com.cout970.magneticraft.features.electric_machines.Blocks;
import com.cout970.magneticraft.features.electric_machines.TileElectricEngine;
import com.cout970.magneticraft.misc.RegisterRenderer;
import com.cout970.magneticraft.misc.vector.Vec3dKt;
import com.cout970.magneticraft.systems.tilerenderers.AnimationRenderCache;
import com.cout970.magneticraft.systems.tilerenderers.BaseTileRenderer;
import com.cout970.magneticraft.systems.tilerenderers.FilterAlways;
import com.cout970.magneticraft.systems.tilerenderers.FilterString;
import com.cout970.magneticraft.systems.tilerenderers.FilterTarget;
import com.cout970.magneticraft.systems.tilerenderers.ModelSelector;
import com.cout970.magneticraft.systems.tilerenderers.Utilities;
import com.cout970.modelloader.api.IRenderCache;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@RegisterRenderer(tileEntity=TileElectricEngine.class)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/cout970/magneticraft/features/electric_machines/TileRendererElectricEngine;", "Lcom/cout970/magneticraft/systems/tilerenderers/BaseTileRenderer;", "Lcom/cout970/magneticraft/features/electric_machines/TileElectricEngine;", "()V", "init", "", "render", "te", "Magneticraft_1.12"})
public final class TileRendererElectricEngine
extends BaseTileRenderer<TileElectricEngine> {
    public static final TileRendererElectricEngine INSTANCE;

    @Override
    public void init() {
        this.createModel((Block)Blocks.INSTANCE.getElectricEngine(), new ModelSelector("animation", FilterAlways.INSTANCE, new FilterString("animation", FilterTarget.ANIMATION)));
    }

    @Override
    public void render(@NotNull TileElectricEngine te) {
        boolean isWorking;
        Intrinsics.checkParameterIsNotNull((Object)((Object)te), (String)"te");
        Utilities.INSTANCE.rotateAroundCenter(te.getFacing());
        Utilities.INSTANCE.customRotate(Vec3dKt.vec3Of(0, 0, -90), Vec3dKt.vec3Of(0.5));
        double speedUp = 5.0E-4;
        double speedDown = speedUp * (double)5;
        double speedMultiplier = 3.0;
        World world = te.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"te.world");
        boolean bl = isWorking = world.func_82737_E() - te.getLastWorkingTick() < (long)20;
        if (isWorking) {
            if (te.getAnimationSpeed() < 1.0) {
                TileElectricEngine tileElectricEngine = te;
                tileElectricEngine.setAnimationSpeed(tileElectricEngine.getAnimationSpeed() + speedUp);
            }
        } else if (te.getAnimationSpeed() > speedDown * (double)2) {
            TileElectricEngine tileElectricEngine = te;
            tileElectricEngine.setAnimationSpeed(tileElectricEngine.getAnimationSpeed() - speedDown);
        } else {
            te.setAnimationSpeed(0.0);
            IRenderCache iRenderCache = this.getModel("animation");
            if (iRenderCache == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.cout970.magneticraft.systems.tilerenderers.AnimationRenderCache");
            }
            float length = ((AnimationRenderCache)iRenderCache).getModel().getLength() * (float)20;
            double remaining = (double)length - te.getAnimationStep() % (double)length;
            if (remaining > 0.0 && remaining < (double)length) {
                TileElectricEngine tileElectricEngine = te;
                double d = speedDown * (double)5;
                double d2 = tileElectricEngine.getAnimationStep();
                TileElectricEngine tileElectricEngine2 = tileElectricEngine;
                boolean bl2 = false;
                double d3 = Math.min(d, remaining);
                tileElectricEngine2.setAnimationStep(d2 + d3);
            }
        }
        double d = this.getTime() - te.getAnimationLastTime();
        double d4 = 1000.0;
        boolean bl3 = false;
        double delta = Math.min(d, d4);
        te.setAnimationLastTime(this.getTime());
        TileElectricEngine tileElectricEngine = te;
        tileElectricEngine.setAnimationStep(tileElectricEngine.getAnimationStep() + te.getAnimationSpeed() * delta * speedMultiplier);
        this.setTime(te.getAnimationStep());
        this.renderModel("animation");
    }

    private TileRendererElectricEngine() {
    }

    static {
        TileRendererElectricEngine tileRendererElectricEngine;
        INSTANCE = tileRendererElectricEngine = new TileRendererElectricEngine();
    }
}

