/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.registries.machines.heatrecipes;

import com.cout970.magneticraft.api.internal.registries.machines.heatrecipes.HeatExchangerRecipe;
import com.cout970.magneticraft.api.registries.machines.heatrecipes.IHeatExchangerRecipe;
import com.cout970.magneticraft.api.registries.machines.heatrecipes.IHeatExchangerRecipeManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/cout970/magneticraft/api/internal/registries/machines/heatrecipes/HeatExchangerRecipeManager;", "Lcom/cout970/magneticraft/api/registries/machines/heatrecipes/IHeatExchangerRecipeManager;", "()V", "recipes", "Ljava/util/LinkedList;", "Lcom/cout970/magneticraft/api/registries/machines/heatrecipes/IHeatExchangerRecipe;", "createRecipe", "input", "Lnet/minecraftforge/fluids/FluidStack;", "output", "heat", "", "minTemp", "", "maxTemp", "reverseLow", "", "reverseHigh", "findRecipe", "stack", "getRecipes", "", "registerRecipe", "recipe", "Magneticraft_1.12"})
public final class HeatExchangerRecipeManager
implements IHeatExchangerRecipeManager {
    private static final LinkedList<IHeatExchangerRecipe> recipes;
    public static final HeatExchangerRecipeManager INSTANCE;

    @Override
    @Nullable
    public IHeatExchangerRecipe findRecipe(@NotNull FluidStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        for (IHeatExchangerRecipe rec : recipes) {
            if (!rec.matches(stack)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean registerRecipe(@NotNull IHeatExchangerRecipe recipe) {
        Intrinsics.checkParameterIsNotNull((Object)recipe, (String)"recipe");
        FluidStack fluidStack = recipe.getInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"recipe.input");
        if (this.findRecipe(fluidStack) != null) {
            return false;
        }
        recipes.add(recipe);
        return true;
    }

    @Override
    @NotNull
    public List<IHeatExchangerRecipe> getRecipes() {
        List<IHeatExchangerRecipe> list = Collections.synchronizedList((List)recipes);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.synchronizedList(recipes)");
        return list;
    }

    @Override
    @NotNull
    public IHeatExchangerRecipe createRecipe(@NotNull FluidStack input2, @NotNull FluidStack output2, long heat, double minTemp, double maxTemp, boolean reverseLow, boolean reverseHigh) {
        Intrinsics.checkParameterIsNotNull((Object)input2, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        return new HeatExchangerRecipe(input2, output2, heat, minTemp, maxTemp, reverseLow, reverseHigh);
    }

    private HeatExchangerRecipeManager() {
    }

    static {
        HeatExchangerRecipeManager heatExchangerRecipeManager;
        INSTANCE = heatExchangerRecipeManager = new HeatExchangerRecipeManager();
        recipes = new LinkedList();
    }
}

