/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.internal.energy;

import com.cout970.magneticraft.api.core.NodeID;
import com.cout970.magneticraft.api.energy.IElectricConnection;
import com.cout970.magneticraft.api.energy.IElectricNode;
import com.cout970.magneticraft.api.energy.IWireConnector;
import com.cout970.magneticraft.misc.MathKt;
import com.cout970.magneticraft.misc.vector.Vec3iKt;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0019\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0001J\u0019\u0010\u001a\u001a\u00020\u00132\u000e\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001J\t\u0010\u001e\u001a\u00020\u0015H\u0096\u0001J\t\u0010\u001f\u001a\u00020\u0015H\u0096\u0001J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070&H\u0016J\b\u0010'\u001a\u00020!H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0011\u0010*\u001a\n \u001d*\u0004\u0018\u00010+0+H\u0096\u0001J\t\u0010,\u001a\u00020\u0015H\u0096\u0001J\t\u0010-\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010.\u001a\n \u001d*\u0004\u0018\u00010/0/H\u0096\u0001J\u0011\u00100\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cH\u0096\u0001R!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Lcom/cout970/magneticraft/api/internal/energy/WireConnectorWrapper;", "Lcom/cout970/magneticraft/api/energy/IElectricNode;", "Lcom/cout970/magneticraft/api/energy/IWireConnector;", "node", "connectors", "Lkotlin/Function0;", "", "Lnet/minecraft/util/math/Vec3d;", "Lcom/cout970/magneticraft/IVector3;", "name", "", "(Lcom/cout970/magneticraft/api/energy/IElectricNode;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "getConnectors", "()Lkotlin/jvm/functions/Function0;", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/energy/IElectricNode;", "applyCurrent", "", "current", "", "applyPower", "power", "simulated", "", "deserializeNBT", "p0", "Lnet/minecraft/nbt/NBTTagCompound;", "kotlin.jvm.PlatformType", "getAmperage", "getCapacity", "getConnectorIndex", "", "index", "connector", "connection", "Lcom/cout970/magneticraft/api/energy/IElectricConnection;", "Lcom/google/common/collect/ImmutableList;", "getConnectorsSize", "getId", "Lcom/cout970/magneticraft/api/core/NodeID;", "getPos", "Lnet/minecraft/util/math/BlockPos;", "getResistance", "getVoltage", "getWorld", "Lnet/minecraft/world/World;", "serializeNBT", "Magneticraft_1.12"})
public final class WireConnectorWrapper
implements IElectricNode,
IWireConnector {
    @NotNull
    private final IElectricNode node;
    @NotNull
    private final Function0<List<Vec3d>> connectors;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public NodeID getId() {
        return new NodeID(this.name, this.getPos(), this.getWorld());
    }

    @Override
    @NotNull
    public ImmutableList<Vec3d> getConnectors() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)((Collection)this.connectors.invoke()));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(connectors())");
        return immutableList;
    }

    @Override
    public int getConnectorsSize() {
        return ((List)this.connectors.invoke()).size();
    }

    @Override
    public int getConnectorIndex(int index, @NotNull IWireConnector connector, @NotNull IElectricConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connector, (String)"connector");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        List points = (List)this.connectors.invoke();
        if (points.size() == 3) {
            Vec3d vec3d = (Vec3d)CollectionsKt.first((List)points);
            BlockPos blockPos = this.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
            Vec3d vec3d2 = vec3d.func_178787_e(Vec3iKt.toVec3d((Vec3i)blockPos));
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d2, (String)"points.first().add(pos.toVec3d())");
            ImmutableList<Vec3d> immutableList = connector.getConnectors();
            Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"connector.connectors");
            Vec3d vec3d3 = (Vec3d)CollectionsKt.first((List)((List)immutableList));
            BlockPos blockPos2 = connector.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"connector.pos");
            Vec3d vec3d4 = vec3d3.func_178787_e(Vec3iKt.toVec3d((Vec3i)blockPos2));
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d4, (String)"connector.connectors.fir\u2026(connector.pos.toVec3d())");
            Vec3d vec3d5 = (Vec3d)CollectionsKt.last((List)points);
            BlockPos blockPos3 = this.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos");
            Vec3d vec3d6 = vec3d5.func_178787_e(Vec3iKt.toVec3d((Vec3i)blockPos3));
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d6, (String)"points.last().add(pos.toVec3d())");
            ImmutableList<Vec3d> immutableList2 = connector.getConnectors();
            Intrinsics.checkExpressionValueIsNotNull(immutableList2, (String)"connector.connectors");
            Vec3d vec3d7 = (Vec3d)CollectionsKt.last((List)((List)immutableList2));
            BlockPos blockPos4 = connector.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"connector.pos");
            Vec3d vec3d8 = vec3d7.func_178787_e(Vec3iKt.toVec3d((Vec3i)blockPos4));
            Intrinsics.checkExpressionValueIsNotNull((Object)vec3d8, (String)"connector.connectors.las\u2026(connector.pos.toVec3d())");
            boolean intersects = MathKt.hasIntersection(vec3d2, vec3d4, vec3d6, vec3d8);
            return intersects ? 2 - index : index;
        }
        return index;
    }

    @NotNull
    public final IElectricNode getNode() {
        return this.node;
    }

    @NotNull
    public final Function0<List<Vec3d>> getConnectors() {
        return this.connectors;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public WireConnectorWrapper(@NotNull IElectricNode node, @NotNull Function0<? extends List<? extends Vec3d>> connectors, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(connectors, (String)"connectors");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.node = node;
        this.connectors = connectors;
        this.name = name;
    }

    @Override
    public void applyCurrent(double current) {
        this.node.applyCurrent(current);
    }

    @Override
    public double applyPower(double power, boolean simulated) {
        return this.node.applyPower(power, simulated);
    }

    public void deserializeNBT(NBTTagCompound p0) {
        this.node.deserializeNBT((NBTBase)p0);
    }

    @Override
    public double getAmperage() {
        return this.node.getAmperage();
    }

    @Override
    public double getCapacity() {
        return this.node.getCapacity();
    }

    @Override
    public BlockPos getPos() {
        return this.node.getPos();
    }

    @Override
    public double getResistance() {
        return this.node.getResistance();
    }

    @Override
    public double getVoltage() {
        return this.node.getVoltage();
    }

    @Override
    public World getWorld() {
        return this.node.getWorld();
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.node.serializeNBT();
    }
}

