/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.core;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public final class NodeID
implements INBTSerializable<NBTTagCompound> {
    private final String name;
    private final BlockPos pos;
    private final int dimension;

    public NodeID(String name, BlockPos pos, int dimension) {
        this.name = name;
        this.pos = pos;
        this.dimension = dimension;
    }

    public NodeID(String name, BlockPos pos, World world) {
        this.name = name;
        this.pos = pos;
        this.dimension = world.field_73011_w.getDimension();
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDimension() {
        return this.dimension;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt2 = new NBTTagCompound();
        nbt2.func_74778_a("name", this.name);
        nbt2.func_74768_a("posX", this.pos.func_177958_n());
        nbt2.func_74768_a("posY", this.pos.func_177956_o());
        nbt2.func_74768_a("posZ", this.pos.func_177952_p());
        nbt2.func_74768_a("dimension", this.dimension);
        return nbt2;
    }

    public static NodeID deserializeFromNBT(NBTTagCompound nbt2) {
        String name = nbt2.func_74779_i("name");
        int dimension = nbt2.func_74762_e("dimension");
        int posX = nbt2.func_74762_e("posX");
        int posY = nbt2.func_74762_e("posY");
        int posZ = nbt2.func_74762_e("posZ");
        return new NodeID(name, new BlockPos(posX, posY, posZ), dimension);
    }

    public void deserializeNBT(NBTTagCompound nbt2) {
        throw new IllegalStateException("Immutable class cannot be loaded from NTB, use the static method instead");
    }

    public String toString() {
        return "NodeID{name='" + this.name + '\'' + ", pos=" + this.pos + ", dimension=" + this.dimension + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeID)) {
            return false;
        }
        NodeID nodeID = (NodeID)o;
        if (this.dimension != nodeID.dimension) {
            return false;
        }
        if (this.name != null ? !this.name.equals(nodeID.name) : nodeID.name != null) {
            return false;
        }
        return this.pos != null ? this.pos.equals((Object)nodeID.pos) : nodeID.pos == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        result = 31 * result + this.dimension;
        return result;
    }
}

