/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.block;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.block.BlockBase;
import org.dave.compactmachines3.compat.ITopInfoProvider;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.miniaturization.MultiblockRecipes;
import org.dave.compactmachines3.misc.RotationTools;
import org.dave.compactmachines3.network.MessageParticleBlockMarker;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.render.TESRFieldProjector;
import org.dave.compactmachines3.tile.TileEntityFieldProjector;

public class BlockFieldProjector
extends BlockBase
implements ITileEntityProvider,
ITopInfoProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockFieldProjector(Material material) {
        super(material);
        this.func_149711_c(8.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(CompactMachines3.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFieldProjector();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation("compactmachines3:fieldprojectorcombined", "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFieldProjector.class, (TileEntitySpecialRenderer)new TESRFieldProjector());
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return 0;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityFieldProjector)) {
            return 0;
        }
        TileEntityFieldProjector teProjector = (TileEntityFieldProjector)world.func_175625_s(pos);
        TileEntityFieldProjector master = teProjector.getMasterProjector();
        if (master == null) {
            return 0;
        }
        if (master.getActiveRecipe() == null) {
            return 0;
        }
        return 1 + (int)(master.getCraftingProgressPercent() * 14.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityFieldProjector)) {
            return false;
        }
        TileEntityFieldProjector teProjector = (TileEntityFieldProjector)world.func_175625_s(pos);
        int magnitude = teProjector.getCraftingAreaMagnitude();
        if (magnitude <= 1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.missing_opposite_projector", new Object[0]));
            for (int testMagn = 2; testMagn <= 7; ++testMagn) {
                BlockPos opposite = teProjector.func_174877_v().func_177967_a(teProjector.getDirection(), testMagn * 4);
                PackageHandler.instance.sendTo((IMessage)new MessageParticleBlockMarker((double)opposite.func_177958_n() + 0.5, (double)opposite.func_177956_o() + 0.5, (double)opposite.func_177952_p() + 0.5), (EntityPlayerMP)player);
            }
            return true;
        }
        List<BlockPos> missingProjectors = teProjector.getMissingProjectors(magnitude);
        if (missingProjectors.size() > 0) {
            for (BlockPos missingPos : missingProjectors) {
                int x = missingPos.func_177958_n() - pos.func_177958_n();
                int y = missingPos.func_177956_o() - pos.func_177956_o();
                int z = missingPos.func_177952_p() - pos.func_177952_p();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.missing_projector_at", new Object[]{x, y, z}));
                PackageHandler.instance.sendTo((IMessage)new MessageParticleBlockMarker((double)missingPos.func_177958_n() + 0.5, (double)missingPos.func_177956_o() + 0.5, (double)missingPos.func_177952_p() + 0.5), (EntityPlayerMP)player);
            }
            return true;
        }
        TileEntityFieldProjector master = teProjector.getMasterProjector();
        BlockPos invalidBlock = master.getInvalidBlockInField(magnitude);
        if (invalidBlock != null) {
            ItemStack stack;
            IBlockState blockState = world.func_180495_p(invalidBlock);
            Block block = blockState.func_177230_c();
            String blockName = block.func_149739_a();
            Item item = Item.func_150898_a((Block)block);
            if (item != null && (stack = new ItemStack(item, 1, block.func_176201_c(blockState))) != null) {
                blockName = stack.func_82833_r();
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.invalid_block_in_field", new Object[]{invalidBlock.func_177958_n(), invalidBlock.func_177956_o(), invalidBlock.func_177952_p(), blockName}));
            return true;
        }
        if (!master.getActiveCraftingResult().func_190926_b()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.currently_crafting", new Object[]{master.getActiveCraftingResult().func_82833_r(), String.format("%.1f", Float.valueOf(master.getCraftingProgressPercent() * 100.0f))}));
            return true;
        }
        MultiblockRecipe result = MultiblockRecipes.tryCrafting(world, pos, null);
        if (result == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.no_recipe_found", new Object[0]));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("hint.compactmachines3.found_recipe_for", new Object[]{result.getTargetStack().func_82833_r()}));
        }
        return true;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        float blockReachDistance = 6.0f;
        Vec3d posVec = placer.func_174824_e(1.0f);
        Vec3d lookVec = placer.func_70676_i(1.0f);
        Vec3d endVec = posVec.func_178787_e(lookVec.func_186678_a((double)blockReachDistance));
        RayTraceResult trace = world.func_72933_a(posVec, endVec);
        if (trace == null) {
            return;
        }
        Vec3d hitPosition = trace.field_72307_f;
        hitPosition = hitPosition.func_178788_d(new Vec3d((Vec3i)trace.func_178782_a()));
        hitPosition = hitPosition.func_178786_a(0.5, 0.5, 0.5);
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)RotationTools.getFacingByTriangle(hitPosition)), 2);
        if (!(world.func_175625_s(pos) instanceof TileEntityFieldProjector)) {
            return;
        }
        TileEntityFieldProjector teProjector = (TileEntityFieldProjector)world.func_175625_s(pos);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ownerLeast") && stack.func_77978_p().func_74764_b("ownerMost")) {
            teProjector.setOwner(stack.func_77978_p().func_186857_a("owner"));
        }
        if (!teProjector.hasOwner() && placer instanceof EntityPlayer) {
            teProjector.setOwner((EntityPlayer)placer);
        }
        teProjector.func_70296_d();
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entity) {
        return EnumFacing.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)0.0f, (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p()))).func_176734_d();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityFieldProjector) {
            TileEntityFieldProjector tfp = (TileEntityFieldProjector)te;
            TileEntityFieldProjector master = tfp.getMasterProjector();
            if (master == null) {
                return;
            }
            ItemStack crafting = master.getActiveCraftingResult();
            if (!crafting.func_190926_b()) {
                probeInfo.horizontal().text("{*top.compactmachines3.currently_crafting*}").item(crafting).itemLabel(crafting);
                probeInfo.horizontal().progress((int)(master.getCraftingProgressPercent() * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
                return;
            }
            MultiblockRecipe result = MultiblockRecipes.tryCrafting(world, data.getPos(), null);
            if (result != null) {
                probeInfo.horizontal().text("{*top.compactmachines3.found_recipe_for*}").item(result.getTargetStack()).itemLabel(result.getTargetStack());
            }
        }
    }
}

