/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Fermenter")
public class Fermenter {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluid, IIngredient input, int energy) {
        if (CraftTweakerHelper.toObject(input) == null) {
            return;
        }
        if (CraftTweakerHelper.toStack(output).func_190926_b() && (CraftTweakerHelper.toFluidStack(fluid) == null || CraftTweakerHelper.toFluidStack(fluid).getFluid() == null)) {
            return;
        }
        FermenterRecipe r = new FermenterRecipe(CraftTweakerHelper.toFluidStack(fluid), CraftTweakerHelper.toStack(output), CraftTweakerHelper.toObject(input), energy);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeFluidRecipe(ILiquidStack fluid) {
        if (CraftTweakerHelper.toFluidStack(fluid) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(fluid)));
        }
    }

    @ZenMethod
    public static void removeItemRecipe(IItemStack stack) {
        if (!CraftTweakerHelper.toStack(stack).func_190926_b()) {
            CraftTweakerAPI.apply((IAction)new RemoveStack(CraftTweakerHelper.toStack(stack)));
        }
    }

    @ZenMethod
    public static void removeByInput(IItemStack stack) {
        if (CraftTweakerHelper.toStack(stack) != null) {
            CraftTweakerAPI.apply((IAction)new RemoveByInput(CraftTweakerHelper.toStack(stack)));
        }
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        List<FermenterRecipe> removedRecipes;

        public void apply() {
            this.removedRecipes = new ArrayList<FermenterRecipe>(FermenterRecipe.recipeList);
            FermenterRecipe.recipeList.clear();
        }

        public String describe() {
            return "Removing all Fermenter Recipes";
        }
    }

    private static class RemoveByInput
    implements IAction {
        private final ItemStack input;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || !r.input.matchesItemStack(this.input)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for input " + this.input.func_82833_r();
        }
    }

    private static class RemoveStack
    implements IAction {
        private final ItemStack output;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveStack(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || !OreDictionary.itemMatches((ItemStack)this.output, (ItemStack)r.itemOutput, (boolean)false)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for ItemStack " + this.output.func_82833_r();
        }
    }

    private static class RemoveFluid
    implements IAction {
        private final FluidStack output;
        ArrayList<FermenterRecipe> removedRecipes = new ArrayList();

        public RemoveFluid(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<FermenterRecipe> it = FermenterRecipe.recipeList.iterator();
            while (it.hasNext()) {
                FermenterRecipe r = it.next();
                if (r == null || r.fluidOutput == null || !r.fluidOutput.isFluidEqual(this.output)) continue;
                this.removedRecipes.add(r);
                it.remove();
            }
        }

        public String describe() {
            return "Removing Fermenter Recipes for Fluid " + this.output.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        private final FermenterRecipe recipe;

        public Add(FermenterRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FermenterRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            String fluid = this.recipe.fluidOutput != null ? this.recipe.fluidOutput.getLocalizedName() : "null";
            String out = !this.recipe.itemOutput.func_190926_b() ? this.recipe.itemOutput.func_82833_r() : "null";
            return "Adding Fermenter Recipe for Fluid " + fluid + " and Item " + out;
        }
    }
}

