/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.block;

import com.feed_the_beast.ftblib.lib.block.BlockSpecialDrop;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.item.ItemHammer;
import com.latmod.yabba.item.ItemPainter;
import com.latmod.yabba.tile.IBakedModelBarrel;
import com.latmod.yabba.tile.TileDecorativeBlock;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDecorativeBlock
extends BlockSpecialDrop {
    public static final IUnlistedProperty<IBakedModelBarrel> BARREL = new IUnlistedProperty<IBakedModelBarrel>(){

        public String getName() {
            return "look";
        }

        public boolean isValid(IBakedModelBarrel value) {
            return true;
        }

        public Class<IBakedModelBarrel> getType() {
            return IBakedModelBarrel.class;
        }

        public String valueToString(IBakedModelBarrel value) {
            return value.getLook().toString();
        }
    };
    public static BarrelLook particleLook = BarrelLook.DEFAULT;
    public static EnumFacing particleFacing = EnumFacing.UP;

    public BlockDecorativeBlock() {
        super(Material.field_151575_d, MapColor.field_151663_o);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockHorizontal.field_185512_D}, new IUnlistedProperty[]{BARREL});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileDecorativeBlock();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        TileDecorativeBlock tile = new TileDecorativeBlock();
        tile.setLook(BarrelLook.get(EnumBarrelModel.CRATE, ""));
        ItemStack stack = new ItemStack((Block)this);
        tile.writeToPickBlock(stack);
        list.add((Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (BlockUtils.hasData((ItemStack)stack)) {
            NBTTagCompound tag = BlockUtils.getData((ItemStack)stack);
            tooltip.add(ItemHammer.getModelTooltip(EnumBarrelModel.getFromNBTName(tag.func_74779_i("Model"))));
            tooltip.add(ItemPainter.getSkinTooltip(tag.func_74779_i("Skin")));
        } else {
            tooltip.add(ItemHammer.getModelTooltip(EnumBarrelModel.BARREL));
            tooltip.add(ItemPainter.getSkinTooltip(""));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockDecorativeBlock) {
            return false;
        }
        if ((stack.func_77973_b() == YabbaItems.HAMMER || stack.func_77973_b() == YabbaItems.PAINTER) && (tileEntity = world.func_175625_s(pos)) instanceof TileDecorativeBlock) {
            if (!world.field_72995_K) {
                TileDecorativeBlock deco = (TileDecorativeBlock)tileEntity;
                if (stack.func_77973_b() == YabbaItems.HAMMER) {
                    deco.setLook(BarrelLook.get(ItemHammer.getModel(stack), deco.getLook().skin));
                } else {
                    deco.setLook(BarrelLook.get(deco.getLook().model, ItemPainter.getSkin(stack)));
                }
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (state instanceof IExtendedBlockState && (tileEntity = world.func_175625_s(pos)) instanceof IBakedModelBarrel) {
            return ((IExtendedBlockState)state).withProperty(BARREL, (Object)((IBakedModelBarrel)tileEntity));
        }
        return state;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_190946_v(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer != BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Deprecated
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBakedModelBarrel) {
            IBakedModelBarrel barrel = (IBakedModelBarrel)tileEntity;
            TileEntity tileEntity1 = world.func_175625_s(pos.func_177972_a(side));
            if (tileEntity1 instanceof IBakedModelBarrel) {
                IBakedModelBarrel barrel1 = (IBakedModelBarrel)tileEntity1;
                if (barrel.getLook().equals(barrel1.getLook()) && (barrel.getLook().model.getAABB(EnumFacing.NORTH) == Block.field_185505_j || barrel.getBarrelRotation() == barrel1.getBarrelRotation())) {
                    return false;
                }
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDecorativeBlock) {
            return ((TileDecorativeBlock)tile).getAABB();
        }
        return field_185505_j;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        particleFacing = EnumFacing.UP;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBakedModelBarrel) {
            particleLook = ((IBakedModelBarrel)tileEntity).getLook();
        }
        return false;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        particleFacing = EnumFacing.UP;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBakedModelBarrel) {
            particleLook = ((IBakedModelBarrel)tileEntity).getLook();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        particleFacing = target.field_178784_b;
        TileEntity tileEntity = world.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof IBakedModelBarrel) {
            particleLook = ((IBakedModelBarrel)tileEntity).getLook();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        particleFacing = EnumFacing.UP;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IBakedModelBarrel) {
            particleLook = ((IBakedModelBarrel)tileEntity).getLook();
        }
        return false;
    }
}

