/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.client.render.effect.ExplosionFX;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketExplosionFX
implements IMessage {
    private BlockPos pos;
    private int radius;
    private boolean update;

    public PacketExplosionFX() {
    }

    public PacketExplosionFX(BlockPos pos, int radius, boolean update) {
        this.pos = pos;
        this.radius = radius;
        this.update = update;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeShort(this.radius);
        buf.writeBoolean(this.update);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.radius = buf.readShort();
        this.update = buf.readBoolean();
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketExplosionFX, IMessage> {
        public IMessage handleMessage(PacketExplosionFX message, MessageContext ctx) {
            this.spawnFX(message, ctx);
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void spawnFX(PacketExplosionFX message, MessageContext ctx) {
            if (message.update) {
                FMLClientHandler.instance().reloadRenderers();
            } else {
                ExplosionFX explosionFX = new ExplosionFX(BrandonsCore.proxy.getClientWorld(), Vec3D.getCenter((BlockPos)message.pos), message.radius);
                BCEffectHandler.spawnGLParticle((IGLFXHandler)ExplosionFX.FX_HANDLER, (BCParticle)explosionFX);
            }
        }
    }
}

