/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiTextField;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.SwingHelper;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.UIEditTextArea;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.w3c.dom.Element;

public class DCTextArea
extends DisplayComponentBase {
    public String rawText = "";
    public UIEditTextArea editTextArea = null;

    public DCTextArea(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 20;
    }

    public void initElement() {
        super.initElement();
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        if (this.isBeingEdited) {
            // empty if block
        }
        List<String> display = this.parseRawText();
        int row = 0;
        for (String text : display) {
            int textWidth = this.fontRenderer.func_78256_a(text);
            int yTex = this.yPos + row * this.fontRenderer.field_78288_b;
            int xTex = this.alignment == EnumAlignment.LEFT ? this.xPos + 4 : (this.alignment == EnumAlignment.CENTER ? this.xPos + this.xSize / 2 - textWidth / 2 : this.xPos + this.xSize - textWidth - 4);
            this.drawString(this.fontRenderer, text, xTex, yTex, this.getColour());
            ++row;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return super.keyTyped(typedChar, keyCode);
    }

    public List<String> parseRawText() {
        String text = this.rawText;
        return this.fontRenderer.func_78271_c(text, this.xSize - 6);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Text Alignment"}));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "OPEN_EDITOR", 0, 0, 66, 12, "Show Editor"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Open the editor or bring it to the front if it is already open in the background"}));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("OPEN_EDITOR")) {
            if (this.editTextArea == null) {
                this.editTextArea = new UIEditTextArea(this.rawText);
                this.editTextArea.pack();
            }
            SwingHelper.centerOnMinecraftWindow(this.editTextArea);
            this.editTextArea.setVisible(true);
        } else if (eventElement.id.equals("COLOUR") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            try {
                this.setColour(Integer.parseInt(((MGuiTextField)eventElement).getText(), 16));
                this.element.setAttribute("colour", Integer.toHexString(this.getColour()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onCreated() {
    }

    @Override
    public int getEntryHeight() {
        return this.ySize;
    }

    @Override
    public void save() {
        this.element.setTextContent(this.rawText);
        super.save();
        this.branch.guiWiki.contentWindow.setEditingComponent(null);
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.rawText = element.getTextContent();
    }

    @Override
    public void setXSize(int xSize) {
        super.setXSize(xSize);
        if (this.xSize < 40) {
            this.xSize = 40;
        }
        this.ySize = Math.max(this.parseRawText().size() * this.fontRenderer.field_78288_b, 8);
    }

    @Override
    public boolean onUpdate() {
        if (this.editTextArea != null) {
            if (!this.isBeingEdited) {
                this.editTextArea.dispose();
                this.editTextArea = null;
            } else {
                this.editTextArea.linkTimer = 20;
                if (this.editTextArea.hasChanged) {
                    this.editTextArea.hasChanged = false;
                    this.rawText = this.editTextArea.text;
                    this.requiresSave = true;
                    this.ySize = Math.max(this.parseRawText().size() * this.fontRenderer.field_78288_b, 8);
                    this.list.schedualUpdate();
                }
                if (this.editTextArea.isFinished) {
                    this.save();
                    return true;
                }
            }
        }
        return super.onUpdate();
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCTextArea component = new DCTextArea(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "textArea";
        }
    }
}

