/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.lib.MultiBlockStorage;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.ParticleGenerator;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileInvisECoreBlock;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.integration.funkylocomotion.IMovableStructure;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyCoreStabilizer
extends TileBCBase
implements ITickable,
IMultiBlockPart,
IMovableStructure {
    public final ManagedVec3I coreOffset = (ManagedVec3I)this.register("coreOffset", (IManagedData)new ManagedVec3I(new Vec3I(0, -1, 0))).syncViaTile().saveToTile().finish();
    public final ManagedBool hasCoreLock = (ManagedBool)this.register("hasCoreLock", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().finish();
    public final ManagedBool isCoreActive = (ManagedBool)this.register("isCoreActive", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().finish();
    public final ManagedBool isValidMultiBlock = (ManagedBool)this.register("isValidMultiBlock", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public EnumFacing.Axis multiBlockAxis = EnumFacing.Axis.Y;
    public EnumFacing coreDirection = EnumFacing.DOWN;
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    private boolean moveCheckComplete = false;

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K && this.hasCoreLock.value && this.isCoreActive.value) {
            this.rotation = ClientEventHandler.elapsedTicks;
            this.updateVisual();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateVisual() {
        Vec3D spawn = new Vec3D(this.field_174879_c);
        spawn.add(0.5, 0.5, 0.5);
        double rand = (double)this.field_145850_b.field_73012_v.nextInt(100) / 12.0;
        double randOffset = rand * (Math.PI * 2);
        double offsetX = Math.sin((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        double offsetY = Math.cos((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        if (!this.isValidMultiBlock.value || this.field_145850_b.field_73012_v.nextBoolean()) {
            double inset;
            double d = this.isValidMultiBlock.value ? 1.1 : 0.25;
            double d2 = inset = this.isValidMultiBlock.value ? 1.0 : 0.0;
            if (this.coreDirection.func_176740_k() == EnumFacing.Axis.Z) {
                spawn.add(offsetX * d, offsetY * d, (this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset);
            } else if (this.coreDirection.func_176740_k() == EnumFacing.Axis.Y) {
                spawn.add(offsetX * d, (this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d);
            } else if (this.coreDirection.func_176740_k() == EnumFacing.Axis.X) {
                spawn.add((this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d, offsetX * d);
            }
            BCEffectHandler.spawnFX((int)DEParticles.ENERGY_CORE_FX, (World)this.field_145850_b, (Vec3D)spawn, (Vec3D)new Vec3D(this.field_174879_c).subtract(this.coreOffset.vec.getPos()).add(0.5, 0.5, 0.5), (int[])new int[]{1, (int)(randOffset * 100.0), this.isValidMultiBlock.value ? 1 : 0});
        } else {
            if (this.coreDirection.func_176740_k() == EnumFacing.Axis.Z) {
                spawn.add(offsetX * 1.2, offsetY * 1.2, this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38);
            } else if (this.coreDirection.func_176740_k() == EnumFacing.Axis.Y) {
                spawn.add(offsetX * 1.2, this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2);
            } else if (this.coreDirection.func_176740_k() == EnumFacing.Axis.X) {
                spawn.add(this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2, offsetX * 1.2);
            }
            BCEffectHandler.spawnFX((int)DEParticles.ENERGY_CORE_FX, (World)this.field_145850_b, (Vec3D)spawn, (Vec3D)new Vec3D(this.field_174879_c).add(0.5, 0.5, 0.5), (int[])new int[]{0});
        }
    }

    public void onTileClicked(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileEnergyStorageCore core = this.getCore();
        if (core == null) {
            core = this.findCore();
        }
        if (core != null) {
            core.onStructureClicked(world, pos, state, player);
        } else {
            player.func_145747_a(new TextComponentTranslation("msg.de.coreNotFound.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
        }
    }

    public boolean isStabilizerValid(int coreTier, TileEnergyStorageCore core) {
        if (coreTier < 5 && !this.isValidMultiBlock.value) {
            return true;
        }
        if (coreTier >= 5 && this.isValidMultiBlock.value) {
            BlockPos offset = this.field_174879_c.func_177973_b((Vec3i)core.func_174877_v());
            EnumFacing direction = EnumFacing.func_176737_a((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p()).func_176734_d();
            return direction.func_176740_k() == this.multiBlockAxis;
        }
        return false;
    }

    public void onPlaced() {
        if (this.field_145850_b.field_72995_K || this.checkAndFormMultiBlock()) {
            return;
        }
        for (EnumFacing facing1 : EnumFacing.field_82609_l) {
            BlockPos search = this.field_174879_c.func_177982_a(facing1.func_82601_c(), facing1.func_96559_d(), facing1.func_82599_e());
            TileEntity stabilizer = this.field_145850_b.func_175625_s(search);
            if (stabilizer instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)stabilizer).checkAndFormMultiBlock()) {
                return;
            }
            for (EnumFacing facing2 : EnumFacing.field_82609_l) {
                BlockPos s2;
                if (facing2 == facing1 || facing2 == facing1.func_176734_d() || !((stabilizer = this.field_145850_b.func_175625_s(s2 = search.func_177982_a(facing2.func_82601_c(), facing2.func_96559_d(), facing2.func_82599_e()))) instanceof TileEnergyCoreStabilizer) || !((TileEnergyCoreStabilizer)stabilizer).checkAndFormMultiBlock()) continue;
                return;
            }
        }
    }

    private boolean checkAxisValid(EnumFacing.Axis axis) {
        for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)axis)) {
            if (this.isAvailable(this.field_174879_c.func_177971_a((Vec3i)offset))) continue;
            return false;
        }
        return true;
    }

    private boolean checkAndFormMultiBlock() {
        if (this.hasCoreLock.value && this.getCore() != null && this.getCore().active.value) {
            return false;
        }
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            if (!this.checkAxisValid(axis)) continue;
            this.buildMultiBlock(axis);
            return true;
        }
        return false;
    }

    private boolean isAvailable(BlockPos pos) {
        if (this.isValidMultiBlock.value) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            return tile instanceof TileInvisECoreBlock && ((TileInvisECoreBlock)tile).getController() == this;
        }
        TileEntity stabilizer = this.field_145850_b.func_175625_s(pos);
        return stabilizer instanceof TileEnergyCoreStabilizer && (!((TileEnergyCoreStabilizer)stabilizer).hasCoreLock.value || ((TileEnergyCoreStabilizer)stabilizer).getCore() == null || !((TileEnergyCoreStabilizer)stabilizer).getCore().active.value);
    }

    private void buildMultiBlock(EnumFacing.Axis axis) {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)ParticleGenerator.TYPE, (Comparable)((Object)"stabilizer2")));
        for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)axis)) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177971_a((Vec3i)offset), DEFeatures.invisECoreBlock.func_176223_P());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)offset));
            if (!(tile instanceof TileInvisECoreBlock)) continue;
            ((TileInvisECoreBlock)tile).blockName = "draconicevolution:particle_generator";
            ((TileInvisECoreBlock)tile).setController(this);
        }
        this.isValidMultiBlock.value = true;
        this.multiBlockAxis = axis;
    }

    public void deFormStructure() {
        this.isValidMultiBlock.value = false;
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == DEFeatures.particleGenerator) {
            this.field_145850_b.func_175656_a(this.field_174879_c, DEFeatures.particleGenerator.func_176223_P().func_177226_a((IProperty)ParticleGenerator.TYPE, (Comparable)((Object)"stabilizer")));
        }
        if (this.getCore() != null) {
            this.getCore().deactivateCore();
        }
        for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)this.multiBlockAxis)) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)offset));
            if (!(tile instanceof TileInvisECoreBlock)) continue;
            ((TileInvisECoreBlock)tile).revert();
        }
    }

    @Override
    public boolean validateStructure() {
        if (this.checkAxisValid(this.multiBlockAxis)) {
            return true;
        }
        this.deFormStructure();
        return false;
    }

    @Override
    public boolean isStructureValid() {
        return this.isValidMultiBlock.value;
    }

    @Override
    public IMultiBlockPart getController() {
        return this;
    }

    public TileEnergyStorageCore findCore() {
        if (this.getCore() != null) {
            return this.getCore();
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            for (int i = 0; i < 16; ++i) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(facing.func_82601_c() * i, facing.func_96559_d() * i, facing.func_82599_e() * i));
                if (!(tile instanceof TileEnergyStorageCore)) continue;
                TileEnergyStorageCore core = (TileEnergyStorageCore)tile;
                core.validateStructure();
                if (core.active.value) continue;
                return core;
            }
        }
        return null;
    }

    public TileEnergyStorageCore getCore() {
        if (this.hasCoreLock.value) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
            if (tile instanceof TileEnergyStorageCore) {
                return (TileEnergyStorageCore)tile;
            }
            this.hasCoreLock.value = false;
        }
        return null;
    }

    private BlockPos getCorePos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.coreOffset.vec.getPos());
    }

    public void setCore(TileEnergyStorageCore core) {
        BlockPos offset = this.field_174879_c.func_177973_b((Vec3i)core.func_174877_v());
        this.coreOffset.vec = new Vec3I(offset);
        this.hasCoreLock.value = true;
        this.coreDirection = EnumFacing.func_176737_a((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p()).func_176734_d();
        this.updateBlock();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        SPacketUpdateTileEntity packet = super.func_189518_D_();
        NBTTagCompound compound = packet.field_148860_e;
        compound.func_74774_a("StructureAxis", (byte)this.multiBlockAxis.ordinal());
        compound.func_74774_a("CoreDirection", (byte)this.coreDirection.func_176745_a());
        return packet;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound compound = pkt.func_148857_g();
        EnumFacing.Axis[] values = EnumFacing.Axis.values();
        byte i = compound.func_74771_c("StructureAxis");
        this.multiBlockAxis = i >= 0 && i < values.length ? values[i] : EnumFacing.Axis.Y;
        this.coreDirection = EnumFacing.func_82600_a((int)compound.func_74771_c("CoreDirection"));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() != newSate.func_177230_c()) {
            return true;
        }
        boolean wasStab = ((String)((Object)oldState.func_177229_b((IProperty)ParticleGenerator.TYPE))).endsWith("stabilizer") || ((String)((Object)oldState.func_177229_b((IProperty)ParticleGenerator.TYPE))).endsWith("stabilizer2");
        boolean isStab = ((String)((Object)newSate.func_177229_b((IProperty)ParticleGenerator.TYPE))).endsWith("stabilizer") || ((String)((Object)newSate.func_177229_b((IProperty)ParticleGenerator.TYPE))).endsWith("stabilizer2");
        return wasStab != isStab;
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        if (this.multiBlockAxis != null) {
            compound.func_74774_a("StructureAxis", (byte)this.multiBlockAxis.ordinal());
            compound.func_74774_a("CoreDirection", (byte)this.coreDirection.func_176745_a());
        }
    }

    public void readExtraNBT(NBTTagCompound compound) {
        EnumFacing.Axis[] values = EnumFacing.Axis.values();
        byte i = compound.func_74771_c("StructureAxis");
        this.multiBlockAxis = i >= 0 && i < values.length ? values[i] : EnumFacing.Axis.Y;
        this.coreDirection = EnumFacing.func_82600_a((int)compound.func_74771_c("CoreDirection"));
    }

    private Set<BlockPos> getStabilizerBlocks() {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        blocks.add(this.field_174879_c);
        if (this.isValidMultiBlock.value) {
            for (BlockPos offset : FacingUtils.getAroundAxis((EnumFacing.Axis)this.multiBlockAxis)) {
                blocks.add(this.field_174879_c.func_177971_a((Vec3i)offset));
            }
        }
        return blocks;
    }

    @Override
    public Iterable<BlockPos> getBlocksForFrameMove() {
        TileEnergyStorageCore core = this.getCore();
        if (core != null && !core.moveBlocksProvided) {
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            for (ManagedVec3I offset : core.stabOffsets) {
                BlockPos stabPos = core.func_174877_v().func_177973_b((Vec3i)offset.vec.getPos());
                TileEntity tile = this.field_145850_b.func_175625_s(stabPos);
                if (!(tile instanceof TileEnergyCoreStabilizer)) continue;
                blocks.addAll(((TileEnergyCoreStabilizer)tile).getStabilizerBlocks());
            }
            EnergyCoreStructure structure = core.coreStructure;
            MultiBlockStorage storage = structure.getStorageForTier(core.tier.value);
            BlockPos start = core.func_174877_v().func_177971_a((Vec3i)structure.getCoreOffset(core.tier.value));
            storage.forEachBlock(start, (e, e2) -> blocks.add((BlockPos)e));
            return blocks;
        }
        return Collections.emptyList();
    }

    @Override
    public EnumActionResult canMove() {
        TileEnergyStorageCore core = this.getCore();
        if (core != null && core.structureValid.value && core.active.value) {
            if (core.isFrameMoving) {
                return EnumActionResult.SUCCESS;
            }
            if (!this.moveCheckComplete) {
                ++core.frameMoveContactPoints;
            }
            this.moveCheckComplete = true;
            if (core.frameMoveContactPoints == 4) {
                core.frameMoveContactPoints = 0;
                core.isFrameMoving = true;
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }
}

