/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import codechicken.lib.util.RotationUtils;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRegistryOverride;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluidGate;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluxGate;
import com.brandon3055.draconicevolution.lib.PropertyStringTemp;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class FlowGate
extends BlockBCore
implements IRegistryOverride {
    public static final PropertyStringTemp TYPE = new PropertyStringTemp("type", "flux", "fluid");
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public FlowGate() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)"flux")).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.addName(0, "flux_gate");
        this.addName(8, "fluid_gate");
    }

    public boolean uberIsBlockFullCube() {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TYPE, (Comparable)((Object)((meta & 8) > 0 ? "fluid" : "flux")));
    }

    public int func_176201_c(IBlockState state) {
        int i;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        if (((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("fluid")) {
            i |= 8;
        }
        return i;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 8));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing facing = RotationUtils.getPlacedRotation((BlockPos)pos, (EntityLivingBase)placer);
        if (placer.func_70093_af()) {
            facing = facing.func_176734_d();
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)TYPE, (Comparable)((Object)((stack.func_77952_i() & 8) > 0 ? "fluid" : "flux"))), 2);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("flux") ? new TileFluxGate() : new TileFluidGate();
    }

    public void handleCustomRegistration(Feature feature) {
        GameRegistry.registerTileEntity(TileFluxGate.class, (String)(feature.getModid() + ":flux_gate"));
        GameRegistry.registerTileEntity(TileFluidGate.class, (String)(feature.getModid() + ":fluid_gate"));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)DraconicEvolution.instance, (int)13, (World)worldIn, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        stack.func_77964_b(((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("flux") ? 0 : 8);
        return stack;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("fluid") ? 8 : 0;
    }
}

