/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.meteor.extrabotany.ExtraBotanyCreativeTab;
import com.meteor.extrabotany.api.item.IAdvancementRequired;
import com.meteor.extrabotany.client.render.IModelReg;
import com.meteor.extrabotany.common.entity.EntityItemUnbreakable;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemDaedalusStormbow
extends ItemBow
implements IManaUsingItem,
IRelic,
IModelReg,
IAdvancementRequired {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemDaedalusStormbow() {
        this.func_77637_a(ExtraBotanyCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("extrabotany", "daedalusstormbow"));
        this.func_77655_b("daedalusstormbow");
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityItemUnbreakable(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        super.onUsingTick(stack, living, count);
        if (!(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        World world = player.field_70170_p;
        boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = this.findAmmo(player);
        if (count % 8 == 0) {
            boolean flag1 = player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, player);
            for (int i = 0; i < 4; ++i) {
                int k;
                if (itemstack.func_190926_b() && !flag) continue;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack(Items.field_151032_g);
                }
                if (world.field_72995_K) continue;
                RayTraceResult raytrace = ToolCommons.raytraceFromEntity((World)world, (Entity)player, (boolean)false, (double)32.0);
                if (raytrace == null || raytrace.func_178782_a() == null) {
                    return;
                }
                BlockPos target = raytrace.func_178782_a().func_177982_a(0, 1, 0);
                int dx = (int)(-3.0 + 6.0 * Math.random());
                int dz = (int)(-3.0 + 6.0 * Math.random());
                BlockPos spawnpoint = target.func_177982_a(dx, 20, dz);
                double d0 = target.func_177958_n() - spawnpoint.func_177958_n();
                double d2 = target.func_177952_p() - spawnpoint.func_177952_p();
                double d1 = target.func_177956_o() - spawnpoint.func_177956_o();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                float rotationPitch = this.updateRotation(player.field_70125_A, f1, 360.0f);
                float rotationYaw = this.updateRotation(player.field_70177_z, f, 360.0f);
                ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, (EntityLivingBase)player);
                entityarrow.func_184547_a((Entity)player, rotationPitch, rotationYaw, 0.0f, 4.0f, 0.3f);
                entityarrow.func_70107_b((double)spawnpoint.func_177958_n(), (double)spawnpoint.func_177956_o(), (double)spawnpoint.func_177952_p());
                entityarrow.func_70243_d(true);
                int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                if (j > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityarrow.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityarrow.func_70015_d(100);
                }
                if (flag1 || player.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                world.func_72838_d((Entity)entityarrow);
            }
            if (!flag1 && !player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(itemstack);
                }
            }
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public int func_77619_b() {
        return 10;
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item\\.", "item.extrabotany:");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.updateRelic(stack, (EntityPlayer)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemDaedalusStormbow.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ItemDaedalusStormbow.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[0]), list);
            } else {
                ItemDaedalusStormbow.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{Minecraft.func_71410_x().field_71439_g.func_70005_c_()}), list);
            }
        } else {
            ItemDaedalusStormbow.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof EntityPlayerMP) {
                RelicBindTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemDaedalusStormbow.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    @Override
    public String getAdvancementName(ItemStack stack) {
        return "natureorbCraft";
    }
}

