/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.bonus;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.item.Bonus;
import com.meteor.extrabotany.api.item.WeightCategory;
import com.meteor.extrabotany.common.item.ItemMod;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemBonusBase
extends ItemMod {
    private static final String TAG_WEIGHT = "weight";
    private static Random random = new Random();

    public ItemBonusBase(String name) {
        super(name);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.rollItem(stack, player) != null) {
            ItemStack newstack = this.rollItem(stack, player).func_77946_l();
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            this.onBonusOpen(world, player, stack, newstack);
            player.func_70099_a(newstack, 0.0f).func_174868_q();
            stack.func_190918_g(1);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void onBonusOpen(World world, EntityPlayer player, ItemStack stackold, ItemStack stacknew) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        DecimalFormat df = new DecimalFormat("0.00%");
        int weightSum = 0;
        for (WeightCategory wc : this.getWeightCategory(par1ItemStack)) {
            weightSum += wc.getWeight().intValue();
        }
        this.setSum(par1ItemStack, weightSum);
        if (GuiScreen.func_146272_n()) {
            this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.bonusbase", (Object[])new Object[0]), stacks);
            for (WeightCategory wc : this.getWeightCategory(par1ItemStack)) {
                String num = df.format((float)wc.getWeight().intValue() / (float)this.getSum(par1ItemStack));
                String name = I18n.func_135052_a((String)(wc.getCategory().func_77973_b().func_77657_g(wc.getCategory()) + ".name"), (Object[])new Object[0]);
                TextFormatting text = (float)wc.getWeight().intValue() / (float)this.getSum(par1ItemStack) < 0.01f ? TextFormatting.GOLD : TextFormatting.RESET;
                this.addStringToTooltip(text + name + " x" + wc.getCategory().func_190916_E() + " " + num, stacks);
            }
        } else {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), stacks);
        }
    }

    void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        this.setSum(stack, Bonus.sum(this.getWeightCategory(stack)));
    }

    public ItemStack rollItem(ItemStack stack, EntityPlayer player) {
        return this.rollItem(stack, player, this.getWeightCategory(stack));
    }

    public ItemStack rollItem(ItemStack stack, EntityPlayer player, List<WeightCategory> weightcategory) {
        int weightSum = 0;
        for (WeightCategory wc : weightcategory) {
            weightSum += wc.getWeight().intValue();
        }
        int n = random.nextInt(weightSum);
        int m = 0;
        for (WeightCategory wc : weightcategory) {
            if (m <= n && n < m + wc.getWeight()) {
                if (wc.getWeight() <= 1) {
                    ExtraBotanyAPI.unlockAdvancement(player, "luckyDraw");
                }
                return wc.getCategory();
            }
            m += wc.getWeight().intValue();
        }
        return null;
    }

    public List<WeightCategory> getWeightCategory(ItemStack stack) {
        return null;
    }

    public void setSum(ItemStack stack, int i) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_WEIGHT, (int)i);
    }

    public int getSum(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_WEIGHT, (int)0);
    }
}

