/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.integration.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAction;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.meteor.extrabotany.ExtraBotany;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.crafting.recipe.RecipePedestal;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extrabotany.Pedestal")
@ModOnly(value="extrabotany")
@ZenRegister
public class Pedestal {
    @ZenMethod
    public static void add(IItemStack output, IItemStack input) {
        ExtraBotany.LATE_ADDITIONS.add((IAction)new AddShaped(output, input));
    }

    @ZenMethod
    public static void remove(IItemStack output, @Optional IItemStack input) {
        ExtraBotany.LATE_REMOVALS.add((IAction)new RemoveShaped(output, input));
    }

    public static class RemoveShaped
    extends BaseListRemoval<RecipePedestal> {
        private final IItemStack output;
        private final IItemStack input;

        protected RemoveShaped(IItemStack output, IItemStack input) {
            super("Remove Pedestal Recipe", ExtraBotanyAPI.pedestalRecipes);
            this.output = output;
            this.input = input;
        }

        public void apply() {
            LinkedList<RecipePedestal> recipes = new LinkedList<RecipePedestal>();
            for (RecipePedestal entry : ExtraBotanyAPI.pedestalRecipes) {
                if (entry == null || entry.getOutput() == null || !StackHelper.matches((IIngredient)this.output, (IItemStack)InputHelper.toIItemStack((ItemStack)entry.getOutput()))) continue;
                recipes.add(entry);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        protected String getRecipeInfo(RecipePedestal arg0) {
            return this.output.getDisplayName();
        }
    }

    public static class AddShaped
    extends BaseAction {
        private final IItemStack output;
        private final IItemStack input;

        public AddShaped(IItemStack output, IItemStack input) {
            super("Add Pedestal Recipe");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            ExtraBotanyAPI.registerPedestalRecipe(InputHelper.toStack((IItemStack)this.output), InputHelper.toStack((IItemStack)this.input));
        }

        protected String getRecipeInfo() {
            return this.output.getDisplayName();
        }
    }
}

