/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.gaia;

import com.google.common.base.Optional;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.entity.IBossProjectile;
import com.meteor.extrabotany.api.entity.IEntityWithShield;
import com.meteor.extrabotany.common.brew.ModPotions;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.core.handler.ModSounds;
import com.meteor.extrabotany.common.core.handler.PersistentVariableHandler;
import com.meteor.extrabotany.common.entity.EntitySubspace;
import com.meteor.extrabotany.common.entity.gaia.EntityDomain;
import com.meteor.extrabotany.common.entity.gaia.EntitySkullLandmine;
import com.meteor.extrabotany.common.entity.gaia.EntitySkullMissile;
import com.meteor.extrabotany.common.entity.gaia.EntitySubspaceLance;
import com.meteor.extrabotany.common.entity.gaia.EntitySwordDomain;
import com.meteor.extrabotany.common.entity.gaia.EntityVoid;
import com.meteor.extrabotany.common.item.ItemMaterial;
import com.meteor.extrabotany.common.item.ModItems;
import io.netty.buffer.ByteBuf;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntityVoidHerrscher
extends EntityCreature
implements IBotaniaBoss,
IEntityWithShield,
IEntityAdditionalSpawnData {
    public static final float ARENA_RANGE = 15.0f;
    private static final int SPAWN_TICKS = 160;
    private static final float MAX_HP = 400.0f;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final String TAG_RANKII = "rank2";
    private static final String TAG_RANKIII = "rank3";
    private static final String TAG_SHIELD = "shield";
    private static final String TAG_HARDCORE = "hardcore";
    private static final String TAG_SHIELDS = "shields";
    private static final String TAG_DAMAGETAKEN = "damagetaken";
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> INVUL_TIME = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELDS = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLAYER_COUNT = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> SOURCE = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> RANKII = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RANKIII = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HARDCORE = EntityDataManager.func_187226_a(EntityVoidHerrscher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final BlockPos[] PYLON_LOCATIONS = new BlockPos[]{new BlockPos(4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, 4), new BlockPos(-4, 1, -4)};
    private static final BlockPos[] MINION_LOCATIONS = new BlockPos[]{new BlockPos(3, 1, 3), new BlockPos(3, 1, -3), new BlockPos(-3, 1, 3), new BlockPos(-3, 1, -3)};
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation("entity.extrabotany:voidherrscher.name", new Object[0]), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = BlockPos.field_177992_a;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int cd = 200;
    private int dodgecd = 300;
    private int skillType = 0;
    public final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    public EntityPlayer trueKiller = null;
    public static int rot = -180;
    private int supportcd = 300;
    private List<String> contributorlist = PersistentVariableHandler.contributors;
    private boolean quickkill = true;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    @SideOnly(value=Side.CLIENT)
    private static Rectangle barRect;
    @SideOnly(value=Side.CLIENT)
    private static Rectangle hpBarRect;
    @SideOnly(value=Side.CLIENT)
    private ShaderCallback shaderCallback;

    public EntityVoidHerrscher(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 1725;
        if (world.field_72995_K) {
            Botania.proxy.addBoss((IBotaniaBoss)this);
        }
    }

    public void func_70606_j(float health) {
        super.func_70606_j(Math.max(health, this.func_110143_aJ() - 25.0f));
    }

    private void punish() {
        if (!ConfigHandler.ENABLE_ILLEGALACTION && this.getPlayersAround().size() > this.playerCount) {
            if (this.field_70170_p.field_72995_K) {
                for (EntityPlayer player : this.getPlayersAround()) {
                    if (player == null || player.field_70128_L) continue;
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.illegalBattle", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        int count;
        int base;
        Iterator<Object> iterator;
        int invul;
        Vec3d vec3d;
        super.func_70636_d();
        if (this.field_70170_p.func_72890_a((Entity)this, 6.0) != null && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)this, (int)16, (int)7, (Vec3d)new Vec3d(this.field_70170_p.func_72890_a((Entity)this, (double)6.0).field_70165_t, this.field_70170_p.func_72890_a((Entity)this, (double)6.0).field_70163_u, this.field_70170_p.func_72890_a((Entity)this, (double)6.0).field_70161_v))) != null) {
            this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, (double)1.2f);
        }
        this.punish();
        if (this.field_70173_aa > 3600) {
            this.quickkill = false;
        }
        if ((invul = this.getInvulTime()) > 0) {
            this.setInvulTime(invul - 1);
            if (invul > 15) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
        }
        if ((iterator = this.getPlayersAround().iterator()).hasNext()) {
            EntityPlayer player = iterator.next();
            this.func_70625_a((Entity)player, 360.0f, 360.0f);
        }
        if (this.getShields() > 2) {
            for (Entity p : this.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(this.field_70165_t - 2.5, this.field_70163_u - 2.5, this.field_70161_v - 2.5, this.field_70165_t + 2.5, this.field_70163_u + 2.5, this.field_70161_v + 2.5))) {
                if (p instanceof IBossProjectile && ((IBossProjectile)p).isBoss(p) || !(p instanceof IProjectile)) continue;
                ((IProjectile)p).func_70186_c((double)(-net.minecraft.util.math.MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * net.minecraft.util.math.MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)))), (double)(-net.minecraft.util.math.MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180)))), (double)(net.minecraft.util.math.MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * net.minecraft.util.math.MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)))), 1.5f, 0.0f);
                p.getEntityData().func_74778_a("ownerName", this.func_70005_c_());
            }
        }
        EntitySubspace sub = new EntitySubspace(this.field_70170_p, (EntityLivingBase)this);
        sub.setLiveTicks(32);
        sub.setDelay(12);
        sub.field_70165_t = this.field_70165_t;
        sub.field_70163_u = this.field_70163_u + (double)1.9f;
        sub.field_70161_v = this.field_70161_v;
        sub.field_70177_z = this.field_70177_z;
        sub.setRotation(net.minecraft.util.math.MathHelper.func_76142_g((float)(-this.field_70177_z + 180.0f)));
        sub.setType(1);
        sub.setSize(0.4f + this.field_70170_p.field_73012_v.nextFloat() * 0.15f);
        if (!(this.field_70170_p.field_72995_K || this.field_70173_aa % 72 != 0 && this.dodgecd != 280)) {
            this.field_70170_p.func_72838_d((Entity)sub);
        }
        if (this.field_70173_aa == 100) {
            EntitySubspaceLance lance = new EntitySubspaceLance(this.field_70170_p, (EntityLivingBase)this);
            lance.setDamage(3);
            lance.setLife(4800);
            lance.setPitch(-90.0f);
            lance.func_70107_b(this.source.func_177958_n(), this.source.func_177956_o(), this.source.func_177952_p());
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)lance);
            }
        }
        for (EntityPlayer player : this.getPlayersAround()) {
            if (this.playersWhoAttacked.contains(player.func_110124_au())) continue;
            this.playersWhoAttacked.add(player.func_110124_au());
        }
        if (!this.getRankII() && this.func_110143_aJ() <= this.func_110138_aP() * 0.8f) {
            this.setRankII(true);
            this.setShield(5);
            this.spawnDivineJudge();
            this.setShields(1);
            for (int i = 0; i < 2; ++i) {
                this.spawnSubspaceLanceRandomly();
            }
        }
        if (!this.getRankIII() && this.func_110143_aJ() <= this.func_110138_aP() * 0.25f) {
            this.setRankIII(true);
            this.setShields(3);
            for (int i = 0; i < 4; ++i) {
                this.spawnSubspaceLanceRandomly();
            }
            if (this.playersWhoAttacked.size() > 0) {
                this.func_70606_j(this.func_110138_aP());
            }
        }
        BlockPos source = this.getSource();
        if (this.getRankII() && this.field_70163_u < (double)((float)source.func_177956_o() + 2.0f)) {
            this.field_70181_x = 0.1f;
        }
        if (this.field_70170_p.field_72995_K) {
            EntityPlayer player;
            this.particles();
            player = Botania.proxy.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
            }
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.smashCheatyBlocks();
        List<EntityPlayer> players = this.getPlayersAround();
        if (players.isEmpty() && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.func_70106_y();
        } else {
            for (EntityPlayer player : players) {
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
                int potionLevel = 1 + (this.getRankIII() ? 2 : 0) + this.field_70173_aa >= 1800 ? 2 : 0;
                player.func_70690_d(new PotionEffect(ModPotions.witchcurse, 200, potionLevel));
                if (this.supportcd != 0) continue;
                this.support(player);
            }
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.getRankIII()) {
            if (this.supportcd > 0) {
                --this.supportcd;
            }
            if (this.field_70173_aa % 80 == 0) {
                for (int t = 0; t < 2; ++t) {
                    this.spawnMissile(2);
                }
                this.func_70691_i(1.0f);
            }
            if (this.cd == 0 && this.skillType == 1) {
                this.spawnVoidJudge();
                this.cd = 250;
                this.skillType = 2;
            }
        }
        if (this.getRankII() && this.field_70173_aa % 110 == 0) {
            this.spawnMissile(1);
        }
        if (this.field_70173_aa > 60 && this.field_70173_aa % 60 == 0) {
            this.spawnMissile(0);
            if (this.field_70170_p.field_73012_v.nextInt(10) < 4) {
                this.spawnMissile(1);
            }
        }
        int n = base = this.getHardcore() ? 9 + this.playerCount * 3 : 7 + this.playerCount * 3;
        int n2 = this.getRankIII() ? base + 6 : (count = this.getRankII() ? base + 2 : base);
        if (this.field_70173_aa > 200 && this.field_70173_aa % (this.getRankIII() ? 220 : (this.getRankII() ? 260 : 310)) == 0) {
            for (int i = 0; i < count; ++i) {
                int x = source.func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                int z = source.func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                int y = (int)players.get((int)this.field_70146_Z.nextInt((int)players.size())).field_70163_u;
                EntitySkullLandmine landmine = new EntitySkullLandmine(this.field_70170_p);
                if (i % 8 == 0) {
                    landmine.setType(2);
                }
                if (i % 6 == 0) {
                    landmine.setType(1);
                }
                landmine.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                landmine.summoner = this;
                this.field_70170_p.func_72838_d((Entity)landmine);
            }
        }
        for (EntityPlayer player : this.getPlayersAround()) {
            if (!player.func_184812_l_() && ConfigHandler.GAIA_DISARM) {
                this.disarm(player);
            }
            if (!(player.field_70181_x > 0.0)) continue;
            player.field_70181_x = -player.field_70181_x;
        }
        if (this.cd > 0 && this.getRankII()) {
            --this.cd;
        }
        if (this.cd == 250 && this.skillType == 1) {
            for (EntityPlayer player : this.getPlayersAround()) {
                if (!this.field_70170_p.field_72995_K) continue;
                player.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaPreparing", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
            }
        }
        if (this.cd == 100 && this.skillType == 1) {
            for (EntityPlayer player : this.getPlayersAround()) {
                if (!this.field_70170_p.field_72995_K) continue;
                player.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (this.cd == 100 && this.skillType == 0) {
            for (EntityPlayer player : this.getPlayersAround()) {
                if (!this.field_70170_p.field_72995_K) continue;
                player.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning2", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (this.cd == 0 && this.skillType == 0 && !this.getPlayersAround().isEmpty()) {
            EntityPlayer player = this.getPlayersAround().get(this.field_70170_p.field_73012_v.nextInt(this.getPlayersAround().size()));
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning3", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            if (!player.func_184614_ca().func_190926_b()) {
                player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), 120);
            }
            ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)this, (EntityLivingBase)player, player.func_110138_aP() * 0.2f + 6.0f);
            this.spawnSubspaceLance(player.func_180425_c());
            this.cd = 270;
            int n3 = this.skillType = this.getRankIII() ? 1 : this.field_70170_p.field_73012_v.nextInt(2);
        }
        if (this.cd == 0 && !this.field_70170_p.field_72995_K && this.skillType == 2) {
            if (ConfigHandler.GAIA_DIVINEJUDGE) {
                this.spawnDivineJudge();
            } else {
                this.spawnSubspaceLanceRandomly();
            }
            this.cd = 290;
            int n4 = this.skillType = this.getRankIII() ? 3 : 0;
        }
        if (this.cd == 0 && !this.field_70170_p.field_72995_K && this.skillType == 3) {
            this.spawnSubspaceLanceRandomly();
            this.cd = 180;
            this.skillType = this.field_70170_p.field_73012_v.nextInt(1);
        }
        if (this.tpDelay > 0) {
            --this.tpDelay;
        }
        if (this.tpDelay == 0 && this.func_110143_aJ() > 0.0f) {
            this.teleportRandomly();
            int n5 = this.tpDelay = this.getRankIII() ? 75 : 90;
        }
        if (this.dodgecd > 0) {
            --this.dodgecd;
        }
    }

    private void support(EntityPlayer player) {
        if (!this.contributorlist.isEmpty()) {
            int index = this.field_70170_p.field_73012_v.nextInt(this.contributorlist.size());
            String contributor = this.contributorlist.get(index);
            this.supportcd = 400;
            int rand = this.field_70170_p.field_73012_v.nextInt(7);
            int r = 0;
            switch (rand) {
                case 0: {
                    r = this.field_70170_p.field_73012_v.nextInt(2);
                    player.func_70691_i(player.func_110138_aP() * 0.25f);
                    break;
                }
                case 1: {
                    this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 15.0f);
                    break;
                }
                case 2: {
                    this.tpDelay += 200;
                    break;
                }
                case 3: {
                    r = this.field_70170_p.field_73012_v.nextInt(2);
                    this.cd += 120;
                    break;
                }
                case 4: {
                    r = this.field_70170_p.field_73012_v.nextInt(3);
                    this.supportcd = 200;
                    break;
                }
                case 5: {
                    r = this.field_70170_p.field_73012_v.nextInt(2);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 300, 5));
                    break;
                }
                case 6: {
                    r = this.field_70170_p.field_73012_v.nextInt(3);
                    for (int i = 0; i < 2; ++i) {
                        ItemStack stack = new ItemStack(ModItems.candy, 1, r);
                        stack.func_77950_b(this.field_70170_p, (EntityLivingBase)player);
                    }
                    break;
                }
            }
            player.func_145747_a(new TextComponentTranslation("extrabotanymisc.support" + String.valueOf(rand) + String.valueOf(r), new Object[]{contributor}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
            this.contributorlist.remove(index);
        }
    }

    private static boolean check(EntityPlayer player) {
        if (player.func_184812_l_()) {
            return true;
        }
        if (!EntityVoidHerrscher.match(player.func_184614_ca())) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (EntityVoidHerrscher.match(stackAt)) continue;
            return false;
        }
        return true;
    }

    private void disarm(EntityPlayer player) {
        if (!EntityVoidHerrscher.match(player.func_184614_ca())) {
            EntityItem item = player.func_71040_bB(true);
            item.func_174867_a(90);
        }
        if (player.field_71071_by.func_191420_l()) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (EntityVoidHerrscher.match(stackAt)) continue;
            if (!stackAt.func_190926_b()) {
                EntityItem item = player.func_70099_a(stackAt, 0.0f);
                item.func_174867_a(90);
            }
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private static boolean match(ItemStack stack) {
        String m = stack.func_77973_b().getRegistryName().toString();
        return m.indexOf("botania") != -1 || m.indexOf("extrabotany") != -1 || m.indexOf("minecraft") != -1;
    }

    private boolean match(Block block) {
        String m = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        return m.indexOf("botania") != -1 || m.indexOf("extrabotany") != -1 || m.indexOf("minecraft") != -1;
    }

    private void spawnSubspaceLanceRandomly() {
        double newX = (double)this.source.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
        double newY = this.getRankII() ? (double)((float)this.source.func_177956_o() + 2.0f) : (double)this.source.func_177956_o();
        double newZ = (double)this.source.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
        this.spawnSubspaceLance(new BlockPos(newX, newY, newZ));
    }

    private void spawnSubspaceLance(BlockPos pos) {
        EntitySubspaceLance lance = new EntitySubspaceLance(this.field_70170_p, (EntityLivingBase)this);
        lance.setDamage(4);
        lance.setLife(1200);
        lance.setPitch(-90.0f);
        lance.func_70107_b(pos.func_177958_n(), (float)pos.func_177956_o() + 12.0f, pos.func_177952_p());
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)lance);
        }
    }

    private void spawnVoidJudge() {
        this.setInvulTime(120);
        this.func_70634_a(this.getSource().func_177958_n(), (float)this.getSource().func_177956_o() + 2.0f, this.getSource().func_177952_p());
        for (int i = 0; i < 24; ++i) {
            Vector3 look = new Vector3(this.func_70040_Z()).multiply(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(this.field_70177_z + 90.0f);
            if (look.x == 0.0 && look.z == 0.0) {
                look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.normalize().multiply(-2.0);
            int div = i / 8;
            int mod = i % 8;
            Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)this)).add(0.0, 1.6, (double)div * 0.1);
            Random rand = this.field_70170_p.field_73012_v;
            Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
            double rot = (double)mod * Math.PI / 7.0 - 1.5707963267948966;
            Vector3 axis1 = axis.multiply((double)div * 3.5 + 5.0).rotate(rot, look);
            if (axis1.y < 0.0) {
                axis1 = axis1.multiply(1.0, -1.0, 1.0);
            }
            Vector3 end = pl.add(axis1);
            if (this.getPlayersAround().isEmpty()) continue;
            EntitySubspace sub = new EntitySubspace(this.field_70170_p, (EntityLivingBase)this);
            sub.setLiveTicks(120);
            sub.setDelay(15 + this.field_70170_p.field_73012_v.nextInt(12));
            sub.field_70165_t = end.x;
            sub.field_70163_u = end.y - 0.5 + (double)this.field_70170_p.field_73012_v.nextFloat();
            sub.field_70161_v = end.z;
            sub.field_70177_z = this.field_70177_z;
            sub.setRotation(net.minecraft.util.math.MathHelper.func_76142_g((float)(-this.field_70177_z + 180.0f)));
            sub.setInterval(10 + this.field_70170_p.field_73012_v.nextInt(10));
            sub.setSize(3.0f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f);
            sub.setType(2);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)sub);
            }
            if (i != 1) continue;
            sub.func_184185_a(ModSounds.spearsubspace, 1.0f, 1.0f);
        }
    }

    private void spawnDivineJudge() {
        for (int i = 0; i < 8; ++i) {
            float rad = (float)(i * 45) * (float)Math.PI / 180.0f;
            double x = (double)this.getSource().func_177958_n() + 0.5 - Math.cos(rad) * 5.0;
            double y = this.getSource().func_177956_o() + 7;
            double z = (double)this.getSource().func_177952_p() + 0.5 - Math.sin(rad) * 5.0;
            EntitySwordDomain domain = new EntitySwordDomain(this.func_130014_f_());
            EntityDomain d = new EntityDomain(this.func_130014_f_());
            d.func_70107_b(x, y - 0.5, z);
            this.func_130014_f_().func_72838_d((Entity)d);
            if (!this.playersWhoAttacked.isEmpty()) {
                domain.setUUID(this.playersWhoAttacked.get(Math.min(i, Math.max(0, this.playersWhoAttacked.size() - 1))));
            }
            domain.setType(i);
            domain.func_70107_b(x, y, z + 2.0);
            domain.setCount((int)(y - 2.0));
            domain.setSource(this.getSource());
            this.func_130014_f_().func_72838_d((Entity)domain);
        }
    }

    private void spawnMissile(int type) {
        EntitySkullMissile missile = new EntitySkullMissile((EntityLivingBase)this);
        missile.func_70107_b(this.field_70165_t + (Math.random() - 0.05), this.field_70163_u + 1.8 + (Math.random() - 0.05), this.field_70161_v + (Math.random() - 0.05));
        missile.setDamage(this.getHardcore() ? 7.0f : 5.0f);
        if (type > 0) {
            missile.setFire(true);
        }
        if (type > 1) {
            missile.setEffect(true);
            missile.setTrueDamage(this.getHardcore() ? 3.0f : 2.0f);
        }
        if (missile.findTarget()) {
            if (type > 2) {
                int x = this.getSource().func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                int z = this.getSource().func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                missile.func_70107_b(x, this.field_70163_u + 1.8 + (Math.random() - 0.05), z);
            }
            this.func_184185_a(vazkii.botania.common.core.handler.ModSounds.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)missile);
            }
        }
    }

    public static boolean spawn(EntityPlayer player, ItemStack stack, World world, BlockPos pos, boolean hard) {
        if (!(world.func_175625_s(pos) instanceof TileEntityBeacon) || !EntityVoidHerrscher.isTruePlayer((Entity)player) || EntityVoidHerrscher.getGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (!world.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.peacefulNoob", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        List<BlockPos> invalidPylonBlocks = EntityVoidHerrscher.checkPylons(world, pos);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.field_72995_K) {
                EntityVoidHerrscher.warnInvalidBlocks(invalidPylonBlocks);
            } else {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.needsCatalysts", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        List<BlockPos> invalidArenaBlocks = EntityVoidHerrscher.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.field_72995_K) {
                EntityVoidHerrscher.warnInvalidBlocks(invalidArenaBlocks);
            } else {
                PacketHandler.sendTo((EntityPlayerMP)((EntityPlayerMP)player), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ARENA_INDICATOR, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new int[0]));
                player.func_145747_a(new TextComponentTranslation("botaniamisc.badArena", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        if (!EntityVoidHerrscher.check(player)) {
            if (world.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.illegalInventory", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        if (!world.field_72995_K) {
            int playerCount;
            if (stack.func_77973_b() instanceof ItemMaterial) {
                stack.func_190918_g(1);
            }
            EntityVoidHerrscher e = new EntityVoidHerrscher(world);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5);
            e.source = pos;
            e.hardMode = hard;
            e.setHardcore(hard);
            e.setShield(5);
            e.playerCount = playerCount = e.getPlayersAround().size();
            e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(400.0f * (float)playerCount));
            if (hard) {
                e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
            }
            e.func_70606_j(e.func_110138_aP());
            e.func_184185_a(SoundEvents.field_187525_aO, 10.0f, 0.1f);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
        }
        return true;
    }

    private static void warnInvalidBlocks(Iterable<BlockPos> invalidPositions) {
        Botania.proxy.setWispFXDepthTest(false);
        for (BlockPos pos_ : invalidPositions) {
            Botania.proxy.wispFX((double)pos_.func_177958_n() + 0.5, (double)pos_.func_177956_o() + 0.5, (double)pos_.func_177952_p() + 0.5, 1.0f, 0.2f, 0.2f, 0.5f, 0.0f, 8.0f);
        }
        Botania.proxy.setWispFXDepthTest(true);
    }

    private static List<BlockPos> checkPylons(World world, BlockPos beaconPos) {
        ArrayList<BlockPos> invalidPylonBlocks = new ArrayList<BlockPos>();
        for (BlockPos coords : PYLON_LOCATIONS) {
            BlockPos pos_ = beaconPos.func_177971_a((Vec3i)coords);
            IBlockState state = world.func_180495_p(pos_);
            if (state.func_177230_c() == ModBlocks.pylon && state.func_177229_b((IProperty)BotaniaStateProps.PYLON_VARIANT) == PylonVariant.GAIA) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }

    private static List<BlockPos> checkArena(World world, BlockPos beaconPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(15.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane((double)x, (double)z, (double)0.0, (double)0.0) > 15.0f) continue;
                for (int y = -1; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = beaconPos.func_177982_a(x, y, z);
                    boolean expectedBlockHere = y == -1;
                    boolean bl = isBlockHere = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) != null;
                    if (expectedBlockHere == isBlockHere) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 22.5f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVUL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(RANKII, (Object)false);
        this.field_70180_af.func_187214_a(RANKIII, (Object)false);
        this.field_70180_af.func_187214_a(HARDCORE, (Object)false);
        this.field_70180_af.func_187214_a(SHIELD, (Object)0);
        this.field_70180_af.func_187214_a(SHIELDS, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    public int getShields() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELDS);
    }

    public void setShields(int s) {
        this.field_70180_af.func_187227_b(SHIELDS, (Object)s);
    }

    public boolean getHardcore() {
        return (Boolean)this.field_70180_af.func_187225_a(HARDCORE);
    }

    public void setHardcore(boolean b) {
        this.field_70180_af.func_187227_b(HARDCORE, (Object)b);
    }

    public boolean getRankII() {
        return (Boolean)this.field_70180_af.func_187225_a(RANKII);
    }

    public boolean getRankIII() {
        return (Boolean)this.field_70180_af.func_187225_a(RANKIII);
    }

    public void setRankII(boolean b) {
        this.field_70180_af.func_187227_b(RANKII, (Object)b);
    }

    public void setRankIII(boolean b) {
        this.field_70180_af.func_187227_b(RANKIII, (Object)b);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVUL_TIME);
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setDamageTaken(float time) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(time));
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVUL_TIME, (Object)time);
    }

    public void func_70014_b(NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_INVUL_TIME, this.getInvulTime());
        cmp.func_74757_a(TAG_AGGRO, this.aggro);
        cmp.func_74768_a(TAG_SOURCE_X, this.source.func_177958_n());
        cmp.func_74768_a(TAG_SOURCE_Y, this.source.func_177956_o());
        cmp.func_74768_a(TAG_SOURCE_Z, this.source.func_177952_p());
        cmp.func_74768_a(TAG_PLAYER_COUNT, this.playerCount);
        cmp.func_74768_a(TAG_SHIELD, this.getShield());
        cmp.func_74757_a(TAG_RANKII, this.getRankII());
        cmp.func_74757_a(TAG_RANKIII, this.getRankIII());
        cmp.func_74768_a(TAG_SHIELDS, this.getShields());
        cmp.func_74776_a(TAG_DAMAGETAKEN, this.getDamageTaken());
    }

    public void func_70037_a(NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setInvulTime(cmp.func_74762_e(TAG_INVUL_TIME));
        this.aggro = cmp.func_74767_n(TAG_AGGRO);
        int x = cmp.func_74762_e(TAG_SOURCE_X);
        int y = cmp.func_74762_e(TAG_SOURCE_Y);
        int z = cmp.func_74762_e(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.playerCount = cmp.func_74764_b(TAG_PLAYER_COUNT) ? cmp.func_74762_e(TAG_PLAYER_COUNT) : 1;
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        this.setShields(cmp.func_74762_e(TAG_SHIELDS));
        this.setDamageTaken(cmp.func_74760_g(TAG_DAMAGETAKEN));
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float par2) {
        Entity e = source.func_76346_g();
        ArrayList<DamageSource> sourcelist = new ArrayList<DamageSource>();
        sourcelist.add(DamageSource.field_82728_o);
        sourcelist.add(DamageSource.field_76367_g);
        sourcelist.add(DamageSource.field_76369_e);
        sourcelist.add(DamageSource.field_76379_h);
        sourcelist.add(DamageSource.field_82729_p);
        sourcelist.add(DamageSource.field_76372_a);
        sourcelist.add(DamageSource.field_76371_c);
        sourcelist.add(DamageSource.field_76370_b);
        sourcelist.add(DamageSource.field_180137_b);
        sourcelist.add(DamageSource.field_76376_m);
        sourcelist.add(DamageSource.field_76380_i);
        sourcelist.add(DamageSource.field_82727_n);
        if (sourcelist.contains(source) || this.getInvulTime() > 0) {
            return false;
        }
        if (e instanceof EntityPlayer && EntityVoidHerrscher.isTruePlayer(e)) {
            EntityPlayer player = (EntityPlayer)e;
            if (!this.playersWhoAttacked.contains(player.func_110124_au())) {
                this.playersWhoAttacked.add(player.func_110124_au());
            }
            if (MathHelper.pointDistancePlane((double)player.field_70165_t, (double)player.field_70161_v, (double)this.getSource().func_177958_n(), (double)this.getSource().func_177952_p()) > 15.0f) {
                player.func_184595_k((double)this.getSource().func_177958_n(), (double)this.getSource().func_177956_o(), (double)this.getSource().func_177952_p());
            }
            int cap = 25;
            this.setInvulTime(this.getInvulTime() + 10);
            if (this.cd > 80) {
                this.cd -= 15;
            }
            if (this.dodgecd == 0) {
                EntityVoid vo = new EntityVoid((EntityLivingBase)this);
                vo.func_70107_b(player.field_70165_t, player.field_70163_u + (double)0.7f, player.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)vo);
                this.dodgecd = 300;
                if (Math.random() < (double)0.2f) {
                    this.spawnSubspaceLance(player.func_180425_c());
                }
                return false;
            }
            if (this.getShields() > 0) {
                for (PotionEffect pe : player.func_70651_bq()) {
                    this.func_70690_d(pe);
                }
                for (int i = 0; i < this.getShields(); ++i) {
                    par2 *= 0.85f;
                    cap = (int)((float)cap * 0.85f);
                }
                if (par2 > 20.0f && !this.field_70170_p.field_72995_K) {
                    this.setShields(this.getShields() - 1);
                    this.dodgecd = 0;
                }
            }
            this.setDamageTaken(this.getDamageTaken() + Math.min((float)cap, par2));
            if (this.getDamageTaken() >= 80.0f) {
                this.setDamageTaken(0.0f);
                this.teleportRandomly();
                this.tpDelay = 65;
                ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)this, (EntityLivingBase)player, player.func_110138_aP() * 0.1f + 6.0f);
            }
            return super.func_70097_a(source, Math.min((float)cap, par2));
        }
        return false;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void func_70665_d(@Nonnull DamageSource par1DamageSource, float par2) {
        super.func_70665_d(par1DamageSource, par2);
        Entity attacker = par1DamageSource.func_76364_f();
        if (attacker != null) {
            Vector3 thisVector = Vector3.fromEntityCenter((Entity)this);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)attacker);
            Vector3 motionVector = thisVector.subtract(playerVector).normalize().multiply(0.2);
            if (this.func_110143_aJ() > 0.0f) {
                this.field_70159_w = -motionVector.x;
                this.field_70181_x = 0.25;
                this.field_70179_y = -motionVector.z;
                this.tpDelay = Math.max(this.tpDelay - 4, 0);
            }
        }
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        super.func_70645_a(source);
        this.func_184185_a(SoundEvents.field_187539_bB, 20.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("extrabotany", "void_herrscher");
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        if ("player".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            this.trueKiller = (EntityPlayer)source.func_76346_g();
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
            this.func_184201_a(e, ItemStack.field_190927_a);
        }
        for (UUID u : this.playersWhoAttacked) {
            EntityPlayer player = this.field_70170_p.func_152378_a(u);
            if (player == null) continue;
            EntityPlayer saveLastAttacker = this.field_70717_bb;
            double savePosX = this.field_70165_t;
            double savePosY = this.field_70163_u;
            double savePosZ = this.field_70161_v;
            this.field_70717_bb = player;
            this.field_70165_t = player.field_70165_t;
            this.field_70163_u = player.field_70163_u;
            this.field_70161_v = player.field_70161_v;
            super.func_184610_a(wasRecentlyHit, lootingModifier, DamageSource.func_76365_a((EntityPlayer)player));
            ExtraBotanyAPI.unlockAdvancement(player, "herrscherDefeat");
            if (this.quickkill) {
                ExtraBotanyAPI.unlockAdvancement(player, "endgameGoal");
            }
            this.field_70165_t = savePosX;
            this.field_70163_u = savePosY;
            this.field_70161_v = savePosZ;
            this.field_70717_bb = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            Botania.proxy.removeBoss((IBotaniaBoss)this);
        }
        this.field_70170_p.func_175718_b(1010, this.getSource(), 0);
        super.func_70106_y();
    }

    public List<EntityPlayer> getPlayersAround() {
        BlockPos source = this.getSource();
        float range = 16.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)(range * 2.0f), (double)source.func_177952_p() + 0.5 + (double)range));
    }

    private static int getGaiaGuardiansAround(World world, BlockPos source) {
        float range = 16.0f;
        List l = world.func_72872_a(EntityVoidHerrscher.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
        return l.size();
    }

    private void particles() {
        BlockPos source = this.getSource();
        for (int i = 0; i < 360; i += 12) {
            float r = 0.3f;
            float g = 0.0f;
            float b = 1.0f;
            float m = 0.15f;
            float mv = 0.35f;
            float rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)source.func_177958_n() + 0.5 - Math.cos(rad) * 15.0;
            double y = (double)source.func_177956_o() + 0.5;
            double z = (double)source.func_177952_p() + 0.5 - Math.sin(rad) * 15.0;
            if (this.field_70173_aa % 2 != 0) continue;
            Botania.proxy.wispFX(x, y, z, r, g, b, 0.5f, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * mv, (float)(Math.random() - 0.5) * m);
        }
        if (this.getInvulTime() > 10) {
            Vector3 pos = Vector3.fromEntityCenter((Entity)this).subtract(new Vector3(0.0, 0.2, 0.0));
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vector3 pylonPos = new Vector3((double)(source.func_177958_n() + arr.func_177958_n()), (double)(source.func_177956_o() + arr.func_177956_o()), (double)(source.func_177952_p() + arr.func_177952_p()));
                double worldTime = this.field_70173_aa;
                float rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vector3 partPos = new Vector3(xp, pylonPos.y, zp);
                Vector3 mot = pos.subtract(partPos).multiply(0.04);
                float r = 0.0f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.25f + (float)Math.random() * 0.1f, -0.075f - (float)Math.random() * 0.015f);
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.4f, (float)mot.x, (float)mot.y, (float)mot.z);
            }
        }
    }

    private void smashCheatyBlocks() {
        int radius = 10;
        int posXInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177958_n());
        int posYInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177956_o());
        int posZInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177952_p());
        for (int i = -radius; i < radius + 1; ++i) {
            for (int j = -radius; j < radius + 1; ++j) {
                for (int k = -radius; k < radius + 1; ++k) {
                    int xp = posXInt + i;
                    int yp = posYInt + j;
                    int zp = posZInt + k;
                    BlockPos posp = new BlockPos(xp, yp, zp);
                    if (!EntityVoidHerrscher.isCheatyBlock(this.field_70170_p, posp) && (!ConfigHandler.GAIA_SMASH || this.match(this.field_70170_p.func_180495_p(posp).func_177230_c()))) continue;
                    this.field_70170_p.func_175655_b(posp, true);
                }
            }
        }
    }

    private void clearPotions(EntityPlayer player) {
        int posXInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70165_t);
        int posZInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70161_v);
        List<Potion> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_76459_b() < 160 && effect.func_82720_e() && !effect.func_188419_a().func_76398_f()).map(PotionEffect::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_184589_d(potion);
            ((WorldServer)this.field_70170_p).func_184164_w().func_187301_b(posXInt >> 4, posZInt >> 4).func_187267_a((Packet)new SPacketRemoveEntityEffect(player.func_145782_y(), potion));
        });
    }

    private void keepInsideArena(EntityPlayer player) {
        BlockPos source = this.getSource();
        if (MathHelper.pointDistanceSpace((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)((double)source.func_177958_n() + 0.5), (double)((double)source.func_177956_o() + 0.5), (double)((double)source.func_177952_p() + 0.5)) >= 15.0f) {
            Vector3 sourceVector = new Vector3((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)player);
            Vector3 motion = sourceVector.subtract(playerVector).normalize();
            player.field_70159_w = motion.x;
            player.field_70181_x = 0.2;
            player.field_70179_y = motion.z;
            player.field_70133_I = true;
            if (player.func_184218_aH()) {
                Entity rideon = player.func_184187_bx();
                rideon.field_70159_w = motion.x;
                rideon.field_70181_x = 0.2;
                rideon.field_70179_y = motion.z;
                rideon.field_70133_I = true;
            }
            player.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 400, 4));
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_85033_bc() {
        if (this.getInvulTime() == 0) {
            super.func_85033_bc();
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.getInvulTime() == 0;
    }

    private static boolean isCheatyBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return CHEATY_BLOCKS.contains(Block.field_149771_c.func_177774_c((Object)block));
    }

    private void teleportRandomly() {
        double newZ;
        double newY;
        double newX;
        if (this.getInvulTime() > 10) {
            return;
        }
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        int tries = 0;
        do {
            newX = (double)this.source.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
            newY = this.getRankII() ? (double)((float)this.source.func_177956_o() + 2.0f) : (double)this.source.func_177956_o();
            newZ = (double)this.source.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 15.0;
        } while (++tries < 50 && MathHelper.pointDistanceSpace((double)newX, (double)newY, (double)newZ, (double)this.source.func_177958_n(), (double)this.source.func_177956_o(), (double)this.source.func_177952_p()) > 12.0f);
        if (tries == 50) {
            newX = (float)this.source.func_177958_n() + 0.5f;
            newY = this.source.func_177956_o() + 2;
            newZ = (float)this.source.func_177952_p() + 0.5f;
        }
        this.func_70634_a(newX, newY, newZ);
        this.field_70170_p.func_184148_a(null, oldX, oldY, oldZ, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        Random random = this.func_70681_au();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.nextFloat() - 0.5f) * 0.2f;
            float vy = (random.nextFloat() - 0.5f) * 0.2f;
            float vz = (random.nextFloat() - 0.5f) * 0.2f;
            double px = oldX + (newX - oldX) * progress + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double py = oldY + (newY - oldY) * progress + random.nextDouble() * (double)this.field_70131_O;
            double pz = oldZ + (newZ - oldZ) * progress + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, px, py, pz, (double)vx, (double)vy, (double)vz, new int[0]);
        }
        Vec3d oldPosVec = new Vec3d(oldX, oldY + (double)(this.field_70131_O / 2.0f), oldZ);
        Vec3d newPosVec = new Vec3d(newX, newY + (double)(this.field_70131_O / 2.0f), newZ);
        if (oldPosVec.func_72436_e(newPosVec) > 1.0) {
            for (EntityPlayer player : this.getPlayersAround()) {
                RayTraceResult rtr = player.func_174813_aQ().func_186662_g(0.25).func_72327_a(oldPosVec, newPosVec);
                if (rtr == null) continue;
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 6.0f);
            }
            int breakSteps = (int)oldPosVec.func_72438_d(newPosVec);
            if (breakSteps >= 2) {
                for (int i = 0; i < breakSteps; ++i) {
                    float progress = (float)i / (float)(breakSteps - 1);
                    int breakX = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldX + (newX - oldX) * (double)progress));
                    int breakY = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldY + (newY - oldY) * (double)progress));
                    int breakZ = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldZ + (newZ - oldZ) * (double)progress));
                    this.smashBlocksAround(breakX, breakY, breakZ, 1);
                }
            }
        }
    }

    private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (state.func_185887_b(this.field_70170_p, pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(block.getRegistryName())) {
                        this.field_70170_p.func_175655_b(pos, true);
                        continue;
                    }
                    if (ExtraBotanyAPI.gaiaBreakBlacklist.contains(block) || y == this.source.func_177956_o() - 1 || Math.abs(this.source.func_177958_n() - x) == 4 && Math.abs(this.source.func_177952_p() - z) == 4) continue;
                    this.field_70170_p.func_175655_b(pos, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarTextureRect() {
        if (barRect == null) {
            barRect = new Rectangle(0, 0, 185, 15);
        }
        return barRect;
    }

    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarHPTextureRect() {
        if (hpBarRect == null) {
            hpBarRect = new Rectangle(0, EntityVoidHerrscher.barRect.y + EntityVoidHerrscher.barRect.height, 181, 7);
        }
        return hpBarRect;
    }

    @SideOnly(value=Side.CLIENT)
    public int bossBarRenderCallback(ScaledResolution res, int x, int y) {
        GlStateManager.func_179094_E();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_175042_a(stack, px, py);
        RenderHelper.func_74518_a();
        boolean unicode = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(true);
        mc.field_71466_p.func_175063_a("" + this.playerCount, (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        mc.field_71466_p.func_78264_a(unicode);
        GlStateManager.func_179121_F();
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBossBarShaderProgram(boolean background) {
        return background ? 0 : ShaderHelper.dopplegangerBar;
    }

    @SideOnly(value=Side.CLIENT)
    public ShaderCallback getBossBarShaderCallback(boolean background, int shader) {
        if (this.shaderCallback == null) {
            this.shaderCallback = shader1 -> {
                int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"grainIntensity");
                int hpFractUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"hpFract");
                float time = this.getInvulTime();
                float grainIntensity = time > 20.0f ? 1.0f : Math.max(0.0f, time / 20.0f);
                ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)grainIntensity);
                ARBShaderObjects.glUniform1fARB((int)hpFractUniform, (float)(this.func_110143_aJ() / this.func_110138_aP()));
            };
        }
        return background ? null : this.shaderCallback;
    }

    @Override
    public int getShield() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD);
    }

    @Override
    public void setShield(int shield) {
        this.field_70180_af.func_187227_b(SHIELD, (Object)shield);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.playerCount);
        buffer.writeBoolean(this.hardMode);
        buffer.writeLong(this.source.func_177986_g());
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf additionalData) {
        this.playerCount = additionalData.readInt();
        this.hardMode = additionalData.readBoolean();
        this.source = BlockPos.func_177969_a((long)additionalData.readLong());
        long msb = additionalData.readLong();
        long lsb = additionalData.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DopplegangerMusic(this));
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    @SideOnly(value=Side.CLIENT)
    private static class DopplegangerMusic
    extends MovingSound {
        private final EntityVoidHerrscher guardian;

        public DopplegangerMusic(EntityVoidHerrscher guardian) {
            super(ModSounds.herrscherMusic, SoundCategory.RECORDS);
            this.guardian = guardian;
            this.field_147660_d = guardian.getSource().func_177958_n();
            this.field_147661_e = guardian.getSource().func_177956_o();
            this.field_147658_f = guardian.getSource().func_177952_p();
            this.field_147659_g = true;
        }

        public void func_73660_a() {
            if (!this.guardian.func_70089_S()) {
                this.field_147668_j = true;
            }
        }
    }
}

