/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import com.meteor.extrabotany.common.item.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.botania.common.Botania;

public class EntityPhantomSword
extends EntityThrowableCopy {
    private static final String TAG_VARIETY = "variety";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_PITCH = "pitch";
    private static final String TAG_TARGETPOS = "targetpos";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_FAKE = "fake";
    private static final DataParameter<Integer> VARIETY = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DELAY = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<BlockPos> TARGET_POS = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> FAKE = EntityDataManager.func_187226_a(EntityPhantomSword.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final float[][] rgb = new float[][]{{0.82f, 0.2f, 0.58f}, {0.0f, 0.71f, 0.1f}, {0.74f, 0.07f, 0.32f}, {0.01f, 0.45f, 0.8f}, {0.05f, 0.39f, 0.9f}, {0.38f, 0.34f, 0.42f}, {0.41f, 0.31f, 0.14f}, {0.92f, 0.92f, 0.21f}, {0.61f, 0.92f, 0.98f}, {0.18f, 0.45f, 0.43f}};
    private EntityLivingBase thrower;

    public EntityPhantomSword(World worldIn) {
        super(worldIn);
    }

    public EntityPhantomSword(World world, EntityLivingBase thrower, BlockPos targetpos) {
        super(world, thrower);
        this.thrower = thrower;
        this.setTargetPos(targetpos);
        this.setVariety((int)(10.0 * Math.random()));
        double range = 13.0;
        double k = 1.8849556670552816 * Math.random();
        double j = -Math.PI + Math.PI * 2 * Math.random();
        double x = (double)targetpos.func_177958_n() + range * Math.sin(k) * Math.cos(j);
        double y = (double)targetpos.func_177956_o() + range * Math.cos(k);
        double z = (double)targetpos.func_177952_p() + range * Math.sin(k) * Math.sin(j);
        this.func_70107_b(x, y, z);
        this.faceEntity(targetpos);
        Vec3d vec = new Vec3d((double)this.getTargetPos().func_177958_n() - this.field_70165_t, (double)this.getTargetPos().func_177956_o() - this.field_70163_u, (double)this.getTargetPos().func_177952_p() - this.field_70161_v).func_72432_b();
        this.field_70159_w = vec.field_72450_a * (double)1.05f;
        this.field_70181_x = vec.field_72448_b * (double)1.05f;
        this.field_70179_y = vec.field_72449_c * (double)1.05f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(VARIETY, (Object)0);
        this.field_70180_af.func_187214_a(DELAY, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TARGET_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(FAKE, (Object)false);
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        if (this.getDelay() > 0) {
            this.setDelay(this.getDelay() - 1);
            return;
        }
        EntityLivingBase thrower = this.getThrower();
        if (this.field_70173_aa >= 26) {
            this.func_70106_y();
        }
        if (this.getFake()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        if (!(this.getFake() || this.field_70170_p.field_72995_K || thrower != null && thrower instanceof EntityPlayer && !thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        EntityPlayer player = (EntityPlayer)thrower;
        Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, rgb[this.getVariety()][0], rgb[this.getVariety()][1], rgb[this.getVariety()][2], 0.25f, 0.0f);
        if (!this.field_70170_p.field_72995_K && !this.getFake() && this.field_70173_aa % 6 == 0) {
            EntityPhantomSword illusion = new EntityPhantomSword(this.field_70170_p);
            illusion.thrower = this.thrower;
            illusion.setFake(true);
            illusion.setRotation(this.getRotation());
            illusion.setPitch(this.getPitch());
            illusion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            illusion.setVariety(this.getVariety());
            this.field_70170_p.func_72838_d((Entity)illusion);
        }
        if (!this.field_70170_p.field_72995_K) {
            double speed = player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            float dmg = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == ModItems.firstfractal ? (float)(player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * Math.min(1.0 + speed, 2.0)) : 10.0f;
            float pP = 0.65f;
            float mP = 0.3f;
            float tP = Math.max(0.0f, 1.0f - pP - mP);
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70142_S, this.field_70137_T, this.field_70136_U).func_186662_g(2.0);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase living : entities) {
                if (living == thrower || living instanceof EntityAnimal || living.field_70172_ad > 5) continue;
                ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)player, living, dmg * tP);
                living.func_70097_a(DamageSource.field_76376_m, dmg * mP);
                EntityPhantomSword.attackedFrom(living, player, dmg * pP);
            }
        }
    }

    public static void attackedFrom(EntityLivingBase target, EntityPlayer player, float i) {
        if (player != null) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), i);
        } else {
            target.func_70097_a(DamageSource.field_76377_j, i);
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    public void faceEntity(BlockPos target) {
        double d0 = (double)target.func_177958_n() - this.field_70165_t;
        double d2 = (double)target.func_177952_p() - this.field_70161_v;
        double d1 = (double)target.func_177956_o() - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f1, 360.0f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, f, 360.0f);
        this.setPitch(-this.field_70125_A);
        this.setRotation(MathHelper.func_76142_g((float)(-this.field_70177_z + 180.0f)));
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_VARIETY, this.getVariety());
        cmp.func_74768_a(TAG_DELAY, this.getDelay());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
        cmp.func_74776_a(TAG_PITCH, this.getPitch());
        cmp.func_74772_a(TAG_TARGETPOS, this.getTargetPos().func_177986_g());
        cmp.func_74757_a(TAG_FAKE, this.getFake());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setVariety(cmp.func_74762_e(TAG_VARIETY));
        this.setDelay(cmp.func_74762_e(TAG_DELAY));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
        this.setPitch(cmp.func_74760_g(TAG_PITCH));
        this.setTargetPos(BlockPos.func_177969_a((long)cmp.func_74763_f(TAG_TARGETPOS)));
        this.setFake(cmp.func_74767_n(TAG_FAKE));
    }

    public int getVariety() {
        return (Integer)this.field_70180_af.func_187225_a(VARIETY);
    }

    public void setVariety(int var) {
        this.field_70180_af.func_187227_b(VARIETY, (Object)var);
    }

    public int getDelay() {
        return (Integer)this.field_70180_af.func_187225_a(DELAY);
    }

    public void setDelay(int var) {
        this.field_70180_af.func_187227_b(DELAY, (Object)var);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    public float getPitch() {
        return ((Float)this.field_70180_af.func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float rot) {
        this.field_70180_af.func_187227_b(PITCH, (Object)Float.valueOf(rot));
    }

    public boolean getFake() {
        return (Boolean)this.field_70180_af.func_187225_a(FAKE);
    }

    public void setFake(boolean rot) {
        this.field_70180_af.func_187227_b(FAKE, (Object)rot);
    }

    public BlockPos getTargetPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(TARGET_POS);
    }

    public void setTargetPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(TARGET_POS, (Object)pos);
    }
}

