/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity;

import com.google.common.collect.Lists;
import com.meteor.extrabotany.common.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.ManaItemHandler;

public class EntityFlyingBoat
extends Entity {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> RAFT_DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> RAFT_TYPE = EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean>[] DATA_ID_PADDLE = new DataParameter[]{EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187198_h), EntityDataManager.func_187226_a(EntityFlyingBoat.class, (DataSerializer)DataSerializers.field_187198_h)};
    private final float[] paddlePositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double raftPitch;
    private double lerpY;
    private double lerpZ;
    private double raftYaw;
    private double lerpXRot;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private boolean upInputDown;
    private double waterLevel;
    private int driveticks;
    private float raftGlide;
    private Status status;
    private Status previousStatus;
    private double lastYd;

    public EntityFlyingBoat(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.375f, 0.5625f);
    }

    public EntityFlyingBoat(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(RAFT_DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(RAFT_TYPE, (Object)Type.MANASTEEL.ordinal());
        for (DataParameter<Boolean> dataparameter : DATA_ID_PADDLE) {
            this.field_70180_af.func_187214_a(dataparameter, (Object)false);
        }
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.025;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_70099_a(this.getItemBoat(this.getRaftType().getMetadata()), 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityFlyingBoat) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public ItemStack getItemBoat(int meta) {
        return new ItemStack(ModItems.flyingboat, 1, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.raftPitch = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.raftYaw = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        EntityPlayer player;
        int maxheight;
        boolean isAdvanced;
        this.previousStatus = this.status;
        this.status = this.getRaftStatus();
        this.field_70169_q = this.field_70165_t;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        this.field_70181_x = 0.0;
        int height = 0;
        for (int y = 0; y < 255; ++y) {
            ++height;
            if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -y, 0)).func_177230_c() != Blocks.field_150350_a) break;
        }
        boolean isTerrasteel = this.getRaftType() == Type.TERRASTEEL;
        boolean bl = isAdvanced = this.getRaftType() == Type.ELEMENTIUM;
        int n = isTerrasteel ? 255 : (maxheight = isAdvanced ? 64 : 32);
        if (this.upInputDown && height <= maxheight) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)0.35f, this.field_70161_v);
        } else if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150350_a) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u - (double)0.15f, this.field_70161_v);
        }
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayer && !ManaItemHandler.requestManaExact((ItemStack)new ItemStack(Items.field_151034_e), (EntityPlayer)(player = (EntityPlayer)this.func_184188_bt().get(0)), (int)1, (boolean)true)) {
            this.func_184226_ay();
        }
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                this.setPaddleState(false, false);
            }
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlRaft();
                this.field_70170_p.func_184135_a((Packet)new CPacketSteerBoat(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981633974483 && ((double)this.paddlePositions[i] + (double)0.3926991f) % (Math.PI * 2) >= 0.7853981633974483 && (soundevent = this.getPaddleSound()) != null) {
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vec3d.field_72449_c : vec3d.field_72449_c;
                    double d1 = i == 1 ? vec3d.field_72450_a : -vec3d.field_72450_a;
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t + d0, this.field_70163_u, this.field_70161_v + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getRaftStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.raftPitch - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.raftYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[0], (Object)left);
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[1], (Object)right);
    }

    @SideOnly(value=Side.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    private Status getRaftStatus() {
        Status EntityFlyingBoat$status = this.getUnderwaterStatus();
        if (EntityFlyingBoat$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return EntityFlyingBoat$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getRaftGlide();
        if (f > 0.0f) {
            this.raftGlide = f;
            return Status.IN_WATER;
        }
        return Status.IN_WATER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            float f1;
            block4: for (int k1 = k; k1 < l; ++k1) {
                float f = 0.0f;
                int l1 = i;
                while (true) {
                    if (l1 >= j) {
                        float f2;
                        if (!(f < 1.0f)) continue block4;
                        float f3 = f2 = (float)blockpos$pooledmutableblockpos.func_177956_o() + f;
                        return f3;
                    }
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() == Material.field_151586_h) {
                            f = Math.max(f, BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos));
                        }
                        if (f >= 1.0f) continue block4;
                    }
                    ++l1;
                }
            }
            float f = f1 = (float)(l + 1);
            return f;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRaftGlide() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        ArrayList list = Lists.newArrayList();
        float f = 0.0f;
        int k1 = 0;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                    if (j2 == 2) continue;
                    for (int k2 = k; k2 < l; ++k2) {
                        if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                        blockpos$pooledmutableblockpos.func_181079_c(l1, k2, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        iblockstate.func_185908_a(this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, axisalignedbb1, (List)list, (Entity)this, false);
                        if (!list.isEmpty()) {
                            f += iblockstate.func_177230_c().field_149765_K;
                            ++k1;
                        }
                        list.clear();
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return f / (float)k1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
                        float f = BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        if (iblockstate.func_185904_a() != Material.field_151586_h || !(d0 < (double)BlockLiquid.func_190972_g((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos))) continue;
                        if ((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                            Status EntityFlyingBoat$status;
                            Status status = EntityFlyingBoat$status = Status.UNDER_FLOWING_WATER;
                            return status;
                        }
                        flag = true;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.field_70131_O;
            this.func_70107_b(this.field_70165_t, (double)(this.getWaterLevelAbove() - this.field_70131_O) + 0.101, this.field_70161_v);
            this.field_70181_x = 0.0;
            this.lastYd = 0.0;
            this.status = Status.IN_WATER;
        } else {
            if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.field_70131_O;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.momentum = this.raftGlide;
                if (this.func_184179_bs() instanceof EntityPlayer) {
                    this.raftGlide /= 2.0f;
                }
            }
            this.field_70159_w *= (double)this.momentum;
            this.field_70179_y *= (double)this.momentum;
            this.deltaRotation *= this.momentum;
            this.field_70181_x += d1;
            if (d2 > 0.0) {
                double d3 = 0.65;
                this.field_70181_x += d2 * 0.06153846016296973;
                double d4 = 0.75;
                this.field_70181_x *= 0.75;
            }
        }
    }

    private void controlRaft() {
        if (this.func_184207_aI()) {
            boolean isAdvanced;
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation += -1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            boolean isTerrasteel = this.getRaftType() == Type.TERRASTEEL;
            boolean bl = isAdvanced = this.getRaftType() == Type.ELEMENTIUM;
            if (this.forwardInputDown) {
                f += 0.0625f * (isTerrasteel ? 1.6f : 1.0f) * (isAdvanced ? 1.3f : 1.0f);
            }
            if (this.backInputDown) {
                f -= 0.0072500003f * (isTerrasteel ? 2.5f : 1.0f) * (isAdvanced ? 1.75f : 1.0f);
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Type", this.getRaftType().getName());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setRaftType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks < 60.0f) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.lastYd = this.field_70181_x;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, this.getRaftType().getMetadata()), 0.0f);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_145778_a(Items.field_151055_y, 1, 0.0f);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_185904_a() != Material.field_151586_h && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ID_PADDLE[side]) != false && this.func_184179_bs() != null;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(RAFT_DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(RAFT_DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    public void setRaftType(Type raftType) {
        this.field_70180_af.func_187227_b(RAFT_TYPE, (Object)raftType.ordinal());
    }

    public Type getRaftType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(RAFT_TYPE));
    }

    public EntityBoat.Type getBoatType() {
        return null;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateInputs(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_, boolean up) {
        this.leftInputDown = p_184442_1_;
        this.rightInputDown = p_184442_2_;
        this.forwardInputDown = p_184442_3_;
        this.backInputDown = p_184442_4_;
        this.upInputDown = up;
    }

    public static enum Type {
        MANASTEEL(0, "manasteel"),
        ELEMENTIUM(1, "elementium"),
        TERRASTEEL(2, "terrasteel");

        private final String name;
        private final int metadata;

        private Type(int metadataIn, String nameIn) {
            this.name = nameIn;
            this.metadata = metadataIn;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            if (id < 0 || id >= Type.values().length) {
                id = 0;
            }
            return Type.values()[id];
        }

        public static Type getTypeFromString(String nameIn) {
            for (int i = 0; i < Type.values().length; ++i) {
                if (!Type.values()[i].getName().equals(nameIn)) continue;
                return Type.values()[i];
            }
            return Type.values()[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

