/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import com.meteor.extrabotany.common.block.tile.TileInventoryBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.common.Botania;

public class TileChargePad
extends TileInventoryBase
implements ITickable {
    private boolean isDirty;
    private int rot;

    public TileChargePad() {
        super(1, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.rot = nbttagcompound.func_74762_e("Rot");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Rot", this.rot);
        return nbttagcompound;
    }

    public int getRotation() {
        return this.rot;
    }

    public void func_73660_a() {
        if (this.isDirty) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.isDirty = false;
        }
        if (this.rot == 360) {
            this.rot = 0;
        }
        if (!this.getItem().func_190926_b()) {
            ++this.rot;
        }
        int redstoneSignal = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.func_145831_w().func_175651_c(this.func_174877_v().func_177972_a(dir), dir);
            redstoneSignal = Math.max(redstoneSignal, redstoneSide);
        }
        boolean working = false;
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(0, 1, 0));
        if (te instanceof IManaPool) {
            int manaToCharge;
            IManaPool pool = (IManaPool)te;
            if (!(this.getItem().func_77973_b() instanceof IManaItem)) {
                return;
            }
            IManaItem item = (IManaItem)this.getItem().func_77973_b();
            int manaToUse = Math.min(1000, pool.getCurrentMana());
            int mana = Math.min(manaToUse, manaToCharge = item.getMaxMana(this.getItem()) - item.getMana(this.getItem()));
            if (mana > 0 && redstoneSignal == 0) {
                if (!this.func_145831_w().field_72995_K) {
                    item.addMana(this.getItem(), mana);
                    pool.recieveMana(-mana);
                    this.func_70296_d();
                }
                Botania.proxy.sparkleFX((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.0f, 0.8f, 1.0f, 0.5f, 4);
            }
            int manaToSpend = Math.min(1000, item.getMana(this.getItem()));
            if (!pool.isFull() && manaToSpend > 0 && redstoneSignal > 0) {
                if (!this.func_145831_w().field_72995_K) {
                    item.addMana(this.getItem(), -manaToSpend);
                    pool.recieveMana(manaToSpend);
                    this.func_70296_d();
                }
                Botania.proxy.sparkleFX((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.0f, 0.8f, 1.0f, 0.5f, 4);
            }
        }
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IManaItem;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public ItemStack getItem() {
        return this.stacks.getStackInSlot(0);
    }

    public void setItem(ItemStack item) {
        this.stacks.setStackInSlot(0, item);
        this.isDirty = true;
    }
}

