/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.subtile.functional;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.item.equipment.tool.ItemBinder;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.SubTileFunctional;

public class SubTileManalinkium
extends SubTileFunctional {
    private static final int COST = 2000;
    private static final int RANGE = 1;
    private static final String TAG_X = "Posx";
    private static final String TAG_Y = "Posy";
    private static final String TAG_Z = "Posz";
    private static final String TAG_DIM = "dim";
    int x;
    int y;
    int z;
    int dim = 0;
    private static final DummyPool fallbackPool = new DummyPool();
    private static final BlockPos[] QUARTZ_LOCATIONS = new BlockPos[]{new BlockPos(2, -1, 2), new BlockPos(2, -1, 1), new BlockPos(2, -1, 0), new BlockPos(2, -1, -1), new BlockPos(2, -1, -2), new BlockPos(1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(0, -1, 2), new BlockPos(0, -1, -2), new BlockPos(-1, -1, 2), new BlockPos(-1, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-2, -1, -2)};
    private static final BlockPos[] LAMP_LOCATIONS = new BlockPos[]{new BlockPos(1, -1, 1), new BlockPos(-1, -1, 1), new BlockPos(1, -1, -1), new BlockPos(-1, -1, -1)};
    private static final BlockPos[] PILLAR_LOCATIONS = new BlockPos[]{new BlockPos(1, -1, 0), new BlockPos(0, -1, 1), new BlockPos(-1, -1, 0), new BlockPos(0, -1, -1)};

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_X, this.x);
        cmp.func_74768_a(TAG_Y, this.y);
        cmp.func_74768_a(TAG_Z, this.z);
        cmp.func_74768_a(TAG_DIM, this.dim);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.x = cmp.func_74762_e(TAG_X);
        this.y = cmp.func_74762_e(TAG_Y);
        this.z = cmp.func_74762_e(TAG_Z);
        this.dim = cmp.func_74762_e(TAG_DIM);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemBinder) {
            ItemBinder bind = (ItemBinder)player.func_184586_b(hand).func_77973_b();
            this.x = bind.getPosX(player.func_184586_b(hand));
            this.y = bind.getPosY(player.func_184586_b(hand));
            this.z = bind.getPosZ(player.func_184586_b(hand));
            this.dim = bind.getDim(player.func_184586_b(hand));
            ExtraBotanyAPI.unlockAdvancement(player, "manalinkiumUse");
        }
        return true;
    }

    public void onUpdate() {
        super.onUpdate();
        int posx = this.supertile.func_174877_v().func_177958_n();
        int posy = this.supertile.func_174877_v().func_177956_o();
        int posz = this.supertile.func_174877_v().func_177952_p();
        if (!SubTileManalinkium.canTPExist(this.getWorld(), this.getPos()) || this.redstoneSignal > 0) {
            return;
        }
        IManaPool pool = this.getManaPool(new BlockPos(this.x, this.y, this.z), this.dim);
        if (!(pool instanceof DummyPool || pool == null || this.supertile.func_145831_w().field_72995_K || this.mana < ConfigHandler.SPEED || pool.isFull())) {
            this.mana -= ConfigHandler.SPEED;
            pool.recieveMana(ConfigHandler.SPEED);
        }
    }

    public IManaPool getManaPool(BlockPos pos, int dim) {
        TileEntity tile;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return fallbackPool;
        }
        BlockPos coords = pos;
        if (coords.func_177956_o() == -1) {
            return null;
        }
        WorldServer world = null;
        for (WorldServer w : server.field_71305_c) {
            if (w.field_73011_w.getDimension() != dim) continue;
            world = w;
            break;
        }
        if (world != null && (tile = world.func_175625_s(coords)) != null && tile instanceof IManaPool) {
            return (IManaPool)tile;
        }
        return null;
    }

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos o : QUARTZ_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150371_ca.func_176223_P());
        }
        for (BlockPos o : LAMP_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150368_y.func_176223_P());
        }
        for (BlockPos o : PILLAR_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150343_Z.func_176223_P());
        }
        return mb.makeSet();
    }

    public static boolean canTPExist(World world, BlockPos pos) {
        for (BlockPos o : QUARTZ_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_150371_ca) continue;
            return false;
        }
        for (BlockPos o : LAMP_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_150368_y) continue;
            return false;
        }
        for (BlockPos o : PILLAR_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_150343_Z) continue;
            return false;
        }
        return true;
    }

    public int getMaxMana() {
        return 10000;
    }

    public LexiconEntry getEntry() {
        return LexiconData.manalinkium;
    }

    public int getColor() {
        return 65535;
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        public boolean isFull() {
            return false;
        }

        public void recieveMana(int mana) {
        }

        public boolean canRecieveManaFromBursts() {
            return false;
        }

        public int getCurrentMana() {
            return 0;
        }

        public boolean isOutputtingPower() {
            return false;
        }

        public EnumDyeColor getColor() {
            return EnumDyeColor.WHITE;
        }

        public void setColor(EnumDyeColor color) {
        }
    }
}

