/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block;

import com.meteor.extrabotany.common.block.BlockMod;
import com.meteor.extrabotany.common.block.tile.TileChargePad;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaItem;

public class BlockChargePad
extends BlockMod
implements ILexiconable {
    public BlockChargePad() {
        super(Material.field_151573_f, "chargepad");
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Random rand = new Random();
        TileChargePad pad = (TileChargePad)world.func_175625_s(pos);
        if (pad != null && !pad.getItem().func_190926_b()) {
            float f = rand.nextFloat() * 0.8f + 0.1f;
            float f1 = rand.nextFloat() * 0.8f + 0.1f;
            float f2 = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), pad.getItem());
            float f3 = 0.05f;
            item.field_70159_w = (float)rand.nextGaussian() * f3;
            item.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            item.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)item);
        }
        super.func_180663_b(world, pos, state);
    }

    public static boolean handleBlockActivation(World world, BlockPos pos, EntityPlayer player, ItemStack heldItem) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileChargePad) {
            TileChargePad te = (TileChargePad)tile;
            if (!heldItem.func_190926_b() && te.getItem().func_190926_b()) {
                if (!(heldItem.func_77973_b() instanceof IManaItem)) {
                    return false;
                }
                te.markForUpdate();
                ItemStack newItem = heldItem.func_77946_l();
                newItem.func_190920_e(1);
                te.setItem(newItem);
                heldItem.func_190918_g(1);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                return true;
            }
            if (player.field_71071_by.func_70441_a(((TileChargePad)tile).getItem())) {
                te.markForUpdate();
                te.setItem(ItemStack.field_190927_a);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                return true;
            }
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return BlockChargePad.handleBlockActivation(world, pos, player, player.func_184586_b(hand));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileChargePad();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileChargePad pad = (TileChargePad)world.func_175625_s(pos);
        if (pad.getItem().func_77973_b() instanceof IManaItem) {
            IManaItem item = (IManaItem)pad.getItem().func_77973_b();
            return 15 * item.getMana(pad.getItem()) / item.getMaxMana(pad.getItem());
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public LexiconEntry getEntry(World arg0, BlockPos arg1, EntityPlayer arg2, ItemStack arg3) {
        return LexiconData.chargepad;
    }
}

