/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.client.core.handler;

import com.meteor.extrabotany.client.render.IModelReg;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileAnnoyingFlower;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileEnchantedOrchid;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileManalinkium;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileMirrortunia;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileNecrofleur;
import com.meteor.extrabotany.common.block.subtile.functional.SubTileStardustLotus;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileBellFlower;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileBloodyEnchantress;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileEdelweiss;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileGeminiOrchid;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileMoonBless;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileOmniViolet;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileReikarLily;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileStonesia;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileSunBless;
import com.meteor.extrabotany.common.block.subtile.generating.SubTileTinkle;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.client.model.SpecialFlowerModel;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="extrabotany")
public class ModelHandler {
    public static boolean isClient = false;
    private static final Map<IRegistryDelegate<Block>, IStateMapper> customStateMappers = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, null, (String[])new String[]{"customStateMappers"});
    private static final DefaultStateMapper fallbackMapper = new DefaultStateMapper();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent evt) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)SpecialFlowerModel.Loader.INSTANCE);
        OBJLoader.INSTANCE.addDomain("extrabotany".toLowerCase(Locale.ROOT));
        ModelHandler.registerSubtiles();
        for (Block block : Block.field_149771_c) {
            if (!(block instanceof IModelReg)) continue;
            ((IModelReg)block).registerModels();
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IModelReg)) continue;
            ((IModelReg)item).registerModels();
        }
        isClient = true;
    }

    private static void registerSubtiles() {
        if (ConfigHandler.ENABLE_BE) {
            BotaniaAPIClient.registerSubtileModel(SubTileBloodyEnchantress.class, (ModelResourceLocation)new ModelResourceLocation("botania:bloodyenchantress"));
        }
        if (ConfigHandler.ENABLE_SB) {
            BotaniaAPIClient.registerSubtileModel(SubTileSunBless.class, (ModelResourceLocation)new ModelResourceLocation("botania:sunbless"));
        }
        if (ConfigHandler.ENABLE_MB) {
            BotaniaAPIClient.registerSubtileModel(SubTileMoonBless.class, (ModelResourceLocation)new ModelResourceLocation("botania:moonbless"));
        }
        if (ConfigHandler.ENABLE_OV) {
            BotaniaAPIClient.registerSubtileModel(SubTileOmniViolet.class, (ModelResourceLocation)new ModelResourceLocation("botania:omniviolet"));
        }
        if (ConfigHandler.ENABLE_SS) {
            BotaniaAPIClient.registerSubtileModel(SubTileStonesia.class, (ModelResourceLocation)new ModelResourceLocation("botania:stonesia"));
        }
        if (ConfigHandler.ENABLE_TK) {
            BotaniaAPIClient.registerSubtileModel(SubTileTinkle.class, (ModelResourceLocation)new ModelResourceLocation("botania:tinkle"));
        }
        if (ConfigHandler.ENABLE_BF) {
            BotaniaAPIClient.registerSubtileModel(SubTileBellFlower.class, (ModelResourceLocation)new ModelResourceLocation("botania:bellflower"));
        }
        if (ConfigHandler.ENABLE_AF) {
            BotaniaAPIClient.registerSubtileModel(SubTileAnnoyingFlower.class, (ModelResourceLocation)new ModelResourceLocation("botania:annoyingflower"));
        }
        if (ConfigHandler.ENABLE_SL) {
            BotaniaAPIClient.registerSubtileModel(SubTileStardustLotus.class, (ModelResourceLocation)new ModelResourceLocation("botania:stardustlotus"));
        }
        if (ConfigHandler.ENABLE_ML) {
            BotaniaAPIClient.registerSubtileModel(SubTileManalinkium.class, (ModelResourceLocation)new ModelResourceLocation("botania:manalinkium"));
        }
        if (ConfigHandler.ENABLE_RL) {
            BotaniaAPIClient.registerSubtileModel(SubTileReikarLily.class, (ModelResourceLocation)new ModelResourceLocation("botania:reikarlily"));
        }
        if (ConfigHandler.ENABLE_EO) {
            BotaniaAPIClient.registerSubtileModel(SubTileEnchantedOrchid.class, (ModelResourceLocation)new ModelResourceLocation("botania:enchantedorchid"));
        }
        if (ConfigHandler.ENABLE_MT) {
            BotaniaAPIClient.registerSubtileModel(SubTileMirrortunia.class, (ModelResourceLocation)new ModelResourceLocation("botania:mirrowtunia"));
        }
        if (ConfigHandler.ENABLE_EW) {
            BotaniaAPIClient.registerSubtileModel(SubTileEdelweiss.class, (ModelResourceLocation)new ModelResourceLocation("botania:edelweiss"));
        }
        if (ConfigHandler.ENABLE_GO) {
            BotaniaAPIClient.registerSubtileModel(SubTileGeminiOrchid.class, (ModelResourceLocation)new ModelResourceLocation("botania:geminiorchid"));
        }
        if (ConfigHandler.ENABLE_NF) {
            BotaniaAPIClient.registerSubtileModel(SubTileNecrofleur.class, (ModelResourceLocation)new ModelResourceLocation("botania:necrofleur"));
            BotaniaAPIClient.registerSubtileModel(SubTileNecrofleur.Mini.class, (ModelResourceLocation)new ModelResourceLocation("botania:necrofleurChibi"));
        }
    }

    private static ModelResourceLocation getMrlForState(IBlockState state) {
        return (ModelResourceLocation)customStateMappers.getOrDefault(state.func_177230_c().delegate, (IStateMapper)fallbackMapper).func_178130_a(state.func_177230_c()).get(state);
    }

    public static void registerBlockToState(Block b, int meta, IBlockState state) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)meta, (ModelResourceLocation)ModelHandler.getMrlForState(state));
    }

    public static void registerBlockToState(Block b, int maxExclusive) {
        for (int i = 0; i < maxExclusive; ++i) {
            ModelHandler.registerBlockToState(b, i, b.func_176203_a(i));
        }
    }

    public static void registerItemMetas(Item item, int maxExclusive, IntFunction<String> metaToName) {
        for (int i = 0; i < maxExclusive; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation("extrabotany:" + metaToName.apply(i), "inventory"));
        }
    }
}

