/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.client.core.handler;

import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class EventHandlerClient {
    private static final ResourceLocation texture = new ResourceLocation("extrabotany", "textures/gui/cursor.png");
    public static final EventHandlerClient INSTANCE = new EventHandlerClient();

    @SubscribeEvent
    public void handleTextureStitchPreEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("extrabotany", "blocks/fluid/mana_still"));
        event.getMap().func_174942_a(new ResourceLocation("extrabotany", "blocks/fluid/mana_flow"));
    }

    public static void loadCursor(BufferedImage img) throws LWJGLException {
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rgbData = new int[w * h];
        for (int i = 0; i < rgbData.length; ++i) {
            int x = i % w;
            int y = h - 1 - i / w;
            rgbData[i] = img.getRGB(x, y);
        }
        IntBuffer buffer = BufferUtils.createIntBuffer((int)(w * h));
        buffer.put(rgbData);
        buffer.rewind();
        Cursor cursor = new Cursor(w, h, 2, h - 2, 1, buffer, null);
        Mouse.setNativeCursor((Cursor)cursor);
    }

    public static void loadCursor() {
        try {
            BufferedImage image = ImageIO.read(new FileInputStream("mods/cursor.png"));
            EventHandlerClient.loadCursor(image);
        }
        catch (IOException | LWJGLException e) {
            e.printStackTrace();
            try {
                Files.write(Paths.get("", "exbot-error.txt"), e.getMessage().getBytes(), new OpenOption[0]);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

