/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.api.orb;

import com.meteor.extrabotany.api.item.INatureOrb;
import com.meteor.extrabotany.api.orb.OrbItemsEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;

public class OrbItemHandler {
    public static List<ItemStack> getOrbItems(EntityPlayer player) {
        if (player == null) {
            return new ArrayList<ItemStack>();
        }
        IItemHandler mainInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<ItemStack> toReturn = new ArrayList<ItemStack>();
        int size = mainInv.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stackInSlot = mainInv.getStackInSlot(slot);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof INatureOrb)) continue;
            toReturn.add(stackInSlot);
        }
        OrbItemsEvent event = new OrbItemsEvent(player, toReturn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        toReturn = event.getItems();
        return toReturn;
    }

    public static Map<Integer, ItemStack> getOrbBaubles(EntityPlayer player) {
        if (player == null) {
            return new HashMap<Integer, ItemStack>();
        }
        IItemHandlerModifiable baublesInv = BotaniaAPI.internalHandler.getBaublesInventoryWrapped(player);
        if (baublesInv == null) {
            return new HashMap<Integer, ItemStack>();
        }
        HashMap<Integer, ItemStack> toReturn = new HashMap<Integer, ItemStack>();
        int size = baublesInv.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stackInSlot = baublesInv.getStackInSlot(slot);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof INatureOrb)) continue;
            toReturn.put(slot, stackInSlot);
        }
        return toReturn;
    }

    public static int requestNature(ItemStack stack, EntityPlayer player, int xpToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = OrbItemHandler.getOrbItems(player);
        for (ItemStack stackInSlot : items) {
            if (stackInSlot == stack) continue;
            INatureOrb orb = (INatureOrb)stackInSlot.func_77973_b();
            if (stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canReceiveFrom(stack, stackInSlot)) continue;
            if (orb.getXP(stackInSlot) < xpToGet) {
                return 0;
            }
            if (remove) {
                orb.addXP(stackInSlot, -xpToGet);
            }
            return xpToGet;
        }
        Map<Integer, ItemStack> baubles = OrbItemHandler.getOrbBaubles(player);
        for (Map.Entry<Integer, ItemStack> entry : baubles.entrySet()) {
            INatureOrb manaItem;
            ItemStack stackInSlot = entry.getValue();
            if (stackInSlot == stack || (manaItem = (INatureOrb)stackInSlot.func_77973_b()).getXP(stackInSlot) <= 0 || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canReceiveFrom(stack, stackInSlot)) continue;
            int mana = Math.min(xpToGet, manaItem.getXP(stackInSlot));
            if (remove) {
                manaItem.addXP(stackInSlot, -mana);
            }
            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, entry.getKey().intValue());
            return mana;
        }
        return 0;
    }

    public static boolean requestNatureExact(ItemStack stack, EntityPlayer player, int xpToGet, boolean remove) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = OrbItemHandler.getOrbItems(player);
        for (ItemStack stackInSlot : items) {
            if (stackInSlot == stack) continue;
            INatureOrb orb = (INatureOrb)stackInSlot.func_77973_b();
            if (stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canReceiveFrom(stack, stackInSlot)) continue;
            if (orb.getXP(stackInSlot) < xpToGet) {
                return false;
            }
            if (remove) {
                orb.addXP(stackInSlot, -xpToGet);
            }
            return true;
        }
        Map<Integer, ItemStack> baubles = OrbItemHandler.getOrbBaubles(player);
        for (Map.Entry<Integer, ItemStack> entry : baubles.entrySet()) {
            INatureOrb manaItemSlot;
            ItemStack stackInSlot = entry.getValue();
            if (stackInSlot == stack || (manaItemSlot = (INatureOrb)stackInSlot.func_77973_b()).getXP(stackInSlot) <= xpToGet || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canReceiveFrom(stack, stackInSlot)) continue;
            if (remove) {
                manaItemSlot.addXP(stackInSlot, -xpToGet);
            }
            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, entry.getKey().intValue());
            return true;
        }
        return false;
    }

    public static int dispatchMana(ItemStack stack, EntityPlayer player, int xpToSend, boolean add) {
        if (stack.func_190926_b()) {
            return 0;
        }
        List<ItemStack> items = OrbItemHandler.getOrbItems(player);
        for (ItemStack stackInSlot : items) {
            INatureOrb manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = (INatureOrb)stackInSlot.func_77973_b()).canReceiveFrom(stackInSlot, stack) || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canExportTo(stack, stackInSlot)) continue;
            int received = manaItemSlot.getXP(stackInSlot) + xpToSend <= manaItemSlot.getMaxXP(stackInSlot) ? xpToSend : xpToSend - (manaItemSlot.getXP(stackInSlot) + xpToSend - manaItemSlot.getMaxXP(stackInSlot));
            if (add) {
                manaItemSlot.addXP(stackInSlot, xpToSend);
            }
            return received;
        }
        Map<Integer, ItemStack> baubles = OrbItemHandler.getOrbBaubles(player);
        for (Map.Entry<Integer, ItemStack> entry : baubles.entrySet()) {
            INatureOrb manaItemSlot;
            ItemStack stackInSlot = entry.getValue();
            if (stackInSlot == stack || !(manaItemSlot = (INatureOrb)stackInSlot.func_77973_b()).canReceiveFrom(stackInSlot, stack) || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canExportTo(stack, stackInSlot)) continue;
            int received = manaItemSlot.getXP(stackInSlot) + xpToSend <= manaItemSlot.getMaxXP(stackInSlot) ? xpToSend : xpToSend - (manaItemSlot.getXP(stackInSlot) + xpToSend - manaItemSlot.getMaxXP(stackInSlot));
            if (add) {
                manaItemSlot.addXP(stackInSlot, xpToSend);
            }
            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, entry.getKey().intValue());
            return received;
        }
        return 0;
    }

    public static boolean dispatchManaExact(ItemStack stack, EntityPlayer player, int xpToSend, boolean add) {
        if (stack.func_190926_b()) {
            return false;
        }
        List<ItemStack> items = OrbItemHandler.getOrbItems(player);
        for (ItemStack stackInSlot : items) {
            INatureOrb manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = (INatureOrb)stackInSlot.func_77973_b()).getXP(stackInSlot) + xpToSend > manaItemSlot.getMaxXP(stackInSlot) || !manaItemSlot.canReceiveFrom(stackInSlot, stack) || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canExportTo(stack, stackInSlot)) continue;
            if (add) {
                manaItemSlot.addXP(stackInSlot, xpToSend);
            }
            return true;
        }
        Map<Integer, ItemStack> baubles = OrbItemHandler.getOrbBaubles(player);
        for (Map.Entry<Integer, ItemStack> entry : baubles.entrySet()) {
            INatureOrb manaItemSlot;
            ItemStack stackInSlot = entry.getValue();
            if (stackInSlot == stack || (manaItemSlot = (INatureOrb)stackInSlot.func_77973_b()).getXP(stackInSlot) + xpToSend > manaItemSlot.getMaxXP(stackInSlot) || !manaItemSlot.canReceiveFrom(stackInSlot, stack) || stack.func_77973_b() instanceof INatureOrb && !((INatureOrb)stack.func_77973_b()).canExportTo(stack, stackInSlot)) continue;
            if (add) {
                manaItemSlot.addXP(stackInSlot, xpToSend);
            }
            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, entry.getKey().intValue());
            return true;
        }
        return false;
    }
}

