/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.api;

import com.gamerforea.eventhelper.util.EventUtils;
import com.meteor.extrabotany.ExtraBotany;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.crafting.recipe.RecipeOmniviolet;
import com.meteor.extrabotany.common.crafting.recipe.RecipePedestal;
import com.meteor.extrabotany.common.crafting.recipe.RecipeStonesia;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.EnumHelper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.recipe.RecipeManaInfusion;

public class ExtraBotanyAPI {
    public static IBlockState dimensionState;
    public static final KnowledgeType dreamKnowledge;
    public static LexiconCategory dreamCategory;
    public static final List<RecipePedestal> pedestalRecipes;
    public static final List<RecipeStonesia> stonesiaRecipes;
    public static final List<RecipeOmniviolet> omnivioletRecipes;
    public static final ItemArmor.ArmorMaterial orichalcosArmorMaterial;
    public static final ItemArmor.ArmorMaterial shadowiumArmorMaterial;
    public static final Item.ToolMaterial shadowiumToolMaterial;
    public static final ItemArmor.ArmorMaterial goblinslayerArmorMaterial;
    public static final Item.ToolMaterial manasteelHammer;
    public static final Item.ToolMaterial elementiumHammer;
    public static final Item.ToolMaterial terrasteelHammer;
    public static final Item.ToolMaterial ultimateHammer;
    public static final Set<Block> gaiaBreakBlacklist;

    public static void blacklistBlockFromGaiaGuardian(Block block) {
        gaiaBreakBlacklist.add(block);
    }

    public static RecipeManaInfusion registerManaDimensionRecipe(ItemStack output, Object input, int mana) {
        RecipeManaInfusion recipe = BotaniaAPI.registerManaInfusionRecipe((ItemStack)output, (Object)input, (int)mana);
        recipe.setCatalyst(dimensionState);
        return recipe;
    }

    public static RecipePedestal registerPedestalRecipe(ItemStack output, ItemStack input) {
        RecipePedestal recipe = new RecipePedestal(output, input);
        pedestalRecipes.add(recipe);
        return recipe;
    }

    public static RecipeStonesia registerStonesiaRecipe(int output, Object input) {
        RecipeStonesia recipe = new RecipeStonesia(output, input);
        stonesiaRecipes.add(recipe);
        return recipe;
    }

    public static RecipeOmniviolet registerOmnivioletRecipe(int output, ItemStack input) {
        RecipeOmniviolet recipe = new RecipeOmniviolet(output, input);
        omnivioletRecipes.add(recipe);
        return recipe;
    }

    public static void unlockAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("extrabotany", "main/" + name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "ebt_trigger");
            }
        }
    }

    public static boolean cantAttack(EntityLivingBase attacker, EntityLivingBase target) {
        if (ExtraBotany.isTableclothServer) {
            return attacker instanceof EntityPlayer && EventUtils.cantAttack((EntityPlayer)((EntityPlayer)attacker), (Entity)target);
        }
        return false;
    }

    public static float dealTrueDamage(EntityLivingBase player, EntityLivingBase target, float amount) {
        float result = 0.0f;
        if (target == null) {
            return result;
        }
        if (!(target instanceof EntityLivingBase)) {
            return result;
        }
        if (!target.func_70089_S()) {
            return result;
        }
        if (amount < 0.0f) {
            return result;
        }
        if (player != null && ExtraBotanyAPI.cantAttack(player, target)) {
            return result;
        }
        target.func_70097_a(DamageSource.field_76376_m.func_151518_m().func_76348_h(), 0.01f);
        float health = target.func_110143_aJ();
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_184812_l_()) {
            return result;
        }
        if (ConfigHandler.ENABLE_TRUEDAMAGE) {
            if (!target.func_184222_aU()) {
                amount *= 0.5f;
            }
            if (health > 0.0f) {
                float postHealth = Math.max(1.0f, health - amount);
                target.func_70606_j(postHealth);
                if (health <= amount) {
                    if (target instanceof EntityPlayer) {
                        target.func_174812_G();
                    } else {
                        target.func_70097_a(DamageSource.field_76376_m.func_151518_m().func_76348_h(), 2.1474836E9f);
                    }
                }
                result = health - postHealth;
            }
        } else {
            target.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)target), amount);
        }
        return result;
    }

    public static void addPotionEffect(EntityLivingBase entity, Potion potion, int time, int max, boolean multi) {
        if (!entity.func_70644_a(potion)) {
            entity.func_70690_d(new PotionEffect(potion, time, 0));
        } else {
            int amp = entity.func_70660_b(potion).func_76458_c();
            int t = multi ? time + 200 * amp : time;
            entity.func_70690_d(new PotionEffect(potion, t, Math.min(max, amp + 1)));
        }
    }

    public static void addPotionEffect(EntityLivingBase entity, Potion potion, int max) {
        ExtraBotanyAPI.addPotionEffect(entity, potion, 100, max, false);
    }

    static {
        pedestalRecipes = new ArrayList<RecipePedestal>();
        stonesiaRecipes = new ArrayList<RecipeStonesia>();
        omnivioletRecipes = new ArrayList<RecipeOmniviolet>();
        orichalcosArmorMaterial = EnumHelper.addArmorMaterial((String)"ORICHALCOS", (String)"orichalcos", (int)50, (int[])new int[]{4, 7, 8, 3}, (int)50, (SoundEvent)SoundEvents.field_187716_o, (float)4.0f);
        shadowiumArmorMaterial = EnumHelper.addArmorMaterial((String)"SHADOWIUM", (String)"shadowium", (int)23, (int[])new int[]{3, 7, 6, 3}, (int)28, (SoundEvent)SoundEvents.field_187713_n, (float)1.5f);
        shadowiumToolMaterial = EnumHelper.addToolMaterial((String)"SHADOWIUM", (int)3, (int)880, (float)6.5f, (float)2.0f, (int)12);
        goblinslayerArmorMaterial = EnumHelper.addArmorMaterial((String)"GOBLINSLAYER", (String)"goblinslayer", (int)21, (int[])new int[]{3, 6, 6, 3}, (int)40, (SoundEvent)SoundEvents.field_187725_r, (float)2.5f);
        manasteelHammer = EnumHelper.addToolMaterial((String)"MANASTEELHAMMER", (int)3, (int)400, (float)6.8f, (float)2.0f, (int)20);
        elementiumHammer = EnumHelper.addToolMaterial((String)"ELEMENTIUMHAMMER", (int)3, (int)900, (float)6.8f, (float)2.0f, (int)20);
        terrasteelHammer = EnumHelper.addToolMaterial((String)"TERRASTEELHAMMER", (int)4, (int)3000, (float)9.8f, (float)3.0f, (int)26);
        ultimateHammer = EnumHelper.addToolMaterial((String)"ULTIMATEHAMMER", (int)4, (int)3000, (float)10.5f, (float)3.0f, (int)40);
        gaiaBreakBlacklist = new HashSet<Block>();
        dreamKnowledge = BotaniaAPI.registerKnowledgeType((String)"dream", (TextFormatting)TextFormatting.DARK_RED, (boolean)false);
        ExtraBotanyAPI.blacklistBlockFromGaiaGuardian((Block)Blocks.field_150461_bJ);
    }
}

