/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.asm;

import bre.smoothfont.asm.AsmHelper;
import bre.smoothfont.asm.CustomAdapter;
import bre.smoothfont.config.GlobalConfig;
import java.io.File;
import java.io.FileOutputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Transformer
implements IClassTransformer {
    public static int transformingErrorId = 0;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassReader cr;
        if (FMLLaunchHandler.side().isServer()) {
            return bytes;
        }
        if (!this.accept(transformedName)) {
            return bytes;
        }
        AsmHelper.logDebug("Internal name = " + name);
        AsmHelper.logDebug("Transformed name = " + transformedName);
        try {
            cr = new ClassReader(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            cr = new ClassReader(bytes);
        }
        ClassWriter cw = new ClassWriter(3);
        CustomAdapter.ClassAdapter cv = new CustomAdapter.ClassAdapter((ClassVisitor)cw, name, transformedName);
        cr.accept((ClassVisitor)cv, 8);
        if (transformedName.equals("net.minecraft.client.gui.FontRenderer") && GlobalConfig.hasDebugOption("dumpFontRenderer")) {
            FileOutputStream fos;
            try {
                fos = new FileOutputStream("config" + File.separator + "smoothfont" + File.separator + "FontRenderer-orig.class");
                fos.write(bytes);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                fos = new FileOutputStream("config" + File.separator + "smoothfont" + File.separator + "FontRenderer-transformed.class");
                fos.write(cw.toByteArray());
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cw.toByteArray();
    }

    private boolean accept(String className) {
        for (TargetClass target : TargetClass.values()) {
            String name = target.getClassName();
            if (!name.equals(className)) continue;
            AsmHelper.logger.info("Transform: " + className);
            return true;
        }
        return false;
    }

    protected static enum TargetClass {
        FONT_RENDERER("net.minecraft.client.gui.FontRenderer"),
        SCALED_RESOLUTION("net.minecraft.client.gui.ScaledResolution"),
        TEXTURE_MANAGER("net.minecraft.client.renderer.texture.TextureManager"),
        GUI_INGAME_FORGE("net.minecraftforge.client.GuiIngameForge"),
        GL_STATE_MANAGER("net.minecraft.client.renderer.GlStateManager");

        private String className;

        private TargetClass(String name) {
            this.className = name;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

