/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2;

import ic2.api.recipe.IBasicMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.compatmod.ic2.IC2Dict;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.items.ingredients.ItemParts;

public class IC2Recipes {
    static List<RecipeDuplicate> recipeDuplicateList = new ArrayList<RecipeDuplicate>();

    public static void cloneMachineRecipes(String machine, IBasicMachineRecipeManager recipeManager) {
        RecipeHandler.getRecipeClassFromName((String)machine).forEach(recipeType -> {
            if (recipeType.getInputs().size() == 1 && recipeType.getOutputs().size() == 1) {
                Object object = recipeType.getInputs().get(0);
                IRecipeInput input = null;
                if (object instanceof ItemStack) {
                    input = Recipes.inputFactory.forStack((ItemStack)object);
                } else if (object instanceof String) {
                    input = Recipes.inputFactory.forOreDict((String)object);
                }
                recipeManager.addRecipe((Object)input, Collections.singletonList(recipeType.getOutputs().get(0)), null, false);
            }
        });
    }

    public static void registerRecipes() {
        recipeDuplicateList.add(new RecipeDuplicate(new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 0), IC2Dict.getItem("resource", "machine")));
        for (RecipeDuplicate duplicate : recipeDuplicateList) {
            duplicate.add();
        }
        RebornCraftingHelper.addShapelessRecipe((ItemStack)ItemParts.getPartByName((String)"rubber"), (Object[])new Object[]{IC2Dict.getItem("crafting", "rubber")});
        if (!IC2Duplicates.deduplicate()) {
            RebornCraftingHelper.addShapelessRecipe((ItemStack)IC2Dict.getItem("crafting", "rubber"), (Object[])new Object[]{ItemParts.getPartByName((String)"rubber")});
            techreborn.api.recipe.Recipes.compressor.createRecipe().withInput(IC2Dict.getItem("crafting", "carbon_mesh")).withOutput(IC2Dict.getItem("crafting", "carbon_plate")).withEnergyCostPerTick(2).withOperationDuration(400).register();
            techreborn.api.recipe.Recipes.compressor.createRecipe().withInput(IC2Dict.getItem("crafting", "coal_ball")).withOutput(IC2Dict.getItem("crafting", "coal_block")).withEnergyCostPerTick(2).withOperationDuration(400).register();
        }
    }

    public static class RecipeDuplicate {
        ItemStack stack1;
        ItemStack stack2;

        public RecipeDuplicate(ItemStack stack1, ItemStack stack2) {
            this.stack1 = stack1;
            this.stack2 = stack2;
        }

        public void add() {
            RebornCraftingHelper.addShapelessRecipe((ItemStack)this.stack2, (Object[])new Object[]{this.stack1});
            RebornCraftingHelper.addShapelessRecipe((ItemStack)this.stack1, (Object[])new Object[]{this.stack2});
        }
    }
}

