/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.compatmod.crafttweaker.CraftTweakerCompat;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.fusionReactor")
public class CTFusionReactor {
    @ZenMethod
    @ZenDocumentation(value="IIngredient topInput, IIngredient bottomInput, IItemStack output, int startEU, int euTick, int tickTime")
    public static void addRecipe(IIngredient topInput, IIngredient bottomInput, IItemStack output, int startEU, int euTick, int tickTime) {
        FusionReactorRecipe reactorRecipe = new FusionReactorRecipe((ItemStack)CraftTweakerCompat.toObject(topInput), (ItemStack)CraftTweakerCompat.toObject(bottomInput), CraftTweakerCompat.toStack(output), (double)startEU, (double)euTick, tickTime);
        CraftTweakerAPI.apply((IAction)new Add(reactorRecipe));
    }

    @ZenMethod
    @ZenDocumentation(value="IIngredient topInput, IIngredient bottomInput, IItemStack output, int startEU, int euTick, int tickTime, int minSize")
    public static void addRecipe(IIngredient topInput, IIngredient bottomInput, IItemStack output, int startEU, int euTick, int tickTime, int minSize) {
        FusionReactorRecipe reactorRecipe = new FusionReactorRecipe((ItemStack)CraftTweakerCompat.toObject(topInput), (ItemStack)CraftTweakerCompat.toObject(bottomInput), CraftTweakerCompat.toStack(output), (double)startEU, (double)euTick, tickTime, minSize);
        CraftTweakerAPI.apply((IAction)new Add(reactorRecipe));
    }

    @ZenMethod
    @ZenDocumentation(value="IIngredient iIngredient")
    public static void removeTopInputRecipe(IIngredient iIngredient) {
        CraftTweakerAPI.apply((IAction)new RemoveTopInput(iIngredient));
    }

    @ZenMethod
    @ZenDocumentation(value="IIngredient iIngredient")
    public static void removeBottomInputRecipe(IIngredient iIngredient) {
        CraftTweakerAPI.apply((IAction)new RemoveBottomInput(iIngredient));
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack output")
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerCompat.toStack(output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            FusionReactorRecipeHelper.reactorRecipes.clear();
        }

        public String describe() {
            return "Removing all Fusion Reactor recipes";
        }
    }

    private static class RemoveBottomInput
    implements IAction {
        private final IIngredient output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public RemoveBottomInput(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                if (!this.output.matches(CraftTweakerMC.getIItemStack((ItemStack)recipeType.getBottomInput()))) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe";
        }
    }

    private static class RemoveTopInput
    implements IAction {
        private final IIngredient output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public RemoveTopInput(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                if (!this.output.matches(CraftTweakerMC.getIItemStack((ItemStack)recipeType.getTopInput()))) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                boolean matchNBT = this.output.func_77942_o();
                if (!ItemUtils.isItemEqual((ItemStack)recipeType.getOutput(), (ItemStack)this.output, (boolean)true, (boolean)matchNBT)) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final FusionReactorRecipe recipe;

        public Add(FusionReactorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FusionReactorRecipeHelper.registerRecipe((FusionReactorRecipe)this.recipe);
        }

        public String describe() {
            return "Adding Fusion Reactor recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

