/*
 * Decompiled with CFR 0.152.
 */
package squeek.hungerpersistence;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    public static final ModConfig instance = new ModConfig();
    public static Configuration config;
    public static final String CATEGORY_MAIN = "main";
    private static final String CATEGORY_MAIN_COMMENT = "";
    public static int MINIMUM_HUNGER_ON_RESPAWN;
    private static final String MINIMUM_HUNGER_ON_RESPAWN_NAME = "Minimum hunger on respawn";
    private static final int MINIMUM_HUNGER_ON_RESPAWN_DEFAULT = 4;
    private static final String MINIMUM_HUNGER_ON_RESPAWN_COMMENT = "If a player's hunger on death is lower than this value, then it will be set to this value on respawn.\nDefault Minecraft sets your hunger to 20 on respawn (full hunger).\nNote: 1 hunger unit = 1/2 hunger bar, so, for example, a value of 4 here means respawning with 2 hunger bars.";
    public static int MAXIMUM_HUNGER_ON_RESPAWN;
    private static final String MAXIMUM_HUNGER_ON_RESPAWN_NAME = "Maximum hunger on respawn";
    private static final int MAXIMUM_HUNGER_ON_RESPAWN_DEFAULT = 20;
    private static final String MAXIMUM_HUNGER_ON_RESPAWN_COMMENT = "If a player's hunger on death is higher than this value, then it will be set to this value on respawn.\nSet this equal to Minimum hunger on respawn to always have the player respawn with that exact hunger value.\nNote: 1 hunger unit = 1/2 hunger bar, and 20 hunger units is 'full'.\n";
    public static double MINIMUM_SATURATION_ON_RESPAWN;
    private static final String MINIMUM_SATURATION_ON_RESPAWN_NAME = "Minimum saturation on respawn";
    private static final double MINIMUM_SATURATION_ON_RESPAWN_DEFAULT = 0.0;
    private static final String MINIMUM_SATURATION_ON_RESPAWN_COMMENT = "If a player's saturation on death is lower than this value, then it will be set to this value on respawn.\nDefault Minecraft sets your saturation to 5.0 on respawn.\nNote: 20 saturation is 'full', and saturation can never be higher than the player's current hunger level";
    public static double MAXIMUM_SATURATION_ON_RESPAWN;
    private static final String MAXIMUM_SATURATION_ON_RESPAWN_NAME = "Maximum saturation on respawn";
    private static final double MAXIMUM_SATURATION_ON_RESPAWN_DEFAULT = 20.0;
    private static final String MAXIMUM_SATURATION_ON_RESPAWN_COMMENT = "If a player's saturation on death is higher than this value, then it will be set to this value on respawn.\nSet this to 0 to always have the player respawn with no saturation.\nNote: 20 saturation is 'full', and saturation can never be higher than the player's current hunger level.\n";

    private ModConfig() {
    }

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.load();
        ModConfig.sync();
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("hungerpersistence")) {
            ModConfig.sync();
        }
    }

    public static void sync() {
        config.getCategory(CATEGORY_MAIN).setComment(CATEGORY_MAIN_COMMENT);
        MINIMUM_HUNGER_ON_RESPAWN = config.get(CATEGORY_MAIN, MINIMUM_HUNGER_ON_RESPAWN_NAME, 4, MINIMUM_HUNGER_ON_RESPAWN_COMMENT).getInt(4);
        MAXIMUM_HUNGER_ON_RESPAWN = config.get(CATEGORY_MAIN, MAXIMUM_HUNGER_ON_RESPAWN_NAME, 20, MAXIMUM_HUNGER_ON_RESPAWN_COMMENT).getInt(20);
        MINIMUM_SATURATION_ON_RESPAWN = config.get(CATEGORY_MAIN, MINIMUM_SATURATION_ON_RESPAWN_NAME, 0.0, MINIMUM_SATURATION_ON_RESPAWN_COMMENT).getDouble(0.0);
        MAXIMUM_SATURATION_ON_RESPAWN = config.get(CATEGORY_MAIN, MAXIMUM_SATURATION_ON_RESPAWN_NAME, 20.0, MAXIMUM_SATURATION_ON_RESPAWN_COMMENT).getDouble(20.0);
        if (config.hasChanged()) {
            ModConfig.save();
        }
    }

    public static void save() {
        config.save();
    }

    public static void load() {
        config.load();
    }

    static {
        MINIMUM_HUNGER_ON_RESPAWN = 4;
        MAXIMUM_HUNGER_ON_RESPAWN = 20;
        MINIMUM_SATURATION_ON_RESPAWN = 0.0;
        MAXIMUM_SATURATION_ON_RESPAWN = 20.0;
    }
}

