/*
 * Decompiled with CFR 0.152.
 */
package squeek.hungerpersistence;

import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import squeek.hungerpersistence.ModConfig;

@Mod(modid="hungerpersistence", version="1.0.1", name="Hunger Persistence", acceptableRemoteVersions="*", guiFactory="squeek.hungerpersistence.client.gui.GuiFactory", acceptedMinecraftVersions="[1.12]")
public class HungerPersistence {
    public static final Logger Log = LogManager.getLogger((String)"hungerpersistence");
    @Mod.Instance(value="hungerpersistence")
    public static HungerPersistence instance;
    private static final Field foodStatsField;
    private static final Field saturationLevelField;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModConfig.init(event.getSuggestedConfigurationFile());
    }

    private void serverSetFoodSaturationLevel(FoodStats foodStats, float saturationLevel) {
        try {
            saturationLevelField.set(foodStats, Float.valueOf(saturationLevel));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        try {
            foodStatsField.set(event.getEntityPlayer(), event.getOriginal().func_71024_bL());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        FoodStats foodStats = event.getEntityPlayer().func_71024_bL();
        if (foodStats.func_75116_a() < ModConfig.MINIMUM_HUNGER_ON_RESPAWN) {
            foodStats.func_75114_a(ModConfig.MINIMUM_HUNGER_ON_RESPAWN);
        }
        if (foodStats.func_75116_a() > ModConfig.MAXIMUM_HUNGER_ON_RESPAWN) {
            foodStats.func_75114_a(ModConfig.MAXIMUM_HUNGER_ON_RESPAWN);
        }
        if ((double)foodStats.func_75115_e() < ModConfig.MINIMUM_SATURATION_ON_RESPAWN) {
            this.serverSetFoodSaturationLevel(foodStats, (float)ModConfig.MINIMUM_SATURATION_ON_RESPAWN);
        }
        if ((double)foodStats.func_75115_e() > ModConfig.MAXIMUM_SATURATION_ON_RESPAWN) {
            this.serverSetFoodSaturationLevel(foodStats, (float)ModConfig.MAXIMUM_SATURATION_ON_RESPAWN);
        }
    }

    static {
        foodStatsField = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"foodStats", "field_71100_bB", "bw"});
        saturationLevelField = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"foodSaturationLevel", "field_75125_b", "b"});
    }
}

