/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.recipe.RecipeInfoCrafting;

public class RecipeTypeCrafting
implements IRecipeType {
    public static final RecipeTypeCrafting INSTANCE = new RecipeTypeCrafting();
    public static final ResourceLocation NAME = new ResourceLocation("packagedauto:crafting");
    public static final IntSet SLOTS;
    public static final List<String> CATEGORIES;
    public static final Color COLOR;
    public static final Color COLOR_DISABLED;

    protected RecipeTypeCrafting() {
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public String getLocalizedName() {
        return I18n.func_74838_a((String)"recipe.packagedauto.crafting");
    }

    @Override
    public String getLocalizedNameShort() {
        return I18n.func_74838_a((String)"recipe.packagedauto.crafting.short");
    }

    @Override
    public IRecipeInfo getNewRecipeInfo() {
        return new RecipeInfoCrafting();
    }

    @Override
    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    @Override
    public boolean canSetOutput() {
        return false;
    }

    @Override
    public boolean hasMachine() {
        return true;
    }

    @Override
    public List<String> getJEICategories() {
        return CATEGORIES;
    }

    @Override
    @Optional.Method(modid="jei")
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayout recipeLayout, String category) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (Map.Entry entry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient.isInput()) {
                ItemStack displayed = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    map.put(slotArray[index], (Object)displayed);
                }
                ++index;
            }
            if (index < 9) continue;
            break;
        }
        return map;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getRepresentation() {
        return new ItemStack(Blocks.field_150462_ai);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Color getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = Collections.singletonList("minecraft.crafting");
        COLOR = new Color(139, 139, 139);
        COLOR_DISABLED = new Color(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 3; i < 6; ++i) {
            for (int j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

