/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.neid.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import ru.fewizz.neid.asm.Name;
import ru.fewizz.neid.asm.TransformerGroup;
import ru.fewizz.neid.asm.group.block.TransformerGroupAnvilChunkLoader;
import ru.fewizz.neid.asm.group.block.TransformerGroupBlockHardcoredConstants;
import ru.fewizz.neid.asm.group.block.TransformerGroupChunkPrimer;
import ru.fewizz.neid.asm.group.block.TransformerGroupWorldEdit;
import ru.fewizz.neid.asm.group.item.TransformerGroupItemHardcoredConstants;
import ru.fewizz.neid.asm.group.item.TransformerGroupPacketBuffer;

public class Transformer
implements IClassTransformer {
    public static final Logger LOGGER = LogManager.getLogger((String)"neid");
    public static boolean envDeobfuscated;
    private static List<TransformerGroup> transformerGroups;

    private static void addTransformerGroup(TransformerGroup group) {
        transformerGroups.add(group);
    }

    public byte[] transform(String name, String deobfName, byte[] bytes) {
        for (TransformerGroup tg : transformerGroups) {
            for (Name clazz : tg.getRequiredClasses()) {
                if (!clazz.deobfDotted.equals(deobfName)) continue;
                ClassNode cn = new ClassNode(327680);
                ClassReader cr = new ClassReader(bytes);
                cr.accept((ClassVisitor)cn, 0);
                LOGGER.info("Patching class: \"" + deobfName + "\" with Transformer Group: \"" + tg.getClass().getSimpleName() + "\"");
                tg.startTransform(cn, clazz);
                ClassWriter cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                return cw.toByteArray();
            }
        }
        return bytes;
    }

    static {
        transformerGroups = new ArrayList<TransformerGroup>();
        Transformer.addTransformerGroup(new TransformerGroupBlockHardcoredConstants());
        Transformer.addTransformerGroup(new TransformerGroupAnvilChunkLoader());
        Transformer.addTransformerGroup(new TransformerGroupChunkPrimer());
        Transformer.addTransformerGroup(new TransformerGroupWorldEdit());
        Transformer.addTransformerGroup(new TransformerGroupItemHardcoredConstants());
        Transformer.addTransformerGroup(new TransformerGroupPacketBuffer());
        transformerGroups = Collections.unmodifiableList(transformerGroups);
    }
}

