/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;

public class CrystalCalculations {
    private static Map<IConstellation, Float> fractureModifierMap = new HashMap<IConstellation, Float>(){
        {
            this.put(Constellations.aevitas, Float.valueOf(0.001f));
            this.put(Constellations.discidia, Float.valueOf(0.005f));
            this.put(Constellations.evorsio, Float.valueOf(0.001f));
            this.put(Constellations.armara, Float.valueOf(0.001f));
            this.put(Constellations.vicio, Float.valueOf(0.001f));
            this.put(Constellations.lucerna, Float.valueOf(7.0E-4f));
            this.put(Constellations.bootes, Float.valueOf(0.1f));
            this.put(Constellations.mineralis, Float.valueOf(0.007f));
            this.put(Constellations.octans, Float.valueOf(0.1f));
            this.put(Constellations.pelotrio, Float.valueOf(4.0f));
            this.put(Constellations.horologium, Float.valueOf(7.0E-4f));
            this.put(Constellations.fornax, Float.valueOf(0.009f));
        }
    };

    public static float getCollectionAmt(CrystalProperties properties, float distribution) {
        float sizeDistr = (float)properties.getSize() / 100.0f;
        return distribution * (sizeDistr *= 0.6f) * ((float)properties.getCollectiveCapability() / 100.0f);
    }

    public static float getThroughputMultiplier(CrystalProperties properties) {
        return (float)Math.sqrt((float)properties.getPurity() / 100.0f);
    }

    public static float getThroughputCap(CrystalProperties properties) {
        float sizeDistr = (float)properties.getSize() / 100.0f / 2.0f;
        return (float)(3.0 + Math.pow(sizeDistr, 2.0));
    }

    public static double getMaxRitualReduction(CrystalProperties properties) {
        double purity = Math.sqrt((double)properties.getPurity() / 100.0);
        double cutting = Math.sqrt((double)properties.getCollectiveCapability() / 100.0);
        return Math.max(1.0, purity * 2.0 + cutting * 2.0);
    }

    public static int getChannelingCapacity(CrystalProperties properties) {
        float purity = (float)Math.sqrt((float)properties.getPurity() / 100.0f);
        return Math.max(10, MathHelper.func_76141_d((float)(purity * 20.0f)));
    }

    public static float getFractureChance(int castTimes, int cap) {
        if (castTimes <= cap) {
            return 0.0f;
        }
        int remaining = castTimes - cap;
        return Math.max(1.0E-8f, (float)remaining / 500000.0f);
    }

    public static float getPerfection(CrystalProperties properties, int maxSize) {
        float purity = MathHelper.func_76133_a((double)((double)properties.getPurity() / 100.0));
        float cutting = MathHelper.func_76133_a((double)((double)properties.getCollectiveCapability() / 100.0));
        float size = MathHelper.func_76129_c((float)((float)properties.getSize() / (float)maxSize));
        return purity * cutting * size;
    }

    public static float getCstFractureModifier(IWeakConstellation channeling) {
        if (fractureModifierMap.containsKey(channeling)) {
            return fractureModifierMap.get(channeling).floatValue();
        }
        return 1.0f;
    }
}

