/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.OreTypes;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerIO;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileOreGenerator
extends TileEntitySynchronized {
    private static boolean generatingOre = false;
    private boolean structural = false;
    private int remainingGuaranteed = 0;

    public static void createStructuralTile(World world, BlockPos pos) {
        TileOreGenerator gen = new TileOreGenerator();
        gen.structural = true;
        gen.remainingGuaranteed = ConfigEntryMultiOre.guaranteedOres;
        gen.func_145834_a(world);
        gen.func_174878_a(pos);
        gen.func_145829_t();
        Chunk ch = world.func_175726_f(pos);
        ch.func_177434_r().put(pos, gen);
        world.func_175690_a(pos, (TileEntity)gen);
        gen.func_145836_u();
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (world.field_72995_K) {
            return false;
        }
        if (generatingOre) {
            return false;
        }
        if (newState.func_177230_c().getClass().equals(oldState.func_177230_c().getClass())) {
            return false;
        }
        if (this.remainingGuaranteed > 0) {
            IBlockState state;
            if (!this.isActualPlayerNearby(world, pos)) {
                return true;
            }
            generatingOre = true;
            boolean stopGen = false;
            if (!world.func_175656_a(pos, oldState)) {
                return true;
            }
            if (world instanceof WorldServer) {
                BlockCustomOre.allowCrystalHarvest = true;
                if (!MiscUtils.breakBlockWithoutPlayer((WorldServer)world, pos, oldState, false, true, true)) {
                    stopGen = true;
                }
                BlockCustomOre.allowCrystalHarvest = false;
            }
            if (!world.func_175656_a(pos, newState) || stopGen) {
                return true;
            }
            if (ConfigEntryMultiOre.oreChance == 0 || rand.nextInt(ConfigEntryMultiOre.oreChance) != 0) {
                state = Blocks.field_150348_b.func_176223_P();
            } else if (rand.nextInt(200) == 0) {
                state = BlocksAS.customOre.func_176223_P().func_177226_a(BlockCustomOre.ORE_TYPE, (Comparable)((Object)BlockCustomOre.OreType.ROCK_CRYSTAL));
            } else {
                ItemStack stack = OreTypes.TREASURE_SHRINE_GEN.getRandomOre(rand);
                state = ItemUtils.createBlockState(stack);
                if (state == null) {
                    state = Blocks.field_150348_b.func_176223_P();
                }
            }
            if (!world.func_175656_a(pos, state)) {
                return true;
            }
            if (this.structural) {
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.GEN_STRUCTURE, (Vec3i)pos);
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)pos, 32.0));
            }
            generatingOre = false;
            --this.remainingGuaranteed;
            this.markForUpdate();
            return false;
        }
        return true;
    }

    private boolean isActualPlayerNearby(World world, BlockPos pos) {
        return !world.func_175644_a(EntityPlayer.class, p -> p != null && p instanceof EntityPlayerMP && !p.field_70128_L && p.func_174818_b(pos) < 81.0 && !MiscUtils.isPlayerFakeMP((EntityPlayerMP)p)).isEmpty();
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.structural = compound.func_74767_n("struct");
        this.remainingGuaranteed = compound.func_74762_e("remaining");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            EventHandlerIO.generatorQueue.add(this);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("struct", this.structural);
        compound.func_74768_a("remaining", this.remainingGuaranteed);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playGenerateStructureEffect(PktParticleEvent pktParticleEvent) {
        BlockPos pos = pktParticleEvent.getVec().toBlockPos();
        for (int i = 0; i < 40 + rand.nextInt(30); ++i) {
            Vector3 particlePos = new Vector3((float)(pos.func_177958_n() - 3) + rand.nextFloat() * 7.0f, (float)(pos.func_177956_o() - 3) + rand.nextFloat() * 7.0f, (float)(pos.func_177952_p() - 3) + rand.nextFloat() * 7.0f);
            Vector3 dir = particlePos.clone().subtract((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).normalize().divide(-30.0);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(particlePos.getX(), particlePos.getY(), particlePos.getZ());
            p.motion(dir.getX(), dir.getY(), dir.getZ()).setAlphaMultiplier(1.0f).setMaxAge(rand.nextInt(40) + 20);
            p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(0.2f + rand.nextFloat() * 0.1f).setColor(Constellations.armara.getConstellationColor());
        }
    }

    public static class ConfigEntryMultiOre
    extends ConfigEntry {
        public static final ConfigEntryMultiOre instance = new ConfigEntryMultiOre();
        private static int guaranteedOres = 550;
        private static int chanceDespawn = 100;
        private static int oreChance = 2;

        private ConfigEntryMultiOre() {
            super(ConfigEntry.Section.MACHINERY, "multi-ore");
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            guaranteedOres = cfg.getInt("guaranteedBlocks", this.getConfigurationSection(), guaranteedOres, 0, Integer.MAX_VALUE, "This value defines how often the block can be broken and will 100% respawn again.");
            chanceDespawn = cfg.getInt("chanceDespawn", this.getConfigurationSection(), chanceDespawn, 1, Integer.MAX_VALUE, "This value defines how high the chance is after 'guaranteedBlocks' has been reached that the block-respawner despawns. The higher this number, the more unlikely it is to despawn.");
            oreChance = cfg.getInt("oreChance", this.getConfigurationSection(), oreChance, 0, Integer.MAX_VALUE, "This defines how often an ore will be generated instead of a stone. The higher the number the more rare. Set to 0 to have it never generate ore, only stone.");
        }
    }
}

