/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.registry;

import hellfirepvp.astralsorcery.common.event.StarlightNetworkEvent;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimplePrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionSourceNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal.CrystalTransmissionNode;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TransmissionClassRegistry {
    public static final TransmissionClassRegistry eventInstance = new TransmissionClassRegistry();
    private static Map<String, TransmissionProvider> providerMap = new HashMap<String, TransmissionProvider>();

    private TransmissionClassRegistry() {
    }

    public void registerProvider(TransmissionProvider provider) {
        TransmissionClassRegistry.register(provider);
    }

    @Nullable
    public static TransmissionProvider getProvider(String identifier) {
        return providerMap.get(identifier);
    }

    public static void register(TransmissionProvider provider) {
        if (providerMap.containsKey(provider.getIdentifier())) {
            throw new RuntimeException("Already registered identifier TransmissionProvider: " + provider.getIdentifier());
        }
        providerMap.put(provider.getIdentifier(), provider);
    }

    public static void setupRegistry() {
        TransmissionClassRegistry.register(new SimpleTransmissionNode.Provider());
        TransmissionClassRegistry.register(new SimplePrismTransmissionNode.Provider());
        TransmissionClassRegistry.register(new SimpleTransmissionSourceNode.Provider());
        TransmissionClassRegistry.register(new CrystalTransmissionNode.Provider());
        TransmissionClassRegistry.register(new CrystalPrismTransmissionNode.Provider());
        TransmissionClassRegistry.register(new TileAltar.AltarReceiverProvider());
        TransmissionClassRegistry.register(new TileWell.WellReceiverProvider());
        TransmissionClassRegistry.register(new TileRitualPedestal.PedestalReceiverProvider());
        TransmissionClassRegistry.register(new TileStarlightInfuser.StarlightInfuserReceiverProvider());
        TransmissionClassRegistry.register(new TileTreeBeacon.TreeBeaconReceiverProvider());
        MinecraftForge.EVENT_BUS.post((Event)new StarlightNetworkEvent.TransmissionRegister(eventInstance));
    }

    public static interface TransmissionProvider {
        public IPrismTransmissionNode provideEmptyNode();

        public String getIdentifier();
    }
}

