/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeLimiter;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.VanillaAttributeType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraftforge.common.MinecraftForge;

public class AttributeTypeRegistry {
    public static final String ATTR_TYPE_MELEE_DAMAGE = "astralsorcery.meleeattackdamage";
    public static final String ATTR_TYPE_PROJ_DAMAGE = "astralsorcery.projectileattackdamage";
    public static final String ATTR_TYPE_PROJ_SPEED = "astralsorcery.projectilespeed";
    public static final String ATTR_TYPE_HEALTH = "astralsorcery.maxhealth";
    public static final String ATTR_TYPE_MOVESPEED = "astralsorcery.movespeed";
    public static final String ATTR_TYPE_SWIMSPEED = "astralsorcery.swimspeed";
    public static final String ATTR_TYPE_ARMOR = "astralsorcery.armor";
    public static final String ATTR_TYPE_ARMOR_TOUGHNESS = "astralsorcery.armortoughness";
    public static final String ATTR_TYPE_ATTACK_SPEED = "astralsorcery.attackspeed";
    public static final String ATTR_TYPE_REACH = "astralsorcery.reach";
    public static final String ATTR_TYPE_LIFE_RECOVERY = "astralsorcery.liferecovery";
    public static final String ATTR_TYPE_POTION_DURATION = "astralsorcery.potionduration";
    public static final String ATTR_TYPE_BLEED_DURATION = "astralsorcery.bleedduration";
    public static final String ATTR_TYPE_BLEED_STACKS = "astralsorcery.bleedamount";
    public static final String ATTR_TYPE_BLEED_CHANCE = "astralsorcery.bleedchance";
    public static final String ATTR_TYPE_RAMPAGE_DURATION = "astralsorcery.rampageduration";
    public static final String ATTR_TYPE_MINING_CHAIN_CHANCE = "astralsorcery.chainchance";
    public static final String ATTR_TYPE_MINING_CHAIN_LENGTH = "astralsorcery.chainlength";
    public static final String ATTR_TYPE_MINING_CHAIN_SUCCESSIVECHAIN = "astralsorcery.chainchancing";
    public static final String ATTR_TYPE_ATTACK_LIFE_LEECH = "astralsorcery.lifeleech";
    public static final String ATTR_TYPE_ARC_CHAINS = "astralsorcery.archops";
    public static final String ATTR_TYPE_INC_PERK_EFFECT = "astralsorcery.perkeffect";
    public static final String ATTR_TYPE_INC_HARVEST_SPEED = "astralsorcery.harvestspeed";
    public static final String ATTR_TYPE_INC_CRIT_CHANCE = "astralsorcery.critchance";
    public static final String ATTR_TYPE_INC_CRIT_MULTIPLIER = "astralsorcery.critmulti";
    public static final String ATTR_TYPE_INC_ALL_ELEMENTAL_RESIST = "astralsorcery.allres";
    public static final String ATTR_TYPE_INC_PERK_EXP = "astralsorcery.expgain";
    public static final String ATTR_TYPE_INC_DODGE = "astralsorcery.dodge";
    public static final String ATTR_TYPE_INC_THORNS = "astralsorcery.thorns";
    public static final String ATTR_TYPE_INC_THORNS_RANGED = "astralsorcery.rangedthorns";
    public static final String ATTR_TYPE_INC_ENCH_EFFECT = "astralsorcery.dynenchantmenteffect";
    private static Map<String, PerkAttributeType> typeMap = new HashMap<String, PerkAttributeType>();

    AttributeTypeRegistry() {
    }

    public static void registerPerkType(PerkAttributeType type) {
        if (typeMap.putIfAbsent(type.getTypeString(), type) == null) {
            type.init();
            MinecraftForge.EVENT_BUS.register((Object)type);
        }
    }

    public static void limitPerkType(String type, float lowerBound, float upperBound) {
        PerkAttributeType pType = AttributeTypeRegistry.getType(type);
        if (pType != null) {
            AttributeTypeRegistry.limitPerkType(pType, lowerBound, upperBound);
        }
    }

    public static void limitPerkType(PerkAttributeType type, float lowerBound, float upperBound) {
        if (typeMap.containsValue(type)) {
            AttributeTypeLimiter.INSTANCE.putLimit(type, lowerBound, upperBound);
        }
    }

    public static Collection<PerkAttributeType> getTypes() {
        return ImmutableList.copyOf(typeMap.values());
    }

    @Nullable
    public static PerkAttributeType getType(String typeStr) {
        return typeMap.get(typeStr);
    }

    @Nullable
    public static PerkAttributeType findType(IAttribute vanillaType) {
        return MiscUtils.iterativeSearch(typeMap.values(), type -> type instanceof VanillaAttributeType && ((VanillaAttributeType)type).getAttribute() != null && ((VanillaAttributeType)type).getAttribute().equals(vanillaType));
    }
}

